/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.Entity;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InjectingEntityResolver
implements EntityResolver {
    private static final String TYPE_ENTITY = "____type";
    private EntityResolver resolver;
    private List entities;
    private boolean injected;
    private String type;
    private Log log;

    public InjectingEntityResolver(List entities, EntityResolver resolver, String type, Log log) {
        this.resolver = resolver;
        this.entities = entities;
        this.injected = false;
        this.log = log;
        this.type = type;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source;
        if (systemId.endsWith("docbkx." + this.type + ".ent")) {
            this.log.debug((CharSequence)"Handling type specific entities.");
            try {
                File file = new File(new URI(systemId));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Searching for " + file.getAbsolutePath()));
                }
                if (!file.exists()) {
                    this.log.debug((CharSequence)"File does not exist, so returning empty file.");
                    return new InputSource(new StringReader(""));
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if ((source = this.resolver.resolveEntity(publicId, systemId)) == null) {
            return null;
        }
        if (!this.injected) {
            this.injected = true;
            return new ReplacementInputSource(source.getSystemId());
        }
        return source;
    }

    public void forceInjection() {
        this.injected = false;
    }

    public class ReplacementInputSource
    extends InputSource {
        private String followUpSystemId;

        public ReplacementInputSource(String followUpSystemId) {
            this.followUpSystemId = followUpSystemId;
        }

        public InputStream getByteStream() {
            return null;
        }

        public Reader getCharacterStream() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<!ENTITY % ____next SYSTEM \"");
            buffer.append(this.followUpSystemId);
            buffer.append("\">\n");
            buffer.append("%____next;\n");
            Iterator iterator = InjectingEntityResolver.this.entities.iterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                buffer.append("<!ENTITY ");
                buffer.append(entity.getName());
                buffer.append(" \"");
                buffer.append(entity.getValue());
                buffer.append("\">\n");
            }
            buffer.append("<!ENTITY % ").append(InjectingEntityResolver.TYPE_ENTITY).append(" SYSTEM \"docbkx.");
            buffer.append(InjectingEntityResolver.this.type);
            buffer.append(".ent\">\n");
            buffer.append("%").append(InjectingEntityResolver.TYPE_ENTITY).append(";\n");
            if (InjectingEntityResolver.this.log.isDebugEnabled()) {
                InjectingEntityResolver.this.log.debug((CharSequence)buffer.toString());
            }
            return new StringReader(buffer.toString());
        }

        public String getEncoding() {
            return null;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }

        public void setByteStream(InputStream byteStream) {
        }

        public void setCharacterStream(Reader characterStream) {
        }

        public void setEncoding(String encoding) {
        }

        public void setPublicId(String publicId) {
        }

        public void setSystemId(String systemId) {
        }
    }
}

