/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.content.ShapeTrimPath;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;

class ShapeTrimPathParser {
    private static JsonReader.Options NAMES = JsonReader.Options.of("s", "e", "o", "nm", "m", "hd");

    private ShapeTrimPathParser() {
    }

    static ShapeTrimPath parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        ShapeTrimPath.Type type = null;
        AnimatableFloatValue start = null;
        AnimatableFloatValue end = null;
        AnimatableFloatValue offset = null;
        boolean hidden = false;
        block8: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    start = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block8;
                }
                case 1: {
                    end = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block8;
                }
                case 2: {
                    offset = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block8;
                }
                case 3: {
                    name = reader.nextString();
                    continue block8;
                }
                case 4: {
                    type = ShapeTrimPath.Type.forId(reader.nextInt());
                    continue block8;
                }
                case 5: {
                    hidden = reader.nextBoolean();
                    continue block8;
                }
            }
            reader.skipValue();
        }
        return new ShapeTrimPath(name, type, start, end, offset, hidden);
    }
}

