/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.googledirection.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.akexorcist.googledirection.model.Bound;
import com.akexorcist.googledirection.model.Fare;
import com.akexorcist.googledirection.model.Leg;
import com.akexorcist.googledirection.model.RoutePolyline;
import com.google.gson.annotations.SerializedName;
import java.util.List;

public class Route
implements Parcelable {
    @SerializedName(value="bounds")
    private Bound bound;
    @SerializedName(value="copyrights")
    private String copyrights;
    @SerializedName(value="legs")
    private List<Leg> legList;
    @SerializedName(value="overview_polyline")
    private RoutePolyline overviewPolyline;
    @SerializedName(value="summary")
    private String summary;
    @SerializedName(value="fare")
    private Fare fare;
    @SerializedName(value="warnings")
    private List<String> warningList;
    @SerializedName(value="waypoint_order")
    private List<Long> waypointOrderList;
    public static final Parcelable.Creator<Route> CREATOR = new Parcelable.Creator<Route>(){

        public Route createFromParcel(Parcel in) {
            return new Route(in);
        }

        public Route[] newArray(int size) {
            return new Route[size];
        }
    };

    public Route() {
    }

    protected Route(Parcel in) {
        this.bound = (Bound)in.readParcelable(Bound.class.getClassLoader());
        this.copyrights = in.readString();
        this.overviewPolyline = (RoutePolyline)in.readParcelable(RoutePolyline.class.getClassLoader());
        this.summary = in.readString();
        this.fare = (Fare)in.readParcelable(Fare.class.getClassLoader());
        this.warningList = in.createStringArrayList();
    }

    public Bound getBound() {
        return this.bound;
    }

    public void setBound(Bound bound) {
        this.bound = bound;
    }

    public String getCopyrights() {
        return this.copyrights;
    }

    public void setCopyrights(String copyrights) {
        this.copyrights = copyrights;
    }

    public List<Leg> getLegList() {
        return this.legList;
    }

    public void setLegList(List<Leg> legList) {
        this.legList = legList;
    }

    public RoutePolyline getOverviewPolyline() {
        return this.overviewPolyline;
    }

    public void setOverviewPolyline(RoutePolyline overviewPolyline) {
        this.overviewPolyline = overviewPolyline;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Fare getFare() {
        return this.fare;
    }

    public void setFare(Fare fare) {
        this.fare = fare;
    }

    public List<String> getWarningList() {
        return this.warningList;
    }

    public void setWarningList(List<String> warningList) {
        this.warningList = warningList;
    }

    public List<Long> getWaypointOrderList() {
        return this.waypointOrderList;
    }

    public void setWaypointOrderList(List<Long> waypointOrderList) {
        this.waypointOrderList = waypointOrderList;
    }

    public Long getTotalDistance() {
        if (this.legList == null || this.legList.size() == 0) {
            return 0L;
        }
        Long totalDistance = 0L;
        for (Leg leg : this.legList) {
            totalDistance = totalDistance + leg.getDistance().getValue();
        }
        return totalDistance;
    }

    public Long getTotalDuration() {
        if (this.legList == null || this.legList.size() == 0) {
            return 0L;
        }
        Long totalDuration = 0L;
        for (Leg leg : this.legList) {
            totalDuration = totalDuration + leg.getDuration().getValue();
        }
        return totalDuration;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeParcelable((Parcelable)this.bound, i);
        parcel.writeString(this.copyrights);
        parcel.writeParcelable((Parcelable)this.overviewPolyline, i);
        parcel.writeString(this.summary);
        parcel.writeParcelable((Parcelable)this.fare, i);
        parcel.writeStringList(this.warningList);
    }
}

