/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.googledirection.request;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.akexorcist.googledirection.request.DirectionRequest;
import com.google.android.gms.maps.model.LatLng;
import java.util.ArrayList;
import java.util.List;

public class DirectionDestinationRequest {
    @NonNull
    private String apiKey;
    @NonNull
    private LatLng origin;
    @Nullable
    private List<LatLng> waypointList;

    public DirectionDestinationRequest(@NonNull String apiKey, @NonNull LatLng origin) {
        this.apiKey = apiKey;
        this.origin = origin;
    }

    public DirectionDestinationRequest and(@NonNull LatLng waypoint) {
        if (this.waypointList == null) {
            this.waypointList = new ArrayList<LatLng>();
        }
        this.waypointList.add(waypoint);
        return this;
    }

    public DirectionDestinationRequest and(@NonNull List<LatLng> waypointList) {
        if (this.waypointList == null) {
            this.waypointList = new ArrayList<LatLng>();
        }
        this.waypointList.addAll(waypointList);
        return this;
    }

    public DirectionRequest to(@NonNull LatLng destination) {
        return new DirectionRequest(this.apiKey, this.origin, destination, this.waypointList);
    }
}

