/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.googledirection.request;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.akexorcist.googledirection.DirectionCallback;
import com.akexorcist.googledirection.model.Direction;
import com.akexorcist.googledirection.network.DirectionConnection;
import com.akexorcist.googledirection.request.DirectionRequestParam;
import com.akexorcist.googledirection.request.DirectionTask;
import com.google.android.gms.maps.model.LatLng;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class DirectionRequest {
    private DirectionRequestParam param;

    public DirectionRequest(@NonNull String apiKey, @NonNull LatLng origin, @NonNull LatLng destination, @Nullable List<LatLng> waypointList) {
        this.param = new DirectionRequestParam().setApiKey(apiKey).setOrigin(origin).setDestination(destination).setWaypoints(waypointList);
    }

    public DirectionRequest transportMode(@Nullable String transportMode) {
        this.param.setTransportMode(transportMode);
        return this;
    }

    public DirectionRequest language(@Nullable String language) {
        this.param.setLanguage(language);
        return this;
    }

    public DirectionRequest unit(@Nullable String unit) {
        this.param.setUnit(unit);
        return this;
    }

    public DirectionRequest avoid(@Nullable String avoid) {
        String oldAvoid = this.param.getAvoid();
        oldAvoid = oldAvoid != null && !oldAvoid.isEmpty() ? oldAvoid + "|" : "";
        oldAvoid = oldAvoid + avoid;
        this.param.setAvoid(oldAvoid);
        return this;
    }

    public DirectionRequest transitMode(@Nullable String transitMode) {
        String oldTransitMode = this.param.getTransitMode();
        oldTransitMode = oldTransitMode != null && !oldTransitMode.isEmpty() ? oldTransitMode + "|" : "";
        oldTransitMode = oldTransitMode + transitMode;
        this.param.setTransitMode(oldTransitMode);
        return this;
    }

    public DirectionRequest trafficMode(@Nullable String trafficModel) {
        this.param.setTrafficModel(trafficModel);
        return this;
    }

    public DirectionRequest transitRoutingPreference(@Nullable String transitRoutingPreference) {
        this.param.setTransitRoutingPreference(transitRoutingPreference);
        return this;
    }

    public DirectionRequest alternativeRoute(boolean alternative) {
        this.param.setAlternatives(alternative);
        return this;
    }

    public DirectionRequest departureTime(@Nullable String time) {
        this.param.setDepartureTime(time);
        return this;
    }

    public DirectionRequest optimizeWaypoints(boolean optimize) {
        this.param.setOptimizeWaypoints(optimize);
        return this;
    }

    public DirectionTask execute(final @Nullable DirectionCallback callback) {
        String origin = null;
        if (this.param.getOrigin() != null) {
            origin = this.param.getOrigin().latitude + "," + this.param.getOrigin().longitude;
        }
        String destination = null;
        if (this.param.getDestination() != null) {
            destination = this.param.getDestination().latitude + "," + this.param.getDestination().longitude;
        }
        Call<Direction> direction = DirectionConnection.getInstance().createService().getDirection(origin, destination, this.waypointsToString(this.param.getWaypoints()), this.param.getTransportMode(), this.param.getDepartureTime(), this.param.getLanguage(), this.param.getUnit(), this.param.getAvoid(), this.param.getTransitMode(), this.param.getTrafficModel(), this.param.getTransitRoutingPreference(), this.param.isAlternatives(), this.param.getApiKey());
        direction.enqueue((Callback)new Callback<Direction>(){

            public void onResponse(@NotNull Call<Direction> call, @NotNull Response<Direction> response) {
                if (callback != null) {
                    callback.onDirectionSuccess((Direction)response.body());
                }
            }

            public void onFailure(@NotNull Call<Direction> call, @NotNull Throwable t) {
                if (callback != null) {
                    callback.onDirectionFailure(t);
                }
            }
        });
        return new DirectionTask(direction);
    }

    private String waypointsToString(@Nullable List<LatLng> waypoints) {
        if (waypoints != null && !waypoints.isEmpty()) {
            StringBuilder string = new StringBuilder(this.param.isOptimizeWaypoints() ? "optimize:true|" : "");
            string.append(waypoints.get((int)0).latitude).append(",").append(waypoints.get((int)0).longitude);
            for (int i = 1; i < waypoints.size(); ++i) {
                string.append("|").append(waypoints.get((int)i).latitude).append(",").append(waypoints.get((int)i).longitude);
            }
            return string.toString();
        }
        return null;
    }
}

