/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.googledirection.util;

import android.content.Context;
import android.util.DisplayMetrics;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.akexorcist.googledirection.model.Step;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.PolylineOptions;
import java.util.ArrayList;
import java.util.List;

public class DirectionConverter {
    public static ArrayList<LatLng> getDirectionPoint(List<Step> stepList) {
        ArrayList<LatLng> directionPointList = new ArrayList<LatLng>();
        if (stepList != null && stepList.size() > 0) {
            for (Step step : stepList) {
                DirectionConverter.convertStepToPosition(step, directionPointList);
            }
        }
        return directionPointList;
    }

    private static void convertStepToPosition(Step step, ArrayList<LatLng> directionPointList) {
        List<LatLng> decodedPointList;
        directionPointList.add(step.getStartLocation().getCoordination());
        if (step.getPolyline() != null && (decodedPointList = step.getPolyline().getPointList()) != null && decodedPointList.size() > 0) {
            directionPointList.addAll(decodedPointList);
        }
        directionPointList.add(step.getEndLocation().getCoordination());
    }

    public static ArrayList<LatLng> getSectionPoint(List<Step> stepList) {
        ArrayList<LatLng> directionPointList = new ArrayList<LatLng>();
        if (stepList != null && stepList.size() > 0) {
            directionPointList.add(stepList.get(0).getStartLocation().getCoordination());
            for (Step step : stepList) {
                directionPointList.add(step.getEndLocation().getCoordination());
            }
        }
        return directionPointList;
    }

    public static PolylineOptions createPolyline(@NonNull Context context, @NonNull PathOption pathOption) {
        return DirectionConverter.createPolyline(context, pathOption.locationList, pathOption.width, pathOption.color, pathOption.clickable, pathOption.jointType, pathOption.startCap, pathOption.endCap, pathOption.patternItemList);
    }

    public static PolylineOptions createPolyline(@NonNull Context context, @Nullable ArrayList<LatLng> locationList, @Dimension(unit=0) int width, @ColorInt int color) {
        return DirectionConverter.createPolyline(context, locationList, width, color, true, 0, null, null, null);
    }

    public static PolylineOptions createPolyline(@NonNull Context context, @Nullable ArrayList<LatLng> locationList, @Dimension(unit=0) int width, @ColorInt int color, boolean clickable) {
        return DirectionConverter.createPolyline(context, locationList, width, color, clickable, 0, null, null, null);
    }

    public static PolylineOptions createPolyline(@NonNull Context context, @Nullable ArrayList<LatLng> locationList, @Dimension(unit=0) int width, @ColorInt int color, boolean clickable, int jointType) {
        return DirectionConverter.createPolyline(context, locationList, width, color, clickable, jointType, null, null, null);
    }

    public static PolylineOptions createPolyline(@NonNull Context context, @Nullable ArrayList<LatLng> locationList, @Dimension(unit=0) int width, @ColorInt int color, boolean clickable, @Nullable Cap startCap, @Nullable Cap endCap) {
        return DirectionConverter.createPolyline(context, locationList, width, color, clickable, 0, startCap, endCap, null);
    }

    public static PolylineOptions createPolyline(@NonNull Context context, @Nullable ArrayList<LatLng> locationList, @Dimension(unit=0) int width, @ColorInt int color, boolean clickable, @Nullable List<PatternItem> patternItemList) {
        return DirectionConverter.createPolyline(context, locationList, width, color, clickable, 0, null, null, patternItemList);
    }

    public static PolylineOptions createPolyline(@NonNull Context context, @Nullable ArrayList<LatLng> locationList, @Dimension(unit=0) int width, @ColorInt int color, boolean clickable, int jointType, @Nullable Cap startCap, @Nullable Cap endCap, @Nullable List<PatternItem> patternItemList) {
        PolylineOptions rectLine = new PolylineOptions().width((float)DirectionConverter.dpToPx(context, width)).color(color).geodesic(true);
        rectLine.clickable(clickable);
        rectLine.jointType(jointType);
        if (patternItemList != null) {
            rectLine.pattern(patternItemList);
        }
        if (startCap != null) {
            rectLine.startCap(startCap);
        }
        if (endCap != null) {
            rectLine.endCap(endCap);
        }
        if (locationList != null && locationList.size() > 0) {
            for (LatLng location : locationList) {
                rectLine.add(location);
            }
        }
        return rectLine;
    }

    public static ArrayList<PolylineOptions> createTransitPolyline(@NonNull Context context, @NonNull TransitPathOption transitPathOption) {
        return DirectionConverter.createTransitPolyline(context, transitPathOption.stepList, transitPathOption.transitWidth, transitPathOption.transitColor, transitPathOption.transitPatternItemList, transitPathOption.walkingWidth, transitPathOption.walkingColor, transitPathOption.walkingPatternItemList, transitPathOption.clickable, transitPathOption.jointType, transitPathOption.startCap, transitPathOption.endCap);
    }

    public static ArrayList<PolylineOptions> createTransitPolyline(@NonNull Context context, @Nullable List<Step> stepList, @Dimension(unit=0) int transitWidth, @ColorInt int transitColor, @Dimension(unit=0) int walkingWidth, @ColorInt int walkingColor) {
        return DirectionConverter.createTransitPolyline(context, stepList, transitWidth, transitColor, null, walkingWidth, walkingColor, null, true, 0, null, null);
    }

    public static ArrayList<PolylineOptions> createTransitPolyline(@NonNull Context context, @Nullable List<Step> stepList, @Dimension(unit=0) int transitWidth, @Nullable List<PatternItem> transitPatternItemList, @ColorInt int transitColor, @Dimension(unit=0) int walkingWidth, @ColorInt int walkingColor, @Nullable List<PatternItem> walkingPatternItemList) {
        return DirectionConverter.createTransitPolyline(context, stepList, transitWidth, transitColor, transitPatternItemList, walkingWidth, walkingColor, walkingPatternItemList, true, 0, null, null);
    }

    public static ArrayList<PolylineOptions> createTransitPolyline(@NonNull Context context, @Nullable List<Step> stepList, @Dimension(unit=0) int transitWidth, @ColorInt int transitColor, @Dimension(unit=0) int walkingWidth, @ColorInt int walkingColor, boolean clickable) {
        return DirectionConverter.createTransitPolyline(context, stepList, transitWidth, transitColor, null, walkingWidth, walkingColor, null, clickable, 0, null, null);
    }

    public static ArrayList<PolylineOptions> createTransitPolyline(@NonNull Context context, @Nullable List<Step> stepList, @Dimension(unit=0) int transitWidth, @ColorInt int transitColor, @Dimension(unit=0) int walkingWidth, @ColorInt int walkingColor, boolean clickable, int jointType) {
        return DirectionConverter.createTransitPolyline(context, stepList, transitWidth, transitColor, null, walkingWidth, walkingColor, null, clickable, jointType, null, null);
    }

    public static ArrayList<PolylineOptions> createTransitPolyline(@NonNull Context context, @Nullable List<Step> stepList, @Dimension(unit=0) int transitWidth, @ColorInt int transitColor, @Dimension(unit=0) int walkingWidth, @ColorInt int walkingColor, boolean clickable, @Nullable Cap startCap, @Nullable Cap endCap) {
        return DirectionConverter.createTransitPolyline(context, stepList, transitWidth, transitColor, null, walkingWidth, walkingColor, null, clickable, 0, startCap, endCap);
    }

    public static ArrayList<PolylineOptions> createTransitPolyline(@NonNull Context context, @Nullable List<Step> stepList, @Dimension(unit=0) int transitWidth, @ColorInt int transitColor, @Nullable List<PatternItem> transitPatternItemList, @Dimension(unit=0) int walkingWidth, @ColorInt int walkingColor, @Nullable List<PatternItem> walkingPatternItemList, boolean clickable, int jointType, @Nullable Cap startCap, @Nullable Cap endCap) {
        ArrayList<PolylineOptions> polylineOptionsList = new ArrayList<PolylineOptions>();
        if (stepList != null && stepList.size() > 0) {
            for (Step step : stepList) {
                ArrayList<LatLng> directionPointList = new ArrayList<LatLng>();
                DirectionConverter.convertStepToPosition(step, directionPointList);
                if (step.isContainStepList()) {
                    polylineOptionsList.add(DirectionConverter.createPolyline(context, directionPointList, walkingWidth, walkingColor, clickable, jointType, startCap, endCap, walkingPatternItemList));
                    continue;
                }
                polylineOptionsList.add(DirectionConverter.createPolyline(context, directionPointList, transitWidth, transitColor, clickable, jointType, startCap, endCap, transitPatternItemList));
            }
        }
        return polylineOptionsList;
    }

    private static int dpToPx(@NonNull Context context, int dp) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return Math.round(dp * (displayMetrics.densityDpi / 160));
    }

    public static class TransitPathOption {
        List<Step> stepList = null;
        int transitWidth;
        int transitColor;
        List<PatternItem> transitPatternItemList;
        int walkingWidth;
        int walkingColor;
        List<PatternItem> walkingPatternItemList;
        boolean clickable;
        int jointType;
        Cap startCap;
        Cap endCap;

        public List<Step> getStepList() {
            return this.stepList;
        }

        public TransitPathOption setStepList(List<Step> stepList) {
            this.stepList = stepList;
            return this;
        }

        public int getTransitWidth() {
            return this.transitWidth;
        }

        public TransitPathOption setTransitWidth(@Dimension(unit=0) int transitWidth) {
            this.transitWidth = transitWidth;
            return this;
        }

        public int getTransitColor() {
            return this.transitColor;
        }

        public TransitPathOption setTransitColor(@ColorInt int transitColor) {
            this.transitColor = transitColor;
            return this;
        }

        @Nullable
        public List<PatternItem> getTransitPatternItemList() {
            return this.transitPatternItemList;
        }

        public TransitPathOption setTransitPatternItemList(@Nullable List<PatternItem> transitPatternItemList) {
            this.transitPatternItemList = transitPatternItemList;
            return this;
        }

        public int getWalkingWidth() {
            return this.walkingWidth;
        }

        public TransitPathOption setWalkingWidth(@Dimension(unit=0) int walkingWidth) {
            this.walkingWidth = walkingWidth;
            return this;
        }

        public int getWalkingColor() {
            return this.walkingColor;
        }

        public TransitPathOption setWalkingColor(@ColorInt int walkingColor) {
            this.walkingColor = walkingColor;
            return this;
        }

        @Nullable
        public List<PatternItem> getWalkingPatternItemList() {
            return this.walkingPatternItemList;
        }

        public TransitPathOption setWalkingPatternItemList(@Nullable List<PatternItem> walkingPatternItemList) {
            this.walkingPatternItemList = walkingPatternItemList;
            return this;
        }

        public boolean isClickable() {
            return this.clickable;
        }

        public TransitPathOption setClickable(boolean clickable) {
            this.clickable = clickable;
            return this;
        }

        public int getJointType() {
            return this.jointType;
        }

        public TransitPathOption setJointType(int jointType) {
            this.jointType = jointType;
            return this;
        }

        @Nullable
        public Cap getStartCap() {
            return this.startCap;
        }

        public TransitPathOption setStartCap(@Nullable Cap startCap) {
            this.startCap = startCap;
            return this;
        }

        @Nullable
        public Cap getEndCap() {
            return this.endCap;
        }

        public TransitPathOption setEndCap(@Nullable Cap endCap) {
            this.endCap = endCap;
            return this;
        }
    }

    public static class PathOption {
        ArrayList<LatLng> locationList;
        int width;
        int color;
        boolean clickable;
        int jointType;
        Cap startCap;
        Cap endCap;
        List<PatternItem> patternItemList;

        public ArrayList<LatLng> getLocationList() {
            return this.locationList;
        }

        public PathOption setLocationList(ArrayList<LatLng> locationList) {
            this.locationList = locationList;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public PathOption setWidth(@Dimension(unit=0) int width) {
            this.width = width;
            return this;
        }

        public int getColor() {
            return this.color;
        }

        public PathOption setColor(@ColorInt int color) {
            this.color = color;
            return this;
        }

        public boolean isClickable() {
            return this.clickable;
        }

        public PathOption setClickable(boolean clickable) {
            this.clickable = clickable;
            return this;
        }

        public int getJointType() {
            return this.jointType;
        }

        public PathOption setJointType(int jointType) {
            this.jointType = jointType;
            return this;
        }

        public Cap getStartCap() {
            return this.startCap;
        }

        public PathOption setStartCap(Cap startCap) {
            this.startCap = startCap;
            return this;
        }

        public Cap getEndCap() {
            return this.endCap;
        }

        public PathOption setEndCap(Cap endCap) {
            this.endCap = endCap;
            return this;
        }

        public List<PatternItem> getPatternItemList() {
            return this.patternItemList;
        }

        public PathOption setPatternItemList(List<PatternItem> patternItemList) {
            this.patternItemList = patternItemList;
            return this;
        }
    }
}

