/*
 * Decompiled with CFR 0.152.
 */
package com.tmall.ultraviewpager;

import android.os.Handler;
import android.os.Message;
import android.util.SparseIntArray;
import com.tmall.ultraviewpager.UltraViewPager;

class TimerHandler
extends Handler {
    SparseIntArray specialInterval;
    long interval;
    boolean isStopped = true;
    TimerHandlerListener listener;
    UltraViewPager mUltraViewPager;
    static final int MSG_TIMER_ID = 87108;

    TimerHandler(UltraViewPager ultraViewPager, TimerHandlerListener listener, long interval) {
        this.mUltraViewPager = ultraViewPager;
        this.listener = listener;
        this.interval = interval;
    }

    public void handleMessage(Message msg) {
        if (87108 == msg.what) {
            int nextIndex = this.mUltraViewPager.getNextItem();
            if (this.listener != null) {
                this.listener.callBack();
            }
            this.tick(nextIndex);
        }
    }

    public void tick(int index) {
        this.sendEmptyMessageDelayed(87108, this.getNextInterval(index));
    }

    private long getNextInterval(int index) {
        long has;
        long next = this.interval;
        if (this.specialInterval != null && (has = (long)this.specialInterval.get(index, -1)) > 0L) {
            next = has;
        }
        return next;
    }

    static interface TimerHandlerListener {
        public void callBack();
    }
}

