/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.compiler.processor;

import com.alibaba.android.arouter.compiler.utils.Logger;
import com.alibaba.android.arouter.compiler.utils.TypeUtils;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.enums.TypeKind;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

@SupportedOptions(value={"AROUTER_MODULE_NAME"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"com.alibaba.android.arouter.facade.annotation.Autowired"})
@AutoService(value=Processor.class)
public class AutowiredProcessor
extends AbstractProcessor {
    private Filer mFiler;
    private Logger logger;
    private Types types;
    private TypeUtils typeUtils;
    private Elements elements;
    private Map<TypeElement, List<Element>> parentAndChild = new HashMap<TypeElement, List<Element>>();
    private static final ClassName ARouterClass = ClassName.get((String)"com.alibaba.android.arouter.launcher", (String)"ARouter", (String[])new String[0]);
    private static final ClassName AndroidLog = ClassName.get((String)"android.util", (String)"Log", (String[])new String[0]);

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.mFiler = this.processingEnv.getFiler();
        this.types = this.processingEnv.getTypeUtils();
        this.elements = this.processingEnv.getElementUtils();
        this.typeUtils = new TypeUtils(this.types, this.elements);
        this.logger = new Logger(this.processingEnv.getMessager());
        this.logger.info(">>> AutowiredProcessor init. <<<");
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (CollectionUtils.isNotEmpty(set)) {
            try {
                this.logger.info(">>> Found autowired field, start... <<<");
                this.categories(roundEnvironment.getElementsAnnotatedWith(Autowired.class));
                this.generateHelper();
            }
            catch (Exception e) {
                this.logger.error(e);
            }
            return true;
        }
        return false;
    }

    private void generateHelper() throws IOException, IllegalAccessException {
        TypeElement type_ISyringe = this.elements.getTypeElement("com.alibaba.android.arouter.facade.template.ISyringe");
        TypeElement type_JsonService = this.elements.getTypeElement("com.alibaba.android.arouter.facade.service.SerializationService");
        TypeMirror iProvider = this.elements.getTypeElement("com.alibaba.android.arouter.facade.template.IProvider").asType();
        TypeMirror activityTm = this.elements.getTypeElement("android.app.Activity").asType();
        TypeMirror fragmentTm = this.elements.getTypeElement("android.app.Fragment").asType();
        TypeMirror fragmentTmV4 = this.elements.getTypeElement("android.support.v4.app.Fragment").asType();
        ParameterSpec objectParamSpec = ParameterSpec.builder((TypeName)TypeName.OBJECT, (String)"target", (Modifier[])new Modifier[0]).build();
        if (MapUtils.isNotEmpty(this.parentAndChild)) {
            for (Map.Entry<TypeElement, List<Element>> entry : this.parentAndChild.entrySet()) {
                MethodSpec.Builder injectMethodBuilder = MethodSpec.methodBuilder((String)"inject").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(objectParamSpec);
                TypeElement parent = entry.getKey();
                List<Element> childs = entry.getValue();
                String qualifiedName = parent.getQualifiedName().toString();
                String packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
                String fileName = parent.getSimpleName() + "$$ARouter$$Autowired";
                this.logger.info(">>> Start process " + childs.size() + " field in " + parent.getSimpleName() + " ... <<<");
                TypeSpec.Builder helper = TypeSpec.classBuilder((String)fileName).addJavadoc("DO NOT EDIT THIS FILE!!! IT WAS GENERATED BY AROUTER.", new Object[0]).addSuperinterface((TypeName)ClassName.get((TypeElement)type_ISyringe)).addModifiers(new Modifier[]{Modifier.PUBLIC});
                FieldSpec jsonServiceField = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)type_JsonService.asType()), (String)"serializationService", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
                helper.addField(jsonServiceField);
                injectMethodBuilder.addStatement("serializationService = $T.getInstance().navigation($T.class)", new Object[]{ARouterClass, ClassName.get((TypeElement)type_JsonService)});
                injectMethodBuilder.addStatement("$T substitute = ($T)target", new Object[]{ClassName.get((TypeElement)parent), ClassName.get((TypeElement)parent)});
                for (Element element : childs) {
                    Autowired fieldConfig = element.getAnnotation(Autowired.class);
                    String fieldName = element.getSimpleName().toString();
                    if (this.types.isSubtype(element.asType(), iProvider)) {
                        if ("".equals(fieldConfig.name())) {
                            injectMethodBuilder.addStatement("substitute." + fieldName + " = $T.getInstance().navigation($T.class)", new Object[]{ARouterClass, ClassName.get((TypeMirror)element.asType())});
                        } else {
                            injectMethodBuilder.addStatement("substitute." + fieldName + " = ($T)$T.getInstance().build($S).navigation()", new Object[]{ClassName.get((TypeMirror)element.asType()), ARouterClass, fieldConfig.name()});
                        }
                        if (!fieldConfig.required()) continue;
                        injectMethodBuilder.beginControlFlow("if (substitute." + fieldName + " == null)", new Object[0]);
                        injectMethodBuilder.addStatement("throw new RuntimeException(\"The field '" + fieldName + "' is null, in class '\" + $T.class.getName() + \"!\")", new Object[]{ClassName.get((TypeElement)parent)});
                        injectMethodBuilder.endControlFlow();
                        continue;
                    }
                    String originalValue = "substitute." + fieldName;
                    String statement = "substitute." + fieldName + " = " + this.buildCastCode(element) + "substitute.";
                    boolean isActivity = false;
                    if (this.types.isSubtype(parent.asType(), activityTm)) {
                        isActivity = true;
                        statement = statement + "getIntent().";
                    } else if (this.types.isSubtype(parent.asType(), fragmentTm) || this.types.isSubtype(parent.asType(), fragmentTmV4)) {
                        statement = statement + "getArguments().";
                    } else {
                        throw new IllegalAccessException("The field [" + fieldName + "] need autowired from intent, its parent must be activity or fragment!");
                    }
                    statement = this.buildStatement(originalValue, statement, this.typeUtils.typeExchange(element), isActivity);
                    if (statement.startsWith("serializationService.")) {
                        injectMethodBuilder.beginControlFlow("if (null != serializationService)", new Object[0]);
                        injectMethodBuilder.addStatement("substitute." + fieldName + " = " + statement, new Object[]{StringUtils.isEmpty((CharSequence)fieldConfig.name()) ? fieldName : fieldConfig.name(), ClassName.get((TypeMirror)element.asType())});
                        injectMethodBuilder.nextControlFlow("else", new Object[0]);
                        injectMethodBuilder.addStatement("$T.e(\"ARouter::\", \"You want automatic inject the field '" + fieldName + "' in class '$T' , then you should implement 'SerializationService' to support object auto inject!\")", new Object[]{AndroidLog, ClassName.get((TypeElement)parent)});
                        injectMethodBuilder.endControlFlow();
                    } else {
                        injectMethodBuilder.addStatement(statement, new Object[]{StringUtils.isEmpty((CharSequence)fieldConfig.name()) ? fieldName : fieldConfig.name()});
                    }
                    if (!fieldConfig.required() || element.asType().getKind().isPrimitive()) continue;
                    injectMethodBuilder.beginControlFlow("if (null == substitute." + fieldName + ")", new Object[0]);
                    injectMethodBuilder.addStatement("$T.e(\"ARouter::\", \"The field '" + fieldName + "' is null, in class '\" + $T.class.getName() + \"!\")", new Object[]{AndroidLog, ClassName.get((TypeElement)parent)});
                    injectMethodBuilder.endControlFlow();
                }
                helper.addMethod(injectMethodBuilder.build());
                JavaFile.builder((String)packageName, (TypeSpec)helper.build()).build().writeTo(this.mFiler);
                this.logger.info(">>> " + parent.getSimpleName() + " has been processed, " + fileName + " has been generated. <<<");
            }
            this.logger.info(">>> Autowired processor stop. <<<");
        }
    }

    private String buildCastCode(Element element) {
        if (this.typeUtils.typeExchange(element) == TypeKind.SERIALIZABLE.ordinal()) {
            return CodeBlock.builder().add("($T) ", new Object[]{ClassName.get((TypeMirror)element.asType())}).build().toString();
        }
        return "";
    }

    private String buildStatement(String originalValue, String statement, int type, boolean isActivity) {
        if (type == TypeKind.BOOLEAN.ordinal()) {
            statement = statement + (isActivity ? "getBooleanExtra($S, " + originalValue + ")" : "getBoolean($S)");
        } else if (type == TypeKind.BYTE.ordinal()) {
            statement = statement + (isActivity ? "getByteExtra($S, " + originalValue + ")" : "getByte($S)");
        } else if (type == TypeKind.SHORT.ordinal()) {
            statement = statement + (isActivity ? "getShortExtra($S, " + originalValue + ")" : "getShort($S)");
        } else if (type == TypeKind.INT.ordinal()) {
            statement = statement + (isActivity ? "getIntExtra($S, " + originalValue + ")" : "getInt($S)");
        } else if (type == TypeKind.LONG.ordinal()) {
            statement = statement + (isActivity ? "getLongExtra($S, " + originalValue + ")" : "getLong($S)");
        } else if (type == TypeKind.CHAR.ordinal()) {
            statement = statement + (isActivity ? "getCharExtra($S, " + originalValue + ")" : "getChar($S)");
        } else if (type == TypeKind.FLOAT.ordinal()) {
            statement = statement + (isActivity ? "getFloatExtra($S, " + originalValue + ")" : "getFloat($S)");
        } else if (type == TypeKind.DOUBLE.ordinal()) {
            statement = statement + (isActivity ? "getDoubleExtra($S, " + originalValue + ")" : "getDouble($S)");
        } else if (type == TypeKind.STRING.ordinal()) {
            statement = statement + (isActivity ? "getStringExtra($S)" : "getString($S)");
        } else if (type == TypeKind.SERIALIZABLE.ordinal()) {
            statement = statement + (isActivity ? "getSerializableExtra($S)" : "getSerializable($S)");
        } else if (type == TypeKind.PARCELABLE.ordinal()) {
            statement = statement + (isActivity ? "getParcelableExtra($S)" : "getParcelable($S)");
        } else if (type == TypeKind.OBJECT.ordinal()) {
            statement = "serializationService.parseObject(substitute." + (isActivity ? "getIntent()." : "getArguments().") + (isActivity ? "getStringExtra($S)" : "getString($S)") + ", new com.alibaba.android.arouter.facade.model.TypeWrapper<$T>(){}.getType())";
        }
        return statement;
    }

    private void categories(Set<? extends Element> elements) throws IllegalAccessException {
        if (CollectionUtils.isNotEmpty(elements)) {
            for (Element element : elements) {
                TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
                if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    throw new IllegalAccessException("The inject fields CAN NOT BE 'private'!!! please check field [" + element.getSimpleName() + "] in class [" + enclosingElement.getQualifiedName() + "]");
                }
                if (this.parentAndChild.containsKey(enclosingElement)) {
                    this.parentAndChild.get(enclosingElement).add(element);
                    continue;
                }
                ArrayList<Element> childs = new ArrayList<Element>();
                childs.add(element);
                this.parentAndChild.put(enclosingElement, childs);
            }
            this.logger.info("categories finished.");
        }
    }
}

