/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractSocketConnectorHandler;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.EmptyIOEventProcessingHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;

public class UDPNIOConnectorHandler
extends AbstractSocketConnectorHandler {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOConnectorHandler.class);
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    protected boolean isReuseAddress;
    protected volatile long connectionTimeoutMillis = 30000L;

    protected UDPNIOConnectorHandler(UDPNIOTransport transport) {
        super(transport);
        this.connectionTimeoutMillis = transport.getConnectionTimeout();
        this.isReuseAddress = transport.isReuseAddress();
    }

    public GrizzlyFuture<Connection> connect() throws IOException {
        return this.connect(null, null, null);
    }

    @Override
    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        if (!this.transport.isBlocking()) {
            return this.connectAsync(remoteAddress, localAddress, completionHandler);
        }
        return this.connectSync(remoteAddress, localAddress, completionHandler);
    }

    protected GrizzlyFuture<Connection> connectSync(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        GrizzlyFuture<Connection> future = this.connectAsync(remoteAddress, localAddress, completionHandler);
        this.waitNIOFuture(future);
        return future;
    }

    protected GrizzlyFuture<Connection> connectAsync(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        UDPNIOTransport nioTransport = (UDPNIOTransport)this.transport;
        NIOConnection newConnection = null;
        try {
            DatagramChannel datagramChannel = DatagramChannel.open();
            DatagramSocket socket = datagramChannel.socket();
            newConnection = nioTransport.obtainNIOConnection(datagramChannel);
            socket.setReuseAddress(this.isReuseAddress);
            if (localAddress != null) {
                socket.bind(localAddress);
            }
            datagramChannel.configureBlocking(false);
            if (remoteAddress != null) {
                datagramChannel.connect(remoteAddress);
            }
            this.preConfigure(newConnection);
            newConnection.setProcessor(this.getProcessor());
            newConnection.setProcessorSelector(this.getProcessorSelector());
            SafeFutureImpl<Connection> connectFuture = SafeFutureImpl.create();
            NIOChannelDistributor nioChannelDistributor = nioTransport.getNIOChannelDistributor();
            if (nioChannelDistributor == null) {
                throw new IllegalStateException("NIOChannelDistributor is null. Is Transport running?");
            }
            GrizzlyFuture<RegisterChannelResult> registerChannelFuture = nioChannelDistributor.registerChannelAsync(datagramChannel, 0, newConnection, new ConnectHandler((UDPNIOConnection)newConnection, connectFuture, completionHandler));
            registerChannelFuture.markForRecycle(false);
            return connectFuture;
        }
        catch (Exception e) {
            if (newConnection != null) {
                newConnection.close();
            }
            if (completionHandler != null) {
                completionHandler.failed(e);
            }
            return ReadyFutureImpl.create(e);
        }
    }

    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    public void setReuseAddress(boolean isReuseAddress) {
        this.isReuseAddress = isReuseAddress;
    }

    public long getSyncConnectTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void setSyncConnectTimeout(long timeout, TimeUnit timeUnit) {
        this.connectionTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    protected <E> E waitNIOFuture(Future<E> future) throws IOException {
        try {
            return future.get(this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException("Connection was interrupted!");
        }
        catch (TimeoutException e) {
            throw new IOException("Channel registration on Selector timeout!");
        }
        catch (ExecutionException e) {
            Throwable internalException = e.getCause();
            if (internalException instanceof IOException) {
                throw (IOException)internalException;
            }
            throw new IOException("Unexpected exception connection exception. " + internalException.getClass().getName() + ": " + internalException.getMessage());
        }
        catch (CancellationException e) {
            throw new IOException("Connection was cancelled!");
        }
    }

    private static void fireConnectEvent(UDPNIOConnection connection, FutureImpl<Connection> connectFuture, CompletionHandler<Connection> completionHandler) throws IOException {
        try {
            UDPNIOTransport udpTransport = (UDPNIOTransport)connection.getTransport();
            udpTransport.fireIOEvent(IOEvent.CONNECTED, connection, new EnableReadHandler(connectFuture, completionHandler));
        }
        catch (Exception e) {
            UDPNIOConnectorHandler.abortConnection(connection, connectFuture, completionHandler, e);
            throw new IOException("Connect exception", e);
        }
    }

    private static void abortConnection(UDPNIOConnection connection, FutureImpl<Connection> connectFuture, CompletionHandler<Connection> completionHandler, Throwable failure) {
        try {
            connection.close();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (completionHandler != null) {
            completionHandler.failed(failure);
        }
        connectFuture.failure(failure);
    }

    public static Builder builder(UDPNIOTransport transport) {
        return new Builder(transport);
    }

    public static class Builder
    extends AbstractSocketConnectorHandler.Builder<Builder> {
        protected Builder(UDPNIOTransport transport) {
            super(new UDPNIOConnectorHandler(transport));
        }

        public UDPNIOConnectorHandler build() {
            return (UDPNIOConnectorHandler)this.connectorHandler;
        }

        public Builder setReuseAddress(boolean isReuseAddress) {
            ((UDPNIOConnectorHandler)this.connectorHandler).setReuseAddress(isReuseAddress);
            return this;
        }

        public Builder setSyncConnectTimeout(long timeout, TimeUnit timeunit) {
            ((UDPNIOConnectorHandler)this.connectorHandler).setSyncConnectTimeout(timeout, timeunit);
            return this;
        }
    }

    private static class EnableReadHandler
    extends EmptyIOEventProcessingHandler {
        private final FutureImpl<Connection> connectFuture;
        private final CompletionHandler<Connection> completionHandler;

        private EnableReadHandler(FutureImpl<Connection> connectFuture, CompletionHandler<Connection> completionHandler) {
            this.connectFuture = connectFuture;
            this.completionHandler = completionHandler;
        }

        @Override
        public void onReregister(Context context) throws IOException {
            this.onComplete(context, null);
        }

        @Override
        public void onNotRun(Context context) throws IOException {
            this.onComplete(context, null);
        }

        @Override
        public void onComplete(Context context, Object data) throws IOException {
            NIOConnection connection = (NIOConnection)context.getConnection();
            if (this.completionHandler != null) {
                this.completionHandler.completed(connection);
            }
            this.connectFuture.result(connection);
            if (!connection.isStandalone()) {
                connection.enableIOEvent(IOEvent.READ);
            }
        }
    }

    private final class ConnectHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        private final UDPNIOConnection connection;
        private final FutureImpl<Connection> connectFuture;
        private final CompletionHandler<Connection> completionHandler;

        private ConnectHandler(UDPNIOConnection connection, FutureImpl<Connection> connectFuture, CompletionHandler<Connection> completionHandler) {
            this.connection = connection;
            this.connectFuture = connectFuture;
            this.completionHandler = completionHandler;
        }

        @Override
        public void completed(RegisterChannelResult result) {
            UDPNIOTransport transport = (UDPNIOTransport)UDPNIOConnectorHandler.this.transport;
            transport.registerChannelCompletionHandler.completed(result);
            try {
                this.connection.onConnect();
                UDPNIOConnectorHandler.fireConnectEvent(this.connection, this.connectFuture, this.completionHandler);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception happened, when trying to connect the channel", e);
            }
        }

        @Override
        public void failed(Throwable throwable) {
            UDPNIOConnectorHandler.abortConnection(this.connection, this.connectFuture, this.completionHandler, throwable);
        }
    }
}

