/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.util.concurrent.BlockingQueue;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.ObjectPool;
import org.glassfish.grizzly.utils.PoolableObject;

public abstract class ConcurrentQueuePool<E extends PoolableObject>
implements ObjectPool<E> {
    private final BlockingQueue<E> pool = DataStructures.getLTQInstance();

    public abstract E newInstance();

    @Override
    public E poll() {
        PoolableObject object = (PoolableObject)this.pool.poll();
        if (object == null) {
            object = this.newInstance();
        }
        object.prepare();
        return (E)object;
    }

    @Override
    public void offer(E object) {
        object.release();
        this.pool.offer(object);
    }

    @Override
    public void clear() {
        this.pool.clear();
    }
}

