/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.validator.metadata.MethodMetaConstraint;
import org.hibernate.validator.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMetaData
implements Iterable<MethodMetaConstraint<?>> {
    private final Class<?> type;
    private final int index;
    private final String name;
    private final List<MethodMetaConstraint<?>> constraints;
    private final boolean isCascading;

    public ParameterMetaData(int index, Class<?> type, String name, List<MethodMetaConstraint<?>> constraints, boolean isCascading) {
        this.index = index;
        this.type = type;
        this.name = name;
        this.constraints = Collections.unmodifiableList(constraints);
        this.isCascading = isCascading;
    }

    public Class<?> getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public String getParameterName() {
        return this.name;
    }

    public boolean isCascading() {
        return this.isCascading;
    }

    public boolean isConstrained() {
        return this.isCascading || !this.constraints.isEmpty();
    }

    @Override
    public Iterator<MethodMetaConstraint<?>> iterator() {
        return this.constraints.iterator();
    }

    public ParameterMetaData merge(ParameterMetaData otherMetaData) {
        return new ParameterMetaData(this.index, this.type, this.name, CollectionHelper.newArrayList(this, otherMetaData), this.isCascading() || otherMetaData.isCascading());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MethodMetaConstraint<?> oneConstraint : this.constraints) {
            sb.append(oneConstraint.getDescriptor().getAnnotation().annotationType().getSimpleName());
            sb.append(", ");
        }
        String constraintsAsString = sb.length() > 0 ? sb.substring(0, sb.length() - 2) : sb.toString();
        return "ParameterMetaData [type=" + this.type + "], [index=" + this.index + "], name=" + this.name + "], constraints=[" + constraintsAsString + "], isCascading=" + this.isCascading + "]";
    }
}

