/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.monitor.simple;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;

public class CountUtils {
    private static final Logger logger = LoggerFactory.getLogger(CountUtils.class);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private static final int SUM = 0;
    private static final int MAX = 1;
    private static final int AVG = 2;

    public static long sum(File file) {
        return CountUtils.calc(file, 0);
    }

    public static long max(File file) {
        return CountUtils.calc(file, 0);
    }

    public static long avg(File file) {
        return CountUtils.calc(file, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long calc(File file, int op) {
        if (!file.exists()) return 0L;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                String line;
                int times = 0;
                int count = 0;
                while ((line = reader.readLine()) != null) {
                    int i = line.indexOf(" ");
                    if (i <= 0 || !NUMBER_PATTERN.matcher(line = line.substring(i + 1).trim()).matches()) continue;
                    int value = Integer.parseInt(line);
                    ++times;
                    if (op == 1) {
                        count = Math.max(count, value);
                        continue;
                    }
                    count += value;
                }
                if (op == 2) {
                    long l = count / times;
                    return l;
                }
                long l = count;
                return l;
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return 0L;
    }
}

