/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached;

import com.google.code.yanf4j.config.Configuration;
import com.google.code.yanf4j.core.SocketOption;
import com.google.code.yanf4j.core.impl.StandardSocketOption;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.MemcachedClientStateListener;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClient;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.buffer.BufferAllocator;
import net.rubyeye.xmemcached.buffer.SimpleBufferAllocator;
import net.rubyeye.xmemcached.command.TextCommandFactory;
import net.rubyeye.xmemcached.impl.ArrayMemcachedSessionLocator;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMemcachedClientBuilder
implements MemcachedClientBuilder {
    private MemcachedSessionLocator sessionLocator = new ArrayMemcachedSessionLocator();
    private BufferAllocator bufferAllocator = new SimpleBufferAllocator();
    private Configuration configuration = XMemcachedClientBuilder.getDefaultConfiguration();
    private Map<InetSocketAddress, InetSocketAddress> addressMap = new LinkedHashMap<InetSocketAddress, InetSocketAddress>();
    private int[] weights;
    private long connectTimeout = 60000L;
    private int connectionPoolSize = 1;
    final Map<SocketOption, Object> socketOptions = XMemcachedClientBuilder.getDefaultSocketOptions();
    private List<MemcachedClientStateListener> stateListeners = new ArrayList<MemcachedClientStateListener>();
    private Map<InetSocketAddress, AuthInfo> authInfoMap = new HashMap<InetSocketAddress, AuthInfo>();
    private String name;
    private boolean failureMode;
    private boolean sanitizeKeys;
    private CommandFactory commandFactory = new TextCommandFactory();
    private Transcoder transcoder = new SerializingTranscoder();

    @Override
    public void setSanitizeKeys(boolean sanitizeKeys) {
        this.sanitizeKeys = sanitizeKeys;
    }

    @Override
    public void addStateListener(MemcachedClientStateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    @Override
    public void setSocketOption(SocketOption socketOption, Object value) {
        if (socketOption == null) {
            throw new NullPointerException("Null socketOption");
        }
        if (value == null) {
            throw new NullPointerException("Null value");
        }
        if (!socketOption.type().equals(value.getClass())) {
            throw new IllegalArgumentException("Expected " + socketOption.type().getSimpleName() + " value,but givend " + value.getClass().getSimpleName());
        }
        this.socketOptions.put(socketOption, value);
    }

    @Override
    public Map<SocketOption, Object> getSocketOptions() {
        return this.socketOptions;
    }

    @Override
    public final void setConnectionPoolSize(int poolSize) {
        if (this.connectionPoolSize <= 0) {
            throw new IllegalArgumentException("poolSize<=0");
        }
        this.connectionPoolSize = poolSize;
    }

    @Override
    public void removeStateListener(MemcachedClientStateListener stateListener) {
        this.stateListeners.remove(stateListener);
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void setStateListeners(List<MemcachedClientStateListener> stateListeners) {
        if (stateListeners == null) {
            throw new IllegalArgumentException("Null state listeners");
        }
        this.stateListeners = stateListeners;
    }

    public static final Map<SocketOption, Object> getDefaultSocketOptions() {
        HashMap<SocketOption, Object> map = new HashMap<SocketOption, Object>();
        map.put(StandardSocketOption.TCP_NODELAY, true);
        map.put(StandardSocketOption.SO_RCVBUF, 65536);
        map.put(StandardSocketOption.SO_KEEPALIVE, true);
        map.put(StandardSocketOption.SO_SNDBUF, 32768);
        map.put(StandardSocketOption.SO_LINGER, 0);
        map.put(StandardSocketOption.SO_REUSEADDR, true);
        return map;
    }

    public static final Configuration getDefaultConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setSessionReadBufferSize(131072);
        configuration.setReadThreadCount(0);
        configuration.setSessionIdleTimeout(5000L);
        configuration.setWriteThreadCount(0);
        return configuration;
    }

    @Override
    public boolean isFailureMode() {
        return this.failureMode;
    }

    @Override
    public void setFailureMode(boolean failureMode) {
        this.failureMode = failureMode;
    }

    @Override
    public final CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    @Override
    public final void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public XMemcachedClientBuilder(List<InetSocketAddress> addressList) {
        if (addressList != null) {
            for (InetSocketAddress addr : addressList) {
                this.addressMap.put(addr, null);
            }
        }
    }

    public XMemcachedClientBuilder(List<InetSocketAddress> addressList, int[] weights) {
        if (addressList != null) {
            for (InetSocketAddress addr : addressList) {
                this.addressMap.put(addr, null);
            }
        }
        this.weights = weights;
    }

    public XMemcachedClientBuilder(Map<InetSocketAddress, InetSocketAddress> addressMap) {
        this.addressMap = addressMap;
    }

    public XMemcachedClientBuilder(Map<InetSocketAddress, InetSocketAddress> addressMap, int[] weights) {
        this.addressMap = addressMap;
        this.weights = weights;
    }

    public XMemcachedClientBuilder() {
        this((Map<InetSocketAddress, InetSocketAddress>)null);
    }

    @Override
    public MemcachedSessionLocator getSessionLocator() {
        return this.sessionLocator;
    }

    @Override
    public void setSessionLocator(MemcachedSessionLocator sessionLocator) {
        if (sessionLocator == null) {
            throw new IllegalArgumentException("Null SessionLocator");
        }
        this.sessionLocator = sessionLocator;
    }

    @Override
    public BufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    @Override
    public void setBufferAllocator(BufferAllocator bufferAllocator) {
        if (bufferAllocator == null) {
            throw new IllegalArgumentException("Null bufferAllocator");
        }
        this.bufferAllocator = bufferAllocator;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public MemcachedClient build() throws IOException {
        XMemcachedClient memcachedClient;
        if (this.weights == null) {
            memcachedClient = new XMemcachedClient(this.sessionLocator, this.bufferAllocator, this.configuration, this.socketOptions, this.commandFactory, this.transcoder, this.addressMap, this.stateListeners, this.authInfoMap, this.connectionPoolSize, this.connectTimeout, this.name, this.failureMode);
        } else {
            if (this.addressMap == null) {
                throw new IllegalArgumentException("Null Address map");
            }
            if (this.addressMap.size() > this.weights.length) {
                throw new IllegalArgumentException("Weights Array's length is less than server's number");
            }
            memcachedClient = new XMemcachedClient(this.sessionLocator, this.bufferAllocator, this.configuration, this.socketOptions, this.commandFactory, this.transcoder, this.addressMap, this.weights, this.stateListeners, this.authInfoMap, this.connectionPoolSize, this.connectTimeout, this.name, this.failureMode);
        }
        if (this.commandFactory.getProtocol() == Protocol.Kestrel) {
            memcachedClient.setOptimizeGet(false);
        }
        memcachedClient.setSanitizeKeys(this.sanitizeKeys);
        return memcachedClient;
    }

    @Override
    public Transcoder getTranscoder() {
        return this.transcoder;
    }

    @Override
    public void setTranscoder(Transcoder transcoder) {
        if (transcoder == null) {
            throw new IllegalArgumentException("Null Transcoder");
        }
        this.transcoder = transcoder;
    }

    @Override
    public Map<InetSocketAddress, AuthInfo> getAuthInfoMap() {
        return this.authInfoMap;
    }

    @Override
    public void addAuthInfo(InetSocketAddress address, AuthInfo authInfo) {
        this.authInfoMap.put(address, authInfo);
    }

    @Override
    public void removeAuthInfo(InetSocketAddress address) {
        this.authInfoMap.remove(address);
    }

    @Override
    public void setAuthInfoMap(Map<InetSocketAddress, AuthInfo> authInfoMap) {
        this.authInfoMap = authInfoMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

