/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.auth;

import java.net.InetSocketAddress;
import java.util.Map;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClient;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.auth.AuthTask;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.networking.MemcachedSession;
import net.rubyeye.xmemcached.networking.MemcachedSessionConnectListener;

public class AuthMemcachedConnectListener
implements MemcachedSessionConnectListener {
    public void onConnect(MemcachedSession session, MemcachedClient client) {
        AuthInfo authInfo;
        MemcachedTCPSession tcpSession = (MemcachedTCPSession)session;
        Map<InetSocketAddress, AuthInfo> authInfoMap = client.getAuthInfoMap();
        if (authInfoMap != null && (authInfo = authInfoMap.get(tcpSession.getRemoteSocketAddress())) != null) {
            XMemcachedClient xMemcachedClient = (XMemcachedClient)client;
            AuthTask task = new AuthTask(authInfo, xMemcachedClient.getCommandFactory(), tcpSession);
            task.start();
            if (authInfo.isFirstTime()) {
                try {
                    task.join(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

