/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.binary;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.binary.BinaryDecodeStatus;
import net.rubyeye.xmemcached.command.binary.OpCode;
import net.rubyeye.xmemcached.command.binary.ResponseStatus;
import net.rubyeye.xmemcached.exception.MemcachedDecodeException;
import net.rubyeye.xmemcached.exception.MemcachedServerException;
import net.rubyeye.xmemcached.exception.UnknownCommandException;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.ByteUtils;
import net.rubyeye.xmemcached.utils.OpaqueGenerater;

public abstract class BaseBinaryCommand
extends Command {
    static final short DEFAULT_VBUCKET_ID = 0;
    protected int expTime;
    protected long cas;
    protected Object value;
    protected OpCode opCode;
    protected BinaryDecodeStatus decodeStatus = BinaryDecodeStatus.NONE;
    protected int responseKeyLength;
    protected int responseExtrasLength;
    protected int responseTotalBodyLength;
    protected ResponseStatus responseStatus;
    protected int opaque;
    protected short vbucketId = 0;
    static final byte EXTRAS_LENGTH = 8;

    public BaseBinaryCommand(String key, byte[] keyBytes, CommandType cmdType, CountDownLatch latch, int exp, long cas, Object value, boolean noreply, Transcoder transcoder) {
        super(key, keyBytes, cmdType, latch);
        this.expTime = exp;
        this.cas = cas;
        this.value = value;
        this.noreply = noreply;
        this.transcoder = transcoder;
    }

    public final int getExpTime() {
        return this.expTime;
    }

    public final void setExpTime(int exp) {
        this.expTime = exp;
    }

    public final long getCas() {
        return this.cas;
    }

    public final void setCas(long cas) {
        this.cas = cas;
    }

    public final Object getValue() {
        return this.value;
    }

    public final void setValue(Object value) {
        this.value = value;
    }

    public final Transcoder getTranscoder() {
        return this.transcoder;
    }

    public final void setTranscoder(Transcoder transcoder) {
        this.transcoder = transcoder;
    }

    public boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        block9: while (true) {
            switch (this.decodeStatus) {
                case NONE: {
                    if (buffer.remaining() < 24) {
                        return false;
                    }
                    this.decodeStatus = BinaryDecodeStatus.READ_HEADER;
                    continue block9;
                }
                case READ_HEADER: {
                    this.readHeader(buffer);
                    continue block9;
                }
                case READ_EXTRAS: {
                    if (this.readExtras(buffer, this.responseExtrasLength)) {
                        this.decodeStatus = BinaryDecodeStatus.READ_KEY;
                        continue block9;
                    }
                    return false;
                }
                case READ_KEY: {
                    if (this.readKey(buffer, this.responseKeyLength)) {
                        this.decodeStatus = BinaryDecodeStatus.READ_VALUE;
                        continue block9;
                    }
                    return false;
                }
                case READ_VALUE: {
                    if (this.responseStatus == null || this.responseStatus == ResponseStatus.NO_ERROR) {
                        if (this.readValue(buffer, this.responseTotalBodyLength, this.responseKeyLength, this.responseExtrasLength)) {
                            this.decodeStatus = BinaryDecodeStatus.DONE;
                            continue block9;
                        }
                        return false;
                    }
                    if (ByteUtils.stepBuffer(buffer, this.responseTotalBodyLength - this.responseKeyLength - this.responseExtrasLength)) {
                        this.decodeStatus = BinaryDecodeStatus.DONE;
                        continue block9;
                    }
                    return false;
                }
                case DONE: {
                    if (this.finish()) {
                        return true;
                    }
                    this.decodeStatus = BinaryDecodeStatus.NONE;
                    continue block9;
                }
                case IGNORE: {
                    buffer.reset();
                    return true;
                }
            }
        }
    }

    protected boolean finish() {
        if (this.result == null) {
            if (this.responseStatus == ResponseStatus.NO_ERROR) {
                this.setResult(Boolean.TRUE);
            } else {
                this.setResult(Boolean.FALSE);
            }
        }
        this.countDownLatch();
        return true;
    }

    protected void readHeader(ByteBuffer buffer) {
        this.markBuffer(buffer);
        this.readMagicNumber(buffer);
        if (!this.readOpCode(buffer)) {
            this.decodeStatus = BinaryDecodeStatus.IGNORE;
            return;
        }
        this.readKeyLength(buffer);
        this.readExtrasLength(buffer);
        this.readDataType(buffer);
        this.readStatus(buffer);
        this.readBodyLength(buffer);
        if (!this.readOpaque(buffer)) {
            this.decodeStatus = BinaryDecodeStatus.IGNORE;
            return;
        }
        this.decodeStatus = BinaryDecodeStatus.READ_EXTRAS;
        this.readCAS(buffer);
    }

    private void markBuffer(ByteBuffer buffer) {
        buffer.mark();
    }

    protected boolean readOpaque(ByteBuffer buffer) {
        if (this.noreply) {
            int returnOpaque = buffer.getInt();
            if (returnOpaque != this.opaque) {
                return false;
            }
        } else {
            ByteUtils.stepBuffer(buffer, 4);
        }
        return true;
    }

    protected long readCAS(ByteBuffer buffer) {
        ByteUtils.stepBuffer(buffer, 8);
        return 0L;
    }

    protected boolean readKey(ByteBuffer buffer, int keyLength) {
        return ByteUtils.stepBuffer(buffer, keyLength);
    }

    protected boolean readValue(ByteBuffer buffer, int bodyLength, int keyLength, int extrasLength) {
        return ByteUtils.stepBuffer(buffer, bodyLength - keyLength - extrasLength);
    }

    protected boolean readExtras(ByteBuffer buffer, int extrasLength) {
        return ByteUtils.stepBuffer(buffer, extrasLength);
    }

    private int readBodyLength(ByteBuffer buffer) {
        this.responseTotalBodyLength = buffer.getInt();
        return this.responseTotalBodyLength;
    }

    protected void readStatus(ByteBuffer buffer) {
        this.responseStatus = ResponseStatus.parseShort(buffer.getShort());
        switch (this.responseStatus) {
            case NOT_SUPPORTED: 
            case UNKNOWN_COMMAND: {
                this.setException(new UnknownCommandException());
                break;
            }
            case AUTH_REQUIRED: 
            case FUTHER_AUTH_REQUIRED: 
            case VALUE_TOO_BIG: 
            case INVALID_ARGUMENTS: 
            case INC_DEC_NON_NUM: 
            case BELONGS_TO_ANOTHER_SRV: 
            case AUTH_ERROR: 
            case OUT_OF_MEMORY: 
            case INTERNAL_ERROR: 
            case BUSY: 
            case TEMP_FAILURE: {
                this.setException(new MemcachedServerException(this.responseStatus.errorMessage()));
            }
        }
    }

    public final OpCode getOpCode() {
        return this.opCode;
    }

    public final void setOpCode(OpCode opCode) {
        this.opCode = opCode;
    }

    public final ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    public final void setResponseStatus(ResponseStatus responseStatus) {
        this.responseStatus = responseStatus;
    }

    private int readKeyLength(ByteBuffer buffer) {
        this.responseKeyLength = buffer.getShort();
        return this.responseKeyLength;
    }

    private int readExtrasLength(ByteBuffer buffer) {
        this.responseExtrasLength = buffer.get();
        return this.responseExtrasLength;
    }

    private byte readDataType(ByteBuffer buffer) {
        return buffer.get();
    }

    protected boolean readOpCode(ByteBuffer buffer) {
        byte op = buffer.get();
        if (op != this.opCode.fieldValue()) {
            if (this.noreply) {
                return false;
            }
            throw new MemcachedDecodeException("Not a proper " + this.opCode.name() + " response");
        }
        return true;
    }

    private void readMagicNumber(ByteBuffer buffer) {
        byte magic = buffer.get();
        if (magic != -127) {
            throw new MemcachedDecodeException("Not a proper response");
        }
    }

    public void encode() {
        CachedData data = null;
        if (this.transcoder != null) {
            data = this.transcoder.encode(this.value);
        }
        int length = 24 + this.getKeyLength() + this.getValueLength(data) + this.getExtrasLength();
        this.ioBuffer = IoBuffer.allocate(length);
        this.fillHeader(data);
        this.fillExtras(data);
        this.fillKey();
        this.fillValue(data);
        this.ioBuffer.flip();
    }

    protected void fillValue(CachedData data) {
        this.ioBuffer.put(data.getData());
    }

    protected void fillKey() {
        this.ioBuffer.put(this.keyBytes);
    }

    protected void fillExtras(CachedData data) {
        this.ioBuffer.putInt(data.getFlag());
        this.ioBuffer.putInt(this.expTime);
    }

    protected final void fillHeader(CachedData data) {
        this.fillMagicNumber();
        this.fillOpCode();
        this.fillKeyLength();
        this.fillExtrasLength();
        this.fillDataType();
        this.fillVbucketId();
        this.fillTotalBodyLength(data);
        this.fillOpaque();
        this.fillCAS();
    }

    protected void fillCAS() {
        this.ioBuffer.putLong(0L);
    }

    private void fillOpaque() {
        if (this.noreply) {
            this.opaque = OpaqueGenerater.getInstance().getNextValue();
        }
        this.ioBuffer.putInt(this.opaque);
    }

    private void fillTotalBodyLength(CachedData data) {
        this.ioBuffer.putInt(this.getExtrasLength() + this.getKeyLength() + this.getValueLength(data));
    }

    private void fillVbucketId() {
        this.ioBuffer.putShort(this.vbucketId);
    }

    private void fillDataType() {
        this.ioBuffer.put((byte)0);
    }

    private void fillExtrasLength() {
        this.ioBuffer.put(this.getExtrasLength());
    }

    private void fillKeyLength() {
        this.ioBuffer.putShort((short)this.getKeyLength());
    }

    private void fillOpCode() {
        this.ioBuffer.put(this.opCode.fieldValue());
    }

    private void fillMagicNumber() {
        this.ioBuffer.put((byte)-128);
    }

    protected int getValueLength(CachedData data) {
        return data.getData().length;
    }

    protected int getKeyLength() {
        return this.keyBytes.length;
    }

    protected byte getExtrasLength() {
        return 8;
    }
}

