/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.utils;

import com.google.code.yanf4j.config.Configuration;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.buffer.BufferAllocator;
import net.rubyeye.xmemcached.buffer.SimpleBufferAllocator;
import net.rubyeye.xmemcached.command.TextCommandFactory;
import net.rubyeye.xmemcached.impl.ArrayMemcachedSessionLocator;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMemcachedClientFactoryBean
implements FactoryBean {
    private MemcachedSessionLocator sessionLocator = new ArrayMemcachedSessionLocator();
    private BufferAllocator bufferAllocator = new SimpleBufferAllocator();
    private String servers;
    private List<Integer> weights;
    private Transcoder transcoder = new SerializingTranscoder();
    private Configuration configuration = XMemcachedClientBuilder.getDefaultConfiguration();
    private CommandFactory commandFactory = new TextCommandFactory();
    private Map<InetSocketAddress, AuthInfo> authInfoMap = new HashMap<InetSocketAddress, AuthInfo>();
    private String name;
    private int connectionPoolSize = 1;
    private MemcachedClient memcachedClient;
    private boolean failureMode;
    private long opTimeout = 1000L;

    public long getOpTimeout() {
        return this.opTimeout;
    }

    public void setOpTimeout(long opTimeout) {
        this.opTimeout = opTimeout;
    }

    public final CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public final void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public Map<InetSocketAddress, AuthInfo> getAuthInfoMap() {
        return this.authInfoMap;
    }

    public void setAuthInfoMap(Map<InetSocketAddress, AuthInfo> authInfoMap) {
        this.authInfoMap = authInfoMap;
    }

    public boolean isFailureMode() {
        return this.failureMode;
    }

    public void setFailureMode(boolean failureMode) {
        this.failureMode = failureMode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public final void setConnectionPoolSize(int poolSize) {
        this.connectionPoolSize = poolSize;
    }

    public void setSessionLocator(MemcachedSessionLocator sessionLocator) {
        this.sessionLocator = sessionLocator;
    }

    public void setBufferAllocator(BufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
    }

    public void setTranscoder(Transcoder transcoder) {
        this.transcoder = transcoder;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public MemcachedSessionLocator getSessionLocator() {
        return this.sessionLocator;
    }

    public BufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public Transcoder getTranscoder() {
        return this.transcoder;
    }

    public List<Integer> getWeights() {
        return this.weights;
    }

    public void setWeights(List<Integer> weights) {
        this.weights = weights;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Object getObject() throws Exception {
        this.checkAttribute();
        Map<InetSocketAddress, InetSocketAddress> serverMap = this.getServerMap();
        int[] weightsArray = this.getWeightsArray(serverMap);
        MemcachedClientBuilder builder = this.newBuilder(serverMap, weightsArray);
        this.configBuilder(builder);
        this.memcachedClient = builder.build();
        this.memcachedClient.setOpTimeout(this.opTimeout);
        return this.memcachedClient;
    }

    private MemcachedClientBuilder newBuilder(Map<InetSocketAddress, InetSocketAddress> serverMap, int[] weightsArray) {
        XMemcachedClientBuilder builder = weightsArray == null ? new XMemcachedClientBuilder(serverMap) : new XMemcachedClientBuilder(serverMap, weightsArray);
        return builder;
    }

    private void configBuilder(MemcachedClientBuilder builder) {
        builder.setConfiguration(this.configuration);
        builder.setBufferAllocator(this.bufferAllocator);
        builder.setSessionLocator(this.sessionLocator);
        builder.setTranscoder(this.transcoder);
        builder.setCommandFactory(this.commandFactory);
        builder.setConnectionPoolSize(this.connectionPoolSize);
        builder.setAuthInfoMap(this.authInfoMap);
        builder.setFailureMode(this.failureMode);
        builder.setName(this.name);
    }

    private int[] getWeightsArray(Map<InetSocketAddress, InetSocketAddress> serverMap) {
        int[] weightsArray = null;
        if (serverMap != null && serverMap.size() > 0 && this.weights != null) {
            if (this.weights.size() < serverMap.size()) {
                throw new IllegalArgumentException("Weight list's size is less than server list's size");
            }
            weightsArray = new int[this.weights.size()];
            for (int i = 0; i < weightsArray.length; ++i) {
                weightsArray[i] = this.weights.get(i);
            }
        }
        return weightsArray;
    }

    private Map<InetSocketAddress, InetSocketAddress> getServerMap() {
        Map<InetSocketAddress, InetSocketAddress> serverMap = null;
        if (this.servers != null && this.servers.length() > 0) {
            serverMap = AddrUtil.getAddressMap(this.servers);
        }
        return serverMap;
    }

    private void checkAttribute() {
        if (this.bufferAllocator == null) {
            throw new NullPointerException("Null BufferAllocator");
        }
        if (this.sessionLocator == null) {
            throw new NullPointerException("Null MemcachedSessionLocator");
        }
        if (this.configuration == null) {
            throw new NullPointerException("Null networking configuration");
        }
        if (this.commandFactory == null) {
            throw new NullPointerException("Null command factory");
        }
        if (this.weights != null && this.servers == null) {
            throw new NullPointerException("Empty server list");
        }
    }

    public void shutdown() throws IOException {
        if (this.memcachedClient != null) {
            this.memcachedClient.shutdown();
        }
    }

    public Class getObjectType() {
        return MemcachedClient.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

