/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v07.handlers;

import com.alibaba.excel.analysis.v07.XlsxCellHandler;
import com.alibaba.excel.analysis.v07.XlsxRowResultHolder;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.BooleanUtils;
import com.alibaba.excel.util.PositionUtils;
import com.alibaba.excel.util.StringUtils;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;

public class DefaultCellHandler
implements XlsxCellHandler,
XlsxRowResultHolder {
    private final AnalysisContext analysisContext;
    private String currentTag;
    private String currentCellIndex;
    private int curRow;
    private int curCol;
    private Map<Integer, CellData> curRowContent = new TreeMap<Integer, CellData>();
    private CellData currentCellData;
    private StylesTable stylesTable;

    public DefaultCellHandler(AnalysisContext analysisContext, StylesTable stylesTable) {
        this.analysisContext = analysisContext;
        this.stylesTable = stylesTable;
    }

    @Override
    public void clearResult() {
        this.curRowContent = new TreeMap<Integer, CellData>();
    }

    @Override
    public boolean support(String name) {
        return "v".equals(name) || "f".equals(name) || "t".equals(name) || "c".equals(name);
    }

    @Override
    public void startHandle(String name, Attributes attributes) {
        this.currentTag = name;
        if ("c".equals(name)) {
            this.currentCellIndex = attributes.getValue("r");
            int nextRow = PositionUtils.getRow(this.currentCellIndex);
            if (nextRow > this.curRow) {
                this.curRow = nextRow;
            }
            this.analysisContext.readRowHolder(new ReadRowHolder(this.curRow, this.analysisContext.readSheetHolder().getGlobalConfiguration()));
            this.curCol = PositionUtils.getCol(this.currentCellIndex);
            CellDataTypeEnum type = CellDataTypeEnum.buildFromCellType(attributes.getValue("t"));
            this.currentCellData = new CellData(type);
            String dateFormatIndex = attributes.getValue("s");
            if (dateFormatIndex != null) {
                int dateFormatIndexInteger = Integer.parseInt(dateFormatIndex);
                XSSFCellStyle xssfCellStyle = this.stylesTable.getStyleAt(dateFormatIndexInteger);
                short dataFormat = xssfCellStyle.getDataFormat();
                String dataFormatString = xssfCellStyle.getDataFormatString();
                this.currentCellData.setDataFormat(Integer.valueOf(dataFormat));
                if (dataFormatString == null) {
                    this.currentCellData.setDataFormatString(BuiltinFormats.getBuiltinFormat((int)dataFormat));
                } else {
                    this.currentCellData.setDataFormatString(dataFormatString);
                }
            }
        }
        if ("f".equals(name)) {
            this.currentCellData.setFormula(Boolean.TRUE);
        }
    }

    @Override
    public void endHandle(String name) {
        if ("v".equals(name)) {
            if (this.currentCellData.getType() == CellDataTypeEnum.STRING) {
                String stringValue = this.analysisContext.readWorkbookHolder().getReadCache().get(Integer.valueOf(this.currentCellData.getStringValue()));
                if (stringValue != null && this.analysisContext.currentReadHolder().globalConfiguration().getAutoTrim().booleanValue()) {
                    stringValue = stringValue.trim();
                }
                this.currentCellData.setStringValue(stringValue);
            } else if (this.currentCellData.getType() == CellDataTypeEnum.DIRECT_STRING) {
                this.currentCellData.setType(CellDataTypeEnum.STRING);
            }
            this.currentCellData.checkEmpty();
            this.curRowContent.put(this.curCol, this.currentCellData);
        }
        if ("t".equals(name)) {
            XSSFRichTextString richTextString = new XSSFRichTextString(this.currentCellData.getStringValue());
            String stringValue = richTextString.toString();
            if (stringValue != null && this.analysisContext.currentReadHolder().globalConfiguration().getAutoTrim().booleanValue()) {
                stringValue = stringValue.trim();
            }
            this.currentCellData.setStringValue(stringValue);
            this.currentCellData.checkEmpty();
            this.curRowContent.put(this.curCol, this.currentCellData);
        }
    }

    @Override
    public void appendCurrentCellValue(String currentCellValue) {
        if (StringUtils.isEmpty(currentCellValue)) {
            return;
        }
        if (this.currentTag == null) {
            return;
        }
        if ("f".equals(this.currentTag)) {
            this.currentCellData.setFormulaValue(currentCellValue);
            return;
        }
        CellDataTypeEnum oldType = this.currentCellData.getType();
        switch (oldType) {
            case DIRECT_STRING: 
            case STRING: 
            case ERROR: {
                if (this.currentCellData.getStringValue() == null) {
                    this.currentCellData.setStringValue(currentCellValue);
                    break;
                }
                this.currentCellData.setStringValue(this.currentCellData.getStringValue() + currentCellValue);
                break;
            }
            case BOOLEAN: {
                if (this.currentCellData.getBooleanValue() != null) break;
                this.currentCellData.setBooleanValue(BooleanUtils.valueOf(currentCellValue));
                break;
            }
            case NUMBER: 
            case EMPTY: {
                this.currentCellData.setType(CellDataTypeEnum.NUMBER);
                if (this.currentCellData.getDoubleValue() != null) break;
                this.currentCellData.setDoubleValue(Double.valueOf(currentCellValue));
                break;
            }
            default: {
                throw new IllegalStateException("Cannot set values now");
            }
        }
    }

    @Override
    public Map<Integer, CellData> getCurRowContent() {
        return this.curRowContent;
    }
}

