/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.read.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.event.AbstractIgnoreExceptionReadListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.read.metadata.holder.ReadHolder;
import com.alibaba.excel.read.metadata.property.ExcelReadHeadProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;

public class ModelBuildEventListener
extends AbstractIgnoreExceptionReadListener<Map<Integer, CellData>> {
    @Override
    public void invoke(Map<Integer, CellData> cellDataMap, AnalysisContext context) {
        ReadHolder currentReadHolder = context.currentReadHolder();
        if (HeadKindEnum.CLASS.equals((Object)currentReadHolder.excelReadHeadProperty().getHeadKind())) {
            context.readRowHolder().setCurrentRowAnalysisResult(this.buildUserModel(cellDataMap, currentReadHolder));
            return;
        }
        context.readRowHolder().setCurrentRowAnalysisResult(this.buildStringList(cellDataMap, currentReadHolder, context));
    }

    private Object buildStringList(Map<Integer, CellData> cellDataMap, ReadHolder currentReadHolder, AnalysisContext context) {
        if (context.readWorkbookHolder().getDefaultReturnMap().booleanValue()) {
            HashMap<Integer, String> map = new HashMap<Integer, String>(cellDataMap.size() * 4 / 3 + 1);
            for (Map.Entry<Integer, CellData> entry : cellDataMap.entrySet()) {
                CellData cellData = entry.getValue();
                if (cellData.getType() == CellDataTypeEnum.EMPTY) {
                    map.put(entry.getKey(), null);
                    continue;
                }
                map.put(entry.getKey(), (String)this.convertValue(cellData, String.class, null, currentReadHolder.converterMap(), currentReadHolder.globalConfiguration()));
            }
            return map;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<Integer, CellData> entry : cellDataMap.entrySet()) {
            CellData cellData = entry.getValue();
            if (cellData.getType() == CellDataTypeEnum.EMPTY) {
                list.add(null);
                continue;
            }
            list.add((String)this.convertValue(cellData, String.class, null, currentReadHolder.converterMap(), currentReadHolder.globalConfiguration()));
        }
        return list;
    }

    private Object buildUserModel(Map<Integer, CellData> cellDataMap, ReadHolder currentReadHolder) {
        Object resultModel;
        ExcelReadHeadProperty excelReadHeadProperty = currentReadHolder.excelReadHeadProperty();
        try {
            resultModel = excelReadHeadProperty.getHeadClazz().newInstance();
        }
        catch (Exception e) {
            throw new ExcelDataConvertException("Can not instance class: " + excelReadHeadProperty.getHeadClazz().getName(), e);
        }
        Map<Integer, Head> headMap = excelReadHeadProperty.getHeadMap();
        HashMap<String, Object> map = new HashMap<String, Object>(headMap.size() * 4 / 3 + 1);
        Map<Integer, ExcelContentProperty> contentPropertyMap = excelReadHeadProperty.getContentPropertyMap();
        for (Map.Entry<Integer, Head> entry : headMap.entrySet()) {
            ExcelContentProperty excelContentProperty;
            Object value;
            CellData cellData;
            Integer index = entry.getKey();
            if (!cellDataMap.containsKey(index) || (cellData = cellDataMap.get(index)).getType() == CellDataTypeEnum.EMPTY || (value = this.convertValue(cellData, (excelContentProperty = contentPropertyMap.get(index)).getField().getType(), excelContentProperty, currentReadHolder.converterMap(), currentReadHolder.globalConfiguration())) == null) continue;
            map.put(excelContentProperty.getField().getName(), value);
        }
        BeanMap.create(resultModel).putAll(map);
        return resultModel;
    }

    private Object convertValue(CellData cellData, Class clazz, ExcelContentProperty contentProperty, Map<String, Converter> converterMap, GlobalConfiguration globalConfiguration) {
        if (clazz == CellData.class) {
            return new CellData(cellData);
        }
        Converter converter = null;
        if (contentProperty != null) {
            converter = contentProperty.getConverter();
        }
        if (converter == null) {
            converter = converterMap.get(ConverterKeyBuild.buildKey(clazz, cellData.getType()));
        }
        if (converter == null) {
            throw new ExcelDataConvertException("Converter not found, convert " + (Object)((Object)cellData.getType()) + " to " + clazz.getName());
        }
        try {
            return converter.convertToJavaData(cellData, contentProperty, globalConfiguration);
        }
        catch (Exception e) {
            throw new ExcelDataConvertException("Convert data " + cellData + " to " + clazz + " error ", e);
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
    }
}

