/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.CharTypes;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.Keywords;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.util.Base64;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONScanner
implements JSONLexer {
    public static final byte EOI = 26;
    private final char[] buf;
    private int bp;
    private final int buflen;
    private int eofPos;
    private char ch;
    private int pos;
    private char[] sbuf;
    private int sp;
    private int np;
    private int token;
    private Keywords keywods = Keywords.DEFAULT_KEYWORDS;
    private static final ThreadLocal<SoftReference<char[]>> sbufRefLocal;
    private int features = JSON.DEFAULT_PARSER_FEATURE;
    private Calendar calendar = null;
    private boolean resetFlag = false;
    private static boolean[] whitespaceFlags;
    boolean hasSpecial;
    public static final int NOT_MATCH = -1;
    public static final int NOT_MATCH_NAME = -2;
    public static final int UNKOWN = 0;
    public static final int OBJECT = 1;
    public static final int ARRAY = 2;
    public static final int VALUE = 3;
    public static final int END = 4;
    private static final char[] typeFieldName;
    public int matchStat = 0;
    private static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    private static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    private static final int INT_MULTMIN_RADIX_TEN = -214748364;
    private static final int INT_N_MULTMAX_RADIX_TEN = -214748364;
    private static final int[] digits;
    public final int ISO8601_LEN_0 = "0000-00-00".length();
    public final int ISO8601_LEN_1 = "0000-00-00T00:00:00".length();
    public final int ISO8601_LEN_2 = "0000-00-00T00:00:00.000".length();

    public JSONScanner(String input) {
        this(input, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(String input, int features) {
        this(input.toCharArray(), input.length(), features);
    }

    public JSONScanner(char[] input, int inputLength) {
        this(input, inputLength, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(char[] input, int inputLength, int features) {
        this.features = features;
        SoftReference<char[]> sbufRef = sbufRefLocal.get();
        if (sbufRef != null) {
            this.sbuf = sbufRef.get();
            sbufRefLocal.set(null);
        }
        if (this.sbuf == null) {
            this.sbuf = new char[64];
        }
        this.eofPos = inputLength;
        if (inputLength == input.length) {
            if (input.length > 0 && JSONScanner.isWhitespace(input[input.length - 1])) {
                --inputLength;
            } else {
                char[] newInput = new char[inputLength + 1];
                System.arraycopy(input, 0, newInput, 0, input.length);
                input = newInput;
            }
        }
        this.buf = input;
        this.buflen = inputLength;
        this.buf[this.buflen] = 26;
        this.bp = -1;
        this.ch = this.buf[++this.bp];
    }

    @Override
    public boolean isResetFlag() {
        return this.resetFlag;
    }

    @Override
    public void setResetFlag(boolean resetFlag) {
        this.resetFlag = resetFlag;
    }

    @Override
    public final int getBufferPosition() {
        return this.bp;
    }

    public void reset(int mark, char mark_ch, int token) {
        this.bp = mark;
        this.ch = mark_ch;
        this.token = token;
        this.resetFlag = true;
    }

    @Override
    public boolean isBlankInput() {
        for (int i = 0; i < this.buflen; ++i) {
            if (JSONScanner.isWhitespace(this.buf[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f' || ch == '\b';
    }

    private void lexError(String key, Object ... args) {
        this.token = 1;
    }

    @Override
    public final int token() {
        return this.token;
    }

    @Override
    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    @Override
    public final void skipWhitespace() {
        while (whitespaceFlags[this.ch]) {
            this.ch = this.buf[++this.bp];
        }
    }

    @Override
    public final char getCurrent() {
        return this.ch;
    }

    public final void nextTokenWithColon() {
        while (true) {
            if (this.ch == ':') {
                this.ch = this.buf[++this.bp];
                this.nextToken();
                return;
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.ch = this.buf[++this.bp];
        }
        throw new JSONException("not match ':' - " + this.ch);
    }

    @Override
    public final void nextTokenWithColon(int expect) {
        block17: {
            while (true) {
                if (this.ch == ':') break block17;
                if (!JSONScanner.isWhitespace(this.ch)) break;
                this.ch = this.buf[++this.bp];
            }
            throw new JSONException("not match ':', actual " + this.ch);
        }
        this.ch = this.buf[++this.bp];
        while (true) {
            if (expect == 2) {
                if (this.ch >= '0' && this.ch <= '9') {
                    this.sp = 0;
                    this.pos = this.bp;
                    this.scanNumber();
                    return;
                }
                if (this.ch == '\"') {
                    this.sp = 0;
                    this.pos = this.bp;
                    this.scanString();
                    return;
                }
            } else if (expect == 4) {
                if (this.ch == '\"') {
                    this.sp = 0;
                    this.pos = this.bp;
                    this.scanString();
                    return;
                }
                if (this.ch >= '0' && this.ch <= '9') {
                    this.sp = 0;
                    this.pos = this.bp;
                    this.scanNumber();
                    return;
                }
            } else if (expect == 12) {
                if (this.ch == '{') {
                    this.token = 12;
                    this.ch = this.buf[++this.bp];
                    return;
                }
                if (this.ch == '[') {
                    this.token = 14;
                    this.ch = this.buf[++this.bp];
                    return;
                }
            } else if (expect == 14) {
                if (this.ch == '[') {
                    this.token = 14;
                    this.ch = this.buf[++this.bp];
                    return;
                }
                if (this.ch == '{') {
                    this.token = 12;
                    this.ch = this.buf[++this.bp];
                    return;
                }
            }
            if (!JSONScanner.isWhitespace(this.ch)) break;
            this.ch = this.buf[++this.bp];
        }
        this.nextToken();
    }

    @Override
    public final void incrementBufferPosition() {
        this.ch = this.buf[++this.bp];
    }

    @Override
    public final void resetStringPosition() {
        this.sp = 0;
    }

    @Override
    public void nextToken(int expect) {
        while (true) {
            switch (expect) {
                case 12: {
                    if (this.ch == '{') {
                        this.token = 12;
                        this.ch = this.buf[++this.bp];
                        return;
                    }
                    if (this.ch != '[') break;
                    this.token = 14;
                    this.ch = this.buf[++this.bp];
                    return;
                }
                case 16: {
                    if (this.ch == ',') {
                        this.token = 16;
                        this.ch = this.buf[++this.bp];
                        return;
                    }
                    if (this.ch == '}') {
                        this.token = 13;
                        this.ch = this.buf[++this.bp];
                        return;
                    }
                    if (this.ch == ']') {
                        this.token = 15;
                        this.ch = this.buf[++this.bp];
                        return;
                    }
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 2: {
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.sp = 0;
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '\"') {
                        this.sp = 0;
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.ch = this.buf[++this.bp];
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.ch = this.buf[++this.bp];
                    return;
                }
                case 4: {
                    if (this.ch == '\"') {
                        this.sp = 0;
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.sp = 0;
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.ch = this.buf[++this.bp];
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.ch = this.buf[++this.bp];
                    return;
                }
                case 14: {
                    if (this.ch == '[') {
                        this.token = 14;
                        this.ch = this.buf[++this.bp];
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.ch = this.buf[++this.bp];
                    return;
                }
                case 15: {
                    if (this.ch == ']') {
                        this.token = 15;
                        this.ch = this.buf[++this.bp];
                        return;
                    }
                }
                case 20: {
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.ch = this.buf[++this.bp];
        }
        this.nextToken();
    }

    @Override
    public final void nextToken() {
        this.sp = 0;
        block17: while (true) {
            this.pos = this.bp++;
            if (this.ch == '\"') {
                this.scanString();
                return;
            }
            if (this.ch == ',') {
                this.ch = this.buf[this.bp];
                this.token = 16;
                return;
            }
            if (this.ch >= '0' && this.ch <= '9') {
                this.scanNumber();
                return;
            }
            if (this.ch == '-') {
                this.scanNumber();
                return;
            }
            switch (this.ch) {
                case '\'': {
                    if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("Feature.AllowSingleQuotes is false");
                    }
                    this.scanStringSingleQuote();
                    return;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    this.ch = this.buf[++this.bp];
                    continue block17;
                }
                case 't': {
                    this.scanTrue();
                    return;
                }
                case 'T': {
                    this.scanTreeSet();
                    return;
                }
                case 'S': {
                    this.scanSet();
                    return;
                }
                case 'f': {
                    this.scanFalse();
                    return;
                }
                case 'n': {
                    this.scanNullOrNew();
                    return;
                }
                case 'D': {
                    this.scanIdent();
                    return;
                }
                case '(': {
                    this.ch = this.buf[++this.bp];
                    this.token = 10;
                    return;
                }
                case ')': {
                    this.ch = this.buf[++this.bp];
                    this.token = 11;
                    return;
                }
                case '[': {
                    this.ch = this.buf[++this.bp];
                    this.token = 14;
                    return;
                }
                case ']': {
                    this.ch = this.buf[++this.bp];
                    this.token = 15;
                    return;
                }
                case '{': {
                    this.ch = this.buf[++this.bp];
                    this.token = 12;
                    return;
                }
                case '}': {
                    this.ch = this.buf[++this.bp];
                    this.token = 13;
                    return;
                }
                case ':': {
                    this.ch = this.buf[++this.bp];
                    this.token = 17;
                    return;
                }
            }
            break;
        }
        if (this.bp == this.buflen || this.ch == '\u001a' && this.bp + 1 == this.buflen) {
            if (this.token == 20) {
                throw new JSONException("EOF error");
            }
            this.token = 20;
            this.pos = this.bp = this.eofPos;
        } else {
            this.lexError("illegal.char", String.valueOf((int)this.ch));
            this.ch = this.buf[++this.bp];
        }
    }

    public final void scanStringSingleQuote() {
        char ch;
        this.np = this.bp;
        this.hasSpecial = false;
        block12: while ((ch = this.buf[++this.bp]) != '\'') {
            if (ch == '\u001a') {
                throw new JSONException("unclosed single-quote string");
            }
            if (ch == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp > this.sbuf.length) {
                        char[] newsbuf = new char[this.sp * 2];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                }
                ch = this.buf[++this.bp];
                switch (ch) {
                    case '\"': {
                        this.putChar('\"');
                        continue block12;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block12;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block12;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block12;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block12;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block12;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block12;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block12;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block12;
                    }
                    case 'u': {
                        char c1 = ch = this.buf[++this.bp];
                        char c2 = ch = this.buf[++this.bp];
                        char c3 = ch = this.buf[++this.bp];
                        char c4 = ch = this.buf[++this.bp];
                        int val = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                        this.putChar((char)val);
                        continue block12;
                    }
                }
                this.ch = ch;
                throw new JSONException("unclosed single-quote string");
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(ch);
                continue;
            }
            this.sbuf[this.sp++] = ch;
        }
        this.token = 4;
        this.ch = this.buf[++this.bp];
    }

    @Override
    public final void scanString() {
        char ch;
        this.np = this.bp;
        this.hasSpecial = false;
        block12: while ((ch = this.buf[++this.bp]) != '\"') {
            if (ch == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        int newCapcity = this.sbuf.length * 2;
                        if (this.sp > newCapcity) {
                            newCapcity = this.sp;
                        }
                        char[] newsbuf = new char[newCapcity];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                }
                ch = this.buf[++this.bp];
                switch (ch) {
                    case '\"': {
                        this.putChar('\"');
                        continue block12;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block12;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block12;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block12;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block12;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block12;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block12;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block12;
                    }
                    case 'x': {
                        char x1 = ch = this.buf[++this.bp];
                        char x2 = ch = this.buf[++this.bp];
                        int x_val = digits[x1] * 16 + digits[x2];
                        char x_char = (char)x_val;
                        this.putChar(x_char);
                        continue block12;
                    }
                    case 'u': {
                        char u1 = ch = this.buf[++this.bp];
                        char u2 = ch = this.buf[++this.bp];
                        char u3 = ch = this.buf[++this.bp];
                        char u4 = ch = this.buf[++this.bp];
                        int val = Integer.parseInt(new String(new char[]{u1, u2, u3, u4}), 16);
                        this.putChar((char)val);
                        continue block12;
                    }
                }
                this.ch = ch;
                throw new JSONException("unclosed string : " + ch);
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(ch);
                continue;
            }
            this.sbuf[this.sp++] = ch;
        }
        this.token = 4;
        this.ch = this.buf[++this.bp];
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char ch;
        boolean firstFlag;
        boolean[] firstIdentifierFlags = CharTypes.firstIdentifierFlags;
        int first = this.ch;
        boolean bl = firstFlag = this.ch >= firstIdentifierFlags.length || firstIdentifierFlags[first];
        if (!firstFlag) {
            throw new JSONException("illegal identifier : " + this.ch);
        }
        boolean[] identifierFlags = CharTypes.identifierFlags;
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        while ((ch = this.buf[++this.bp]) >= identifierFlags.length || identifierFlags[ch]) {
            hash = 31 * hash + ch;
            ++this.sp;
        }
        this.ch = this.buf[this.bp];
        this.token = 18;
        int NULL_HASH = 3392903;
        if (this.sp == 4 && hash == 3392903 && this.buf[this.np] == 'n' && this.buf[this.np + 1] == 'u' && this.buf[this.np + 2] == 'l' && this.buf[this.np + 3] == 'l') {
            return null;
        }
        return symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
    }

    public int scanType(String type) {
        this.matchStat = 0;
        int fieldNameLength = typeFieldName.length;
        for (int i = 0; i < fieldNameLength; ++i) {
            if (typeFieldName[i] == this.buf[this.bp + i]) continue;
            return -2;
        }
        int bp = this.bp + fieldNameLength;
        int typeLength = type.length();
        for (int i = 0; i < typeLength; ++i) {
            if (type.charAt(i) == this.buf[bp + i]) continue;
            return -1;
        }
        if (this.buf[bp += typeLength] != '\"') {
            return -1;
        }
        this.ch = this.buf[++bp];
        if (this.ch == ',') {
            this.ch = this.buf[++bp];
            this.bp = bp;
            this.token = 16;
            return 3;
        }
        if (this.ch == '}') {
            this.ch = this.buf[++bp];
            if (this.ch == ',') {
                this.token = 16;
                this.ch = this.buf[++bp];
            } else if (this.ch == ']') {
                this.token = 15;
                this.ch = this.buf[++bp];
            } else if (this.ch == '}') {
                this.token = 13;
                this.ch = this.buf[++bp];
            } else if (this.ch == '\u001a') {
                this.token = 20;
            } else {
                return -1;
            }
            this.matchStat = 4;
        }
        this.bp = bp;
        return this.matchStat;
    }

    public boolean matchField(char[] fieldName) {
        int fieldNameLength = fieldName.length;
        for (int i = 0; i < fieldNameLength; ++i) {
            if (fieldName[i] == this.buf[this.bp + i]) continue;
            return false;
        }
        this.bp += fieldNameLength;
        this.ch = this.buf[this.bp];
        if (this.ch == '{') {
            this.ch = this.buf[++this.bp];
            this.token = 12;
        } else if (this.ch == '[') {
            this.ch = this.buf[++this.bp];
            this.token = 14;
        } else {
            this.nextToken();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(char[] fieldName) {
        String strVal;
        char ch;
        block11: {
            block12: {
                this.matchStat = 0;
                int fieldNameLength = fieldName.length;
                for (int i = 0; i < fieldNameLength; ++i) {
                    if (fieldName[i] == this.buf[this.bp + i]) continue;
                    this.matchStat = -2;
                    return null;
                }
                int index = this.bp + fieldNameLength;
                if ((ch = this.buf[index++]) != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                int start = index;
                do {
                    if ((ch = this.buf[index++]) != '\"') continue;
                    this.bp = index;
                    this.ch = ch = this.buf[this.bp];
                    strVal = new String(this.buf, start, index - start - 1);
                    if (ch != ',') break block11;
                    break block12;
                } while (ch != '\\');
                this.matchStat = -1;
                return null;
            }
            this.ch = this.buf[++this.bp];
            this.matchStat = 3;
            return strVal;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((ch = this.buf[++this.bp]) == ',') {
            this.token = 16;
            this.ch = this.buf[++this.bp];
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.buf[++this.bp];
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.buf[++this.bp];
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return strVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldSymbol(char[] fieldName, SymbolTable symbolTable) {
        String strVal;
        char ch;
        block12: {
            block13: {
                this.matchStat = 0;
                int fieldNameLength = fieldName.length;
                for (int i = 0; i < fieldNameLength; ++i) {
                    if (fieldName[i] == this.buf[this.bp + i]) continue;
                    this.matchStat = -2;
                    return null;
                }
                int index = this.bp + fieldNameLength;
                if ((ch = this.buf[index++]) != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                int start = index;
                int hash = 0;
                do {
                    if ((ch = this.buf[index++]) == '\"') {
                        this.bp = index;
                        this.ch = ch = this.buf[this.bp];
                        strVal = symbolTable.addSymbol(this.buf, start, index - start - 1, hash);
                        if (ch != ',') break block12;
                        break block13;
                    }
                    hash = 31 * hash + ch;
                } while (ch != '\\');
                this.matchStat = -1;
                return null;
            }
            this.ch = this.buf[++this.bp];
            this.matchStat = 3;
            return strVal;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((ch = this.buf[++this.bp]) == ',') {
            this.token = 16;
            this.ch = this.buf[++this.bp];
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.buf[++this.bp];
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.buf[++this.bp];
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return strVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArrayList<String> scanFieldStringArray(char[] fieldName) {
        char ch;
        this.matchStat = 0;
        ArrayList<String> list = new ArrayList<String>();
        int fieldNameLength = fieldName.length;
        for (int i = 0; i < fieldNameLength; ++i) {
            if (fieldName[i] == this.buf[this.bp + i]) continue;
            this.matchStat = -2;
            return null;
        }
        int index = this.bp + fieldNameLength;
        if ((ch = this.buf[index++]) != '[') {
            this.matchStat = -1;
            return null;
        }
        ch = this.buf[index++];
        block1: while (true) {
            block15: {
                if (ch != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                int start = index;
                do {
                    if ((ch = this.buf[index++]) != '\"') continue;
                    String strVal = new String(this.buf, start, index - start - 1);
                    list.add(strVal);
                    ch = this.buf[index++];
                    if (ch != ',') break block1;
                    break block15;
                } while (ch != '\\');
                this.matchStat = -1;
                return null;
            }
            ch = this.buf[index++];
        }
        if (ch != ']') {
            this.matchStat = -1;
            return null;
        }
        ch = this.buf[index++];
        this.bp = index;
        if (ch == ',') {
            this.ch = this.buf[this.bp];
            this.matchStat = 3;
            return list;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return null;
        }
        ch = this.buf[this.bp];
        if (ch == ',') {
            this.token = 16;
            this.ch = this.buf[++this.bp];
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.buf[++this.bp];
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.buf[++this.bp];
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.ch = ch;
        }
        this.matchStat = 4;
        return list;
    }

    public int scanFieldInt(char[] fieldName) {
        int value;
        char ch;
        this.matchStat = 0;
        int fieldNameLength = fieldName.length;
        for (int i = 0; i < fieldNameLength; ++i) {
            if (fieldName[i] == this.buf[this.bp + i]) continue;
            this.matchStat = -2;
            return 0;
        }
        int index = this.bp + fieldNameLength;
        if ((ch = this.buf[index++]) >= '0' && ch <= '9') {
            value = digits[ch];
            while ((ch = this.buf[index++]) >= '0' && ch <= '9') {
                value = value * 10 + digits[ch];
            }
            if (ch == '.') {
                this.matchStat = -1;
                return 0;
            }
            this.bp = index - 1;
            if (value < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (ch == ',') {
            ch = this.buf[++this.bp];
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (ch == '}') {
            if ((ch = this.buf[++this.bp]) == ',') {
                this.token = 16;
                this.ch = this.buf[++this.bp];
            } else if (ch == ']') {
                this.token = 15;
                this.ch = this.buf[++this.bp];
            } else if (ch == '}') {
                this.token = 13;
                this.ch = this.buf[++this.bp];
            } else if (ch == '\u001a') {
                this.token = 20;
            } else {
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = 4;
        }
        return value;
    }

    public boolean scanFieldBoolean(char[] fieldName) {
        boolean value;
        char ch;
        this.matchStat = 0;
        int fieldNameLength = fieldName.length;
        for (int i = 0; i < fieldNameLength; ++i) {
            if (fieldName[i] == this.buf[this.bp + i]) continue;
            this.matchStat = -2;
            return false;
        }
        int index = this.bp + fieldNameLength;
        if ((ch = this.buf[index++]) == 't') {
            if (this.buf[index++] != 'r') {
                this.matchStat = -1;
                return false;
            }
            if (this.buf[index++] != 'u') {
                this.matchStat = -1;
                return false;
            }
            if (this.buf[index++] != 'e') {
                this.matchStat = -1;
                return false;
            }
            this.bp = index;
            ch = this.buf[this.bp];
            value = true;
        } else if (ch == 'f') {
            if (this.buf[index++] != 'a') {
                this.matchStat = -1;
                return false;
            }
            if (this.buf[index++] != 'l') {
                this.matchStat = -1;
                return false;
            }
            if (this.buf[index++] != 's') {
                this.matchStat = -1;
                return false;
            }
            if (this.buf[index++] != 'e') {
                this.matchStat = -1;
                return false;
            }
            this.bp = index;
            ch = this.buf[this.bp];
            value = false;
        } else {
            this.matchStat = -1;
            return false;
        }
        if (ch == ',') {
            ch = this.buf[++this.bp];
            this.matchStat = 3;
            this.token = 16;
        } else if (ch == '}') {
            if ((ch = this.buf[++this.bp]) == ',') {
                this.token = 16;
                this.ch = this.buf[++this.bp];
            } else if (ch == ']') {
                this.token = 15;
                this.ch = this.buf[++this.bp];
            } else if (ch == '}') {
                this.token = 13;
                this.ch = this.buf[++this.bp];
            } else if (ch == '\u001a') {
                this.token = 20;
            } else {
                this.matchStat = -1;
                return false;
            }
            this.matchStat = 4;
        } else {
            this.matchStat = -1;
            return false;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(char[] fieldName) {
        long value;
        char ch;
        this.matchStat = 0;
        int fieldNameLength = fieldName.length;
        for (int i = 0; i < fieldNameLength; ++i) {
            if (fieldName[i] == this.buf[this.bp + i]) continue;
            this.matchStat = -2;
            return 0L;
        }
        int index = this.bp + fieldNameLength;
        if ((ch = this.buf[index++]) >= '0' && ch <= '9') {
            value = digits[ch];
            while ((ch = this.buf[index++]) >= '0' && ch <= '9') {
                value = value * 10L + (long)digits[ch];
            }
            if (ch == '.') {
                this.token = -1;
                return 0L;
            }
            this.bp = index - 1;
            if (value < 0L) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        if (ch == ',') {
            ch = this.buf[++this.bp];
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return 0L;
        }
        if ((ch = this.buf[++this.bp]) == ',') {
            this.token = 16;
            this.ch = this.buf[++this.bp];
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.buf[++this.bp];
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.buf[++this.bp];
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public float scanFieldFloat(char[] fieldName) {
        float value;
        char ch;
        block15: {
            block16: {
                block14: {
                    this.matchStat = 0;
                    int fieldNameLength = fieldName.length;
                    for (int i = 0; i < fieldNameLength; ++i) {
                        if (fieldName[i] == this.buf[this.bp + i]) continue;
                        this.matchStat = -2;
                        return 0.0f;
                    }
                    int index = this.bp + fieldNameLength;
                    if ((ch = this.buf[index++]) < '0' || ch > '9') break block14;
                    int start = index - 1;
                    while ((ch = this.buf[index++]) >= '0' && ch <= '9') {
                    }
                    if (ch == '.') {
                        if ((ch = this.buf[index++]) >= '0' && ch <= '9') {
                            while ((ch = this.buf[index++]) >= '0' && ch <= '9') {
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    this.bp = index - 1;
                    String text = new String(this.buf, start, index - start - 1);
                    value = Float.parseFloat(text);
                    if (ch != ',') break block15;
                    break block16;
                }
                this.matchStat = -1;
                return 0.0f;
            }
            ch = this.buf[++this.bp];
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return 0.0f;
        }
        if ((ch = this.buf[++this.bp]) == ',') {
            this.token = 16;
            this.ch = this.buf[++this.bp];
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.buf[++this.bp];
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.buf[++this.bp];
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return 0.0f;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] scanFieldByteArray(char[] fieldName) {
        char ch;
        this.matchStat = 0;
        int fieldNameLength = fieldName.length;
        for (int i = 0; i < fieldNameLength; ++i) {
            if (fieldName[i] == this.buf[this.bp + i]) continue;
            this.matchStat = -2;
            return null;
        }
        int index = this.bp + fieldNameLength;
        if ((ch = this.buf[index++]) != '\"' && ch != '\'') {
            this.matchStat = -1;
            return null;
        }
        char sep = ch;
        int startIndex = index;
        int endIndex = index;
        for (endIndex = index; endIndex < this.buf.length && this.buf[endIndex] != sep; ++endIndex) {
        }
        int base64Len = endIndex - startIndex;
        byte[] value = Base64.decodeFast(this.buf, startIndex, base64Len);
        if (value == null) {
            this.matchStat = -1;
            return null;
        }
        this.bp = endIndex + 1;
        ch = this.buf[this.bp];
        if (ch == ',') {
            ch = this.buf[++this.bp];
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((ch = this.buf[++this.bp]) == ',') {
            this.token = 16;
            this.ch = this.buf[++this.bp];
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.buf[++this.bp];
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.buf[++this.bp];
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return value;
    }

    @Override
    public byte[] bytesValue() {
        return Base64.decodeFast(this.buf, this.np + 1, this.sp);
    }

    /*
     * Enabled aggressive block sorting
     */
    public double scanFieldDouble(char[] fieldName) {
        double value;
        char ch;
        block15: {
            block16: {
                block14: {
                    this.matchStat = 0;
                    int fieldNameLength = fieldName.length;
                    for (int i = 0; i < fieldNameLength; ++i) {
                        if (fieldName[i] == this.buf[this.bp + i]) continue;
                        this.matchStat = -2;
                        return 0.0;
                    }
                    int index = this.bp + fieldNameLength;
                    if ((ch = this.buf[index++]) < '0' || ch > '9') break block14;
                    int start = index - 1;
                    while ((ch = this.buf[index++]) >= '0' && ch <= '9') {
                    }
                    if (ch == '.') {
                        if ((ch = this.buf[index++]) >= '0' && ch <= '9') {
                            while ((ch = this.buf[index++]) >= '0' && ch <= '9') {
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    this.bp = index - 1;
                    String text = new String(this.buf, start, index - start - 1);
                    value = Double.parseDouble(text);
                    if (ch != ',') break block15;
                    break block16;
                }
                this.matchStat = -1;
                return 0.0;
            }
            ch = this.buf[++this.bp];
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return 0.0;
        }
        if ((ch = this.buf[++this.bp]) == ',') {
            this.token = 16;
            this.ch = this.buf[++this.bp];
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.buf[++this.bp];
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.buf[++this.bp];
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return 0.0;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return value;
    }

    @Override
    public String scanSymbol(SymbolTable symbolTable) {
        this.skipWhitespace();
        if (this.ch == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.ch == '\'') {
            if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                throw new JSONException("syntax error");
            }
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.ch == '}') {
            this.ch = this.buf[++this.bp];
            this.token = 13;
            return null;
        }
        if (this.ch == ',') {
            this.ch = this.buf[++this.bp];
            this.token = 16;
            return null;
        }
        if (this.ch == '\u001a') {
            this.token = 20;
            return null;
        }
        if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            throw new JSONException("syntax error");
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    @Override
    public final String scanSymbol(SymbolTable symbolTable, char quote) {
        char ch;
        int hash = 0;
        this.np = this.bp;
        this.sp = 0;
        boolean hasSpecial = false;
        block11: while ((ch = this.buf[++this.bp]) != quote) {
            if (ch == '\u001a') {
                throw new JSONException("unclosed.str");
            }
            if (ch == '\\') {
                if (!hasSpecial) {
                    hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        int newCapcity = this.sbuf.length * 2;
                        if (this.sp > newCapcity) {
                            newCapcity = this.sp;
                        }
                        char[] newsbuf = new char[newCapcity];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                }
                ch = this.buf[++this.bp];
                switch (ch) {
                    case '\"': {
                        hash = 31 * hash + 34;
                        this.putChar('\"');
                        continue block11;
                    }
                    case '\\': {
                        hash = 31 * hash + 92;
                        this.putChar('\\');
                        continue block11;
                    }
                    case '/': {
                        hash = 31 * hash + 47;
                        this.putChar('/');
                        continue block11;
                    }
                    case 'b': {
                        hash = 31 * hash + 8;
                        this.putChar('\b');
                        continue block11;
                    }
                    case 'F': 
                    case 'f': {
                        hash = 31 * hash + 12;
                        this.putChar('\f');
                        continue block11;
                    }
                    case 'n': {
                        hash = 31 * hash + 10;
                        this.putChar('\n');
                        continue block11;
                    }
                    case 'r': {
                        hash = 31 * hash + 13;
                        this.putChar('\r');
                        continue block11;
                    }
                    case 't': {
                        hash = 31 * hash + 9;
                        this.putChar('\t');
                        continue block11;
                    }
                    case 'u': {
                        char c1 = ch = this.buf[++this.bp];
                        char c2 = ch = this.buf[++this.bp];
                        char c3 = ch = this.buf[++this.bp];
                        char c4 = ch = this.buf[++this.bp];
                        int val = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                        hash = 31 * hash + val;
                        this.putChar((char)val);
                        continue block11;
                    }
                }
                this.ch = ch;
                throw new JSONException("unclosed.str.lit");
            }
            hash = 31 * hash + ch;
            if (!hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(ch);
                continue;
            }
            this.sbuf[this.sp++] = ch;
        }
        this.token = 4;
        this.ch = this.buf[++this.bp];
        if (!hasSpecial) {
            return symbolTable.addSymbol(this.buf, this.np + 1, this.sp, hash);
        }
        return symbolTable.addSymbol(this.sbuf, 0, this.sp, hash);
    }

    public void scanTrue() {
        if (this.buf[this.bp++] != 't') {
            throw new JSONException("error parse true");
        }
        if (this.buf[this.bp++] != 'r') {
            throw new JSONException("error parse true");
        }
        if (this.buf[this.bp++] != 'u') {
            throw new JSONException("error parse true");
        }
        if (this.buf[this.bp++] != 'e') {
            throw new JSONException("error parse true");
        }
        this.ch = this.buf[this.bp];
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan true error");
        }
        this.token = 6;
    }

    public void scanSet() {
        if (this.buf[this.bp++] != 'S') {
            throw new JSONException("error parse true");
        }
        if (this.buf[this.bp++] != 'e') {
            throw new JSONException("error parse true");
        }
        if (this.buf[this.bp++] != 't') {
            throw new JSONException("error parse true");
        }
        this.ch = this.buf[this.bp];
        if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b' && this.ch != '[' && this.ch != '(') {
            throw new JSONException("scan set error");
        }
        this.token = 21;
    }

    public void scanTreeSet() {
        if (this.buf[this.bp++] != 'T') {
            throw new JSONException("error parse true");
        }
        if (this.buf[this.bp++] != 'r') {
            throw new JSONException("error parse true");
        }
        if (this.buf[this.bp++] != 'e') {
            throw new JSONException("error parse true");
        }
        if (this.buf[this.bp++] != 'e') {
            throw new JSONException("error parse true");
        }
        if (this.buf[this.bp++] != 'S') {
            throw new JSONException("error parse true");
        }
        if (this.buf[this.bp++] != 'e') {
            throw new JSONException("error parse true");
        }
        if (this.buf[this.bp++] != 't') {
            throw new JSONException("error parse true");
        }
        this.ch = this.buf[this.bp];
        if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b' && this.ch != '[' && this.ch != '(') {
            throw new JSONException("scan set error");
        }
        this.token = 22;
    }

    public void scanNullOrNew() {
        if (this.buf[this.bp++] != 'n') {
            throw new JSONException("error parse null or new");
        }
        if (this.buf[this.bp] == 'u') {
            ++this.bp;
            if (this.buf[this.bp++] != 'l') {
                throw new JSONException("error parse true");
            }
            if (this.buf[this.bp++] != 'l') {
                throw new JSONException("error parse true");
            }
            this.ch = this.buf[this.bp];
            if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
                throw new JSONException("scan true error");
            }
            this.token = 8;
            return;
        }
        if (this.buf[this.bp] != 'e') {
            throw new JSONException("error parse e");
        }
        ++this.bp;
        if (this.buf[this.bp++] != 'w') {
            throw new JSONException("error parse w");
        }
        this.ch = this.buf[this.bp];
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan true error");
        }
        this.token = 9;
    }

    public void scanFalse() {
        if (this.buf[this.bp++] != 'f') {
            throw new JSONException("error parse false");
        }
        if (this.buf[this.bp++] != 'a') {
            throw new JSONException("error parse false");
        }
        if (this.buf[this.bp++] != 'l') {
            throw new JSONException("error parse false");
        }
        if (this.buf[this.bp++] != 's') {
            throw new JSONException("error parse false");
        }
        if (this.buf[this.bp++] != 'e') {
            throw new JSONException("error parse false");
        }
        this.ch = this.buf[this.bp];
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan false error");
        }
        this.token = 7;
    }

    public void scanIdent() {
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            ++this.sp;
            this.ch = this.buf[++this.bp];
        } while (Character.isLetterOrDigit(this.ch));
        String ident = this.stringVal();
        Integer tok = this.keywods.getKeyword(ident);
        this.token = tok != null ? tok : 18;
    }

    @Override
    public void scanNumber() {
        this.np = this.bp++;
        if (this.ch == '-') {
            ++this.sp;
            this.ch = this.buf[this.bp];
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
        }
        if (this.ch == 'L') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
        } else if (this.ch == 'S') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
        } else if (this.ch == 'B') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
        } else if (this.ch == 'F') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            isDouble = true;
        } else if (this.ch == 'D') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            isDouble = true;
        } else if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
            isDouble = true;
        }
        this.token = isDouble ? 3 : 2;
    }

    private final void putChar(char ch) {
        if (this.sp == this.sbuf.length) {
            char[] newsbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
            this.sbuf = newsbuf;
        }
        this.sbuf[this.sp++] = ch;
    }

    @Override
    public final int pos() {
        return this.pos;
    }

    @Override
    public final String stringVal() {
        if (!this.hasSpecial) {
            return new String(this.buf, this.np + 1, this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    public boolean isRef() {
        if (this.hasSpecial) {
            return false;
        }
        if (this.sp != 4) {
            return false;
        }
        return this.buf[this.np + 1] == '$' && this.buf[this.np + 2] == 'r' && this.buf[this.np + 3] == 'e' && this.buf[this.np + 4] == 'f';
    }

    @Override
    public final String symbol(SymbolTable symbolTable) {
        if (symbolTable == null) {
            if (!this.hasSpecial) {
                return new String(this.buf, this.np + 1, this.sp);
            }
            return new String(this.sbuf, 0, this.sp);
        }
        if (!this.hasSpecial) {
            return symbolTable.addSymbol(this.buf, this.np + 1, this.sp);
        }
        return symbolTable.addSymbol(this.sbuf, 0, this.sp);
    }

    @Override
    public Number integerValue() throws NumberFormatException {
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        int type = 32;
        if (max > 0) {
            switch (this.buf[max - 1]) {
                case 'L': {
                    --max;
                    type = 76;
                    break;
                }
                case 'S': {
                    --max;
                    type = 83;
                    break;
                }
                case 'B': {
                    --max;
                    type = 66;
                    break;
                }
            }
        }
        if (this.buf[this.np] == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.buf[i++]];
            result = -digit;
        }
        while (i < max) {
            digit = digits[this.buf[i++]];
            if (result < multmin) {
                return new BigInteger(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                if (result >= Integer.MIN_VALUE && type != 76) {
                    if (type == 83) {
                        return (short)result;
                    }
                    if (type == 66) {
                        return (byte)result;
                    }
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((result = -result) <= Integer.MAX_VALUE && type != 76) {
            if (type == 83) {
                return (short)result;
            }
            if (type == 66) {
                return (byte)result;
            }
            return (int)result;
        }
        return result;
    }

    @Override
    public long longValue() throws NumberFormatException {
        char ch;
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.buf[this.np] == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.buf[i++]];
            result = -digit;
        }
        while (i < max && (ch = this.buf[i++]) != 'L' && ch != 'S' && ch != 'B') {
            digit = digits[ch];
            if (result < multmin) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    @Override
    public int intValue() {
        char ch;
        int digit;
        int multmin;
        int limit;
        int result = 0;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.buf[this.np] == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int n = multmin = negative ? -214748364 : -214748364;
        if (i < max) {
            digit = digits[this.buf[i++]];
            result = -digit;
        }
        while (i < max && (ch = this.buf[i++]) != 'L' && ch != 'S' && ch != 'B') {
            digit = digits[ch];
            if (result < multmin) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10) < limit + digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    @Override
    public final String numberString() {
        char ch = this.buf[this.np + this.sp - 1];
        int sp = this.sp;
        if (ch == 'L' || ch == 'S' || ch == 'B' || ch == 'F' || ch == 'D') {
            --sp;
        }
        return new String(this.buf, this.np, sp);
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.numberString());
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    @Override
    public Number decimalValue(boolean decimal) {
        char ch = this.buf[this.np + this.sp - 1];
        if (ch == 'F') {
            return Float.valueOf(Float.parseFloat(new String(this.buf, this.np, this.sp - 1)));
        }
        if (ch == 'D') {
            return Double.parseDouble(new String(this.buf, this.np, this.sp - 1));
        }
        if (decimal) {
            return this.decimalValue();
        }
        return this.doubleValue();
    }

    @Override
    public BigDecimal decimalValue() {
        char ch = this.buf[this.np + this.sp - 1];
        int sp = this.sp;
        if (ch == 'L' || ch == 'S' || ch == 'B' || ch == 'F' || ch == 'D') {
            --sp;
        }
        return new BigDecimal(this.buf, this.np, sp);
    }

    @Override
    public void config(Feature feature, boolean state) {
        this.features = Feature.config(this.features, feature, state);
    }

    @Override
    public boolean isEnabled(Feature feature) {
        return Feature.isEnabled(this.features, feature);
    }

    @Override
    public boolean scanISO8601DateIfMatch() {
        int rest = this.buflen - this.bp;
        if (rest < this.ISO8601_LEN_0) {
            return false;
        }
        char y0 = this.buf[this.bp];
        char y1 = this.buf[this.bp + 1];
        char y2 = this.buf[this.bp + 2];
        char y3 = this.buf[this.bp + 3];
        if (y0 != '1' && y0 != '2') {
            return false;
        }
        if (y1 < '0' || y1 > '9') {
            return false;
        }
        if (y2 < '0' || y2 > '9') {
            return false;
        }
        if (y3 < '0' || y3 > '9') {
            return false;
        }
        if (this.buf[this.bp + 4] != '-') {
            return false;
        }
        char M0 = this.buf[this.bp + 5];
        char M1 = this.buf[this.bp + 6];
        if (M0 == '0') {
            if (M1 < '1' || M1 > '9') {
                return false;
            }
        } else if (M0 == '1') {
            if (M1 != '0' && M1 != '1' && M1 != '2') {
                return false;
            }
        } else {
            return false;
        }
        if (this.buf[this.bp + 7] != '-') {
            return false;
        }
        char d0 = this.buf[this.bp + 8];
        char d1 = this.buf[this.bp + 9];
        if (d0 == '0') {
            if (d1 < '1' || d1 > '9') {
                return false;
            }
        } else if (d0 == '1' || d0 == '2') {
            if (d1 < '0' || d1 > '9') {
                return false;
            }
        } else if (d0 == '3') {
            if (d1 != '0' && d1 != '1') {
                return false;
            }
        } else {
            return false;
        }
        Locale local = Locale.getDefault();
        this.calendar = Calendar.getInstance(TimeZone.getDefault(), local);
        int year = digits[y0] * 1000 + digits[y1] * 100 + digits[y2] * 10 + digits[y3];
        int month = digits[M0] * 10 + digits[M1] - 1;
        int day = digits[d0] * 10 + digits[d1];
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, day);
        char t = this.buf[this.bp + 10];
        if (t == 'T') {
            if (rest < this.ISO8601_LEN_1) {
                return false;
            }
        } else {
            if (t == '\"' || t == '\u001a') {
                this.calendar.set(11, 0);
                this.calendar.set(12, 0);
                this.calendar.set(13, 0);
                this.calendar.set(14, 0);
                this.ch = this.buf[this.bp += 10];
                this.token = 5;
                return true;
            }
            return false;
        }
        char h0 = this.buf[this.bp + 11];
        char h1 = this.buf[this.bp + 12];
        if (h0 == '0') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '1') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '2') {
            if (h1 < '0' || h1 > '4') {
                return false;
            }
        } else {
            return false;
        }
        if (this.buf[this.bp + 13] != ':') {
            return false;
        }
        char m0 = this.buf[this.bp + 14];
        char m1 = this.buf[this.bp + 15];
        if (m0 >= '0' && m0 <= '5') {
            if (m1 < '0' || m1 > '9') {
                return false;
            }
        } else if (m0 == '6') {
            if (m1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        if (this.buf[this.bp + 16] != ':') {
            return false;
        }
        char s0 = this.buf[this.bp + 17];
        char s1 = this.buf[this.bp + 18];
        if (s0 >= '0' && s0 <= '5') {
            if (s1 < '0' || s1 > '9') {
                return false;
            }
        } else if (s0 == '6') {
            if (s1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        int hour = digits[h0] * 10 + digits[h1];
        int minute = digits[m0] * 10 + digits[m1];
        int seconds = digits[s0] * 10 + digits[s1];
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, seconds);
        char dot = this.buf[this.bp + 19];
        if (dot == '.') {
            if (rest < this.ISO8601_LEN_2) {
                return false;
            }
        } else {
            this.calendar.set(14, 0);
            this.ch = this.buf[this.bp += 19];
            this.token = 5;
            return true;
        }
        char S0 = this.buf[this.bp + 20];
        char S1 = this.buf[this.bp + 21];
        char S2 = this.buf[this.bp + 22];
        if (S0 < '0' || S0 > '9') {
            return false;
        }
        if (S1 < '0' || S1 > '9') {
            return false;
        }
        if (S2 < '0' || S2 > '9') {
            return false;
        }
        int millis = digits[S0] * 100 + digits[S1] * 10 + digits[S2];
        this.calendar.set(14, millis);
        this.ch = this.buf[this.bp += 23];
        this.token = 5;
        return true;
    }

    @Override
    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public boolean isEOF() {
        switch (this.token) {
            case 20: {
                return true;
            }
            case 1: {
                return false;
            }
            case 13: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.sbuf.length <= 8192) {
            sbufRefLocal.set(new SoftReference<char[]>(this.sbuf));
        }
        this.sbuf = null;
    }

    static {
        int i;
        sbufRefLocal = new ThreadLocal();
        whitespaceFlags = new boolean[256];
        JSONScanner.whitespaceFlags[32] = true;
        JSONScanner.whitespaceFlags[10] = true;
        JSONScanner.whitespaceFlags[13] = true;
        JSONScanner.whitespaceFlags[9] = true;
        JSONScanner.whitespaceFlags[12] = true;
        JSONScanner.whitespaceFlags[8] = true;
        typeFieldName = "\"@type\":\"".toCharArray();
        digits = new int[103];
        for (i = 48; i <= 57; ++i) {
            JSONScanner.digits[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            JSONScanner.digits[i] = i - 97 + 10;
        }
        for (i = 65; i <= 70; ++i) {
            JSONScanner.digits[i] = i - 65 + 10;
        }
    }
}

