/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.serializer.FieldSerializer;
import com.alibaba.fastjson.serializer.FilterUtils;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.NumberFieldSerializer;
import com.alibaba.fastjson.serializer.ObjectFieldSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanSerializer
implements ObjectSerializer {
    private final FieldSerializer[] getters;
    private final FieldSerializer[] sortedGetters;

    public FieldSerializer[] getGetters() {
        return this.getters;
    }

    public JavaBeanSerializer(Class<?> clazz) {
        this(clazz, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> clazz, String ... aliasList) {
        this(clazz, JavaBeanSerializer.createAliasMap(aliasList));
    }

    static Map<String, String> createAliasMap(String ... aliasList) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (String alias : aliasList) {
            aliasMap.put(alias, alias);
        }
        return aliasMap;
    }

    public JavaBeanSerializer(Class<?> clazz, Map<String, String> aliasMap) {
        ArrayList<FieldSerializer> getterList = new ArrayList<FieldSerializer>();
        List<FieldInfo> fieldInfoList = TypeUtils.computeGetters(clazz, aliasMap);
        for (FieldInfo fieldInfo : fieldInfoList) {
            getterList.add(this.createFieldSerializer(fieldInfo));
        }
        this.getters = getterList.toArray(new FieldSerializer[getterList.size()]);
        this.sortedGetters = getterList.toArray(new FieldSerializer[getterList.size()]);
        Arrays.sort(this.sortedGetters);
    }

    protected boolean isWriteClassName(JSONSerializer serializer, Object obj, Type fieldType, Object fieldName) {
        return serializer.isWriteClassName(fieldType, obj);
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        if (serializer.containsReference(object)) {
            this.writeReference(serializer, object);
            return;
        }
        FieldSerializer[] getters = out.isEnabled(SerializerFeature.SortField) ? this.sortedGetters : this.getters;
        SerialContext parent = serializer.getContext();
        serializer.setContext(parent, object, fieldName);
        try {
            Class<?> objClass;
            out.append('{');
            if (getters.length > 0 && out.isEnabled(SerializerFeature.PrettyFormat)) {
                serializer.incrementIndent();
                serializer.println();
            }
            boolean commaFlag = false;
            if (this.isWriteClassName(serializer, object, fieldType, fieldName) && (objClass = object.getClass()) != fieldType) {
                out.writeFieldName("@type");
                serializer.write(object.getClass());
                commaFlag = true;
            }
            for (int i = 0; i < getters.length; ++i) {
                Field field;
                FieldSerializer fieldSerializer = getters[i];
                if (serializer.isEnabled(SerializerFeature.SkipTransientField) && (field = fieldSerializer.getField()) != null && Modifier.isTransient(field.getModifiers())) continue;
                Object propertyValue = fieldSerializer.getPropertyValue(object);
                if (!FilterUtils.apply(serializer, object, fieldSerializer.getName(), propertyValue)) continue;
                String key = FilterUtils.processKey(serializer, object, fieldSerializer.getName(), propertyValue);
                Object originalValue = propertyValue;
                propertyValue = FilterUtils.processValue(serializer, object, fieldSerializer.getName(), propertyValue);
                if (propertyValue == null && !fieldSerializer.isWriteNull() && !serializer.isEnabled(SerializerFeature.WriteMapNullValue)) continue;
                if (commaFlag) {
                    out.append(',');
                    if (out.isEnabled(SerializerFeature.PrettyFormat)) {
                        serializer.println();
                    }
                }
                if (key != fieldSerializer.getName()) {
                    out.writeFieldName(key);
                    serializer.write(propertyValue);
                } else if (originalValue != propertyValue) {
                    fieldSerializer.writePrefix(serializer);
                    serializer.write(propertyValue);
                } else {
                    fieldSerializer.writeProperty(serializer, propertyValue);
                }
                commaFlag = true;
            }
            if (getters.length > 0 && out.isEnabled(SerializerFeature.PrettyFormat)) {
                serializer.decrementIdent();
                serializer.println();
            }
            out.append('}');
        }
        catch (Exception e) {
            throw new JSONException("write javaBean error", e);
        }
        finally {
            serializer.setContext(parent);
        }
    }

    public void writeReference(JSONSerializer serializer, Object object) {
        serializer.writeReference(object);
    }

    public FieldSerializer createFieldSerializer(FieldInfo fieldInfo) {
        Class<?> clazz = fieldInfo.getFieldClass();
        if (clazz == Number.class) {
            return new NumberFieldSerializer(fieldInfo);
        }
        return new ObjectFieldSerializer(fieldInfo);
    }
}

