/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.CharTypes;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.util.Base64;
import com.alibaba.fastjson.util.IOUtils;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;

public final class JSONReaderScanner
extends JSONLexer {
    public static final int BUF_INIT_LEN = 8192;
    private static final ThreadLocal<SoftReference<char[]>> BUF_REF_LOCAL = new ThreadLocal();
    private Reader reader;
    private char[] buf;
    private int bufLength;
    protected static final char[] typeFieldName = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();

    public JSONReaderScanner(String input) {
        this(input, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(String input, int features) {
        this(new StringReader(input), features);
    }

    public JSONReaderScanner(char[] input, int inputLength) {
        this(input, inputLength, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader) {
        this(reader, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader, int features) {
        this.reader = reader;
        this.features = features;
        SoftReference<char[]> bufRef = BUF_REF_LOCAL.get();
        if (bufRef != null) {
            this.buf = bufRef.get();
            BUF_REF_LOCAL.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[8192];
        }
        try {
            this.bufLength = reader.read(this.buf);
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
        this.bp = -1;
        this.next();
        if (this.ch == '\ufeff') {
            this.next();
        }
    }

    public JSONReaderScanner(char[] input, int inputLength, int features) {
        this(new CharArrayReader(input, 0, inputLength), features);
    }

    public final char charAt(int index) {
        if (index >= this.bufLength) {
            if (this.bufLength == -1) {
                return '\u001a';
            }
            int rest = this.bufLength - this.bp;
            if (rest > 0) {
                System.arraycopy(this.buf, this.bp, this.buf, 0, rest);
            }
            try {
                this.bufLength = this.reader.read(this.buf, rest, this.buf.length - rest);
            }
            catch (IOException e) {
                throw new JSONException(e.getMessage(), e);
            }
            if (this.bufLength == 0) {
                throw new JSONException("illegal stat, textLength is zero");
            }
            if (this.bufLength == -1) {
                return '\u001a';
            }
            this.bufLength += rest;
            index -= this.bp;
            this.np -= this.bp;
            this.bp = 0;
        }
        return this.buf[index];
    }

    public final int indexOf(char ch, int startIndex) {
        int offset = startIndex;
        while (ch != this.charAt(offset)) {
            if (ch == '\u001a') {
                return -1;
            }
            ++offset;
        }
        return offset;
    }

    public final String addSymbol(int offset, int len, int hash, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.buf, offset, len, hash);
    }

    public final char next() {
        int index;
        if ((index = ++this.bp) >= this.bufLength) {
            if (this.bufLength == -1) {
                return '\u001a';
            }
            if (this.sp > 0) {
                if (this.token == 4) {
                    System.arraycopy(this.buf, this.np + 1, this.buf, 0, this.sp);
                    this.np = -1;
                } else {
                    System.arraycopy(this.buf, this.bufLength - this.sp, this.buf, 0, this.sp);
                    this.np = 0;
                }
            }
            index = this.bp = this.sp;
            try {
                int startPos = this.bp;
                int readLength = this.buf.length - startPos;
                this.bufLength = this.reader.read(this.buf, this.bp, readLength);
            }
            catch (IOException e) {
                throw new JSONException(e.getMessage(), e);
            }
            if (this.bufLength == 0) {
                throw new JSONException("illegal stat, textLength is zero");
            }
            if (this.bufLength == -1) {
                this.ch = '\u001a';
                return '\u001a';
            }
            this.bufLength += this.bp;
        }
        this.ch = this.buf[index];
        return this.ch;
    }

    public void scanString() {
        char chLocal;
        this.np = this.bp;
        this.hasSpecial = false;
        int offset = 0;
        block12: while ((chLocal = this.charAt(this.bp + ++offset)) != '\"') {
            if (chLocal == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        int newCapcity = this.sbuf.length * 2;
                        if (this.sp > newCapcity) {
                            newCapcity = this.sp;
                        }
                        char[] newsbuf = new char[newCapcity];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    this.copyTo(this.bp + 1, this.sp, this.sbuf);
                }
                chLocal = this.charAt(this.bp + ++offset);
                switch (chLocal) {
                    case '\"': {
                        this.putChar('\"');
                        continue block12;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block12;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block12;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block12;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block12;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block12;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block12;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block12;
                    }
                    case 'x': {
                        char x1 = chLocal = this.charAt(++this.bp);
                        char x2 = chLocal = this.charAt(++this.bp);
                        int x_val = digits[x1] * 16 + digits[x2];
                        char x_char = (char)x_val;
                        this.putChar(x_char);
                        continue block12;
                    }
                    case 'u': {
                        char u1 = chLocal = this.charAt(++this.bp);
                        char u2 = chLocal = this.charAt(++this.bp);
                        char u3 = chLocal = this.charAt(++this.bp);
                        char u4 = chLocal = this.charAt(++this.bp);
                        int val = Integer.parseInt(new String(new char[]{u1, u2, u3, u4}), 16);
                        this.putChar((char)val);
                        continue block12;
                    }
                }
                this.ch = chLocal;
                throw new JSONException("unclosed string : " + chLocal);
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(chLocal);
                continue;
            }
            this.sbuf[this.sp++] = chLocal;
        }
        this.bp += offset;
        this.token = 4;
        this.next();
    }

    public final void scanStringSingleQuote() {
        this.np = this.bp;
        this.hasSpecial = false;
        block13: while (true) {
            this.next();
            char chLocal = this.charAt(++this.bp);
            if (chLocal == '\'') break;
            if (chLocal == '\u001a') {
                throw new JSONException("unclosed single-quote string");
            }
            if (chLocal == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp > this.sbuf.length) {
                        char[] newsbuf = new char[this.sp * 2];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                }
                chLocal = this.charAt(++this.bp);
                switch (chLocal) {
                    case '\"': {
                        this.putChar('\"');
                        continue block13;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block13;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block13;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block13;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block13;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block13;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block13;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block13;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block13;
                    }
                    case 'x': {
                        char x1 = chLocal = this.charAt(++this.bp);
                        char x2 = chLocal = this.charAt(++this.bp);
                        int x_val = digits[x1] * 16 + digits[x2];
                        char x_char = (char)x_val;
                        this.putChar(x_char);
                        continue block13;
                    }
                    case 'u': {
                        char c1 = chLocal = this.charAt(++this.bp);
                        char c2 = chLocal = this.charAt(++this.bp);
                        char c3 = chLocal = this.charAt(++this.bp);
                        char c4 = chLocal = this.charAt(++this.bp);
                        int val = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                        this.putChar((char)val);
                        continue block13;
                    }
                }
                this.ch = chLocal;
                throw new JSONException("unclosed single-quote string");
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(chLocal);
                continue;
            }
            this.sbuf[this.sp++] = chLocal;
        }
        this.token = 4;
        this.next();
    }

    protected final void copyTo(int offset, int count, char[] dest) {
        System.arraycopy(this.buf, offset, dest, 0, count);
    }

    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char chLocal;
        boolean firstFlag;
        boolean[] firstIdentifierFlags = CharTypes.firstIdentifierFlags;
        int first = this.ch;
        boolean bl = firstFlag = this.ch >= firstIdentifierFlags.length || firstIdentifierFlags[first];
        if (!firstFlag) {
            throw new JSONException("illegal identifier : " + this.ch);
        }
        boolean[] identifierFlags = CharTypes.identifierFlags;
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        while ((chLocal = this.charAt(++this.bp)) >= identifierFlags.length || identifierFlags[chLocal]) {
            hash = 31 * hash + chLocal;
            ++this.sp;
        }
        this.ch = this.charAt(this.bp);
        this.token = 18;
        int NULL_HASH = 3392903;
        if (this.sp == 4 && hash == 3392903 && this.charAt(this.np) == 'n' && this.charAt(this.np + 1) == 'u' && this.charAt(this.np + 2) == 'l' && this.charAt(this.np + 3) == 'l') {
            return null;
        }
        return symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
    }

    public final int scanType(String type) {
        this.matchStat = 0;
        if (!JSONReaderScanner.charArrayCompare(this.buf, this.bp, typeFieldName)) {
            return -2;
        }
        int bpLocal = this.bp + typeFieldName.length;
        int typeLength = type.length();
        for (int i = 0; i < typeLength; ++i) {
            if (type.charAt(i) == this.charAt(bpLocal + i)) continue;
            return -1;
        }
        if (this.charAt(bpLocal += typeLength) != '\"') {
            return -1;
        }
        this.ch = this.charAt(++bpLocal);
        if (this.ch == ',') {
            this.ch = this.charAt(++bpLocal);
            this.bp = bpLocal;
            this.token = 16;
            return 3;
        }
        if (this.ch == '}') {
            this.ch = this.charAt(++bpLocal);
            if (this.ch == ',') {
                this.token = 16;
                this.ch = this.charAt(++bpLocal);
            } else if (this.ch == ']') {
                this.token = 15;
                this.ch = this.charAt(++bpLocal);
            } else if (this.ch == '}') {
                this.token = 13;
                this.ch = this.charAt(++bpLocal);
            } else if (this.ch == '\u001a') {
                this.token = 20;
            } else {
                return -1;
            }
            this.matchStat = 4;
        }
        this.bp = bpLocal;
        return this.matchStat;
    }

    public final boolean matchField(char[] fieldName) {
        if (!this.charArrayCompare(fieldName)) {
            return false;
        }
        this.bp += fieldName.length;
        this.ch = this.charAt(this.bp);
        if (this.ch == '{') {
            this.next();
            this.token = 12;
        } else if (this.ch == '[') {
            this.next();
            this.token = 14;
        } else {
            this.nextToken();
        }
        return true;
    }

    static final boolean charArrayCompare(char[] src, int offset, char[] dest) {
        int destLen = dest.length;
        if (destLen + offset > src.length) {
            return false;
        }
        for (int i = 0; i < destLen; ++i) {
            if (dest[i] == src[offset + i]) continue;
            return false;
        }
        return true;
    }

    public final boolean charArrayCompare(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (this.charAt(this.bp + i) == chars[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] bytesValue() {
        return Base64.decodeFast(this.buf, this.np + 1, this.sp);
    }

    public final String scanSymbol(SymbolTable symbolTable, char quote) {
        char chLocal;
        int hash = 0;
        this.np = this.bp;
        this.sp = 0;
        boolean hasSpecial = false;
        block11: while ((chLocal = this.charAt(++this.bp)) != quote) {
            if (chLocal == '\u001a') {
                throw new JSONException("unclosed.str");
            }
            if (chLocal == '\\') {
                if (!hasSpecial) {
                    hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        int newCapcity = this.sbuf.length * 2;
                        if (this.sp > newCapcity) {
                            newCapcity = this.sp;
                        }
                        char[] newsbuf = new char[newCapcity];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                }
                chLocal = this.charAt(++this.bp);
                switch (chLocal) {
                    case '\"': {
                        hash = 31 * hash + 34;
                        this.putChar('\"');
                        continue block11;
                    }
                    case '\\': {
                        hash = 31 * hash + 92;
                        this.putChar('\\');
                        continue block11;
                    }
                    case '/': {
                        hash = 31 * hash + 47;
                        this.putChar('/');
                        continue block11;
                    }
                    case 'b': {
                        hash = 31 * hash + 8;
                        this.putChar('\b');
                        continue block11;
                    }
                    case 'F': 
                    case 'f': {
                        hash = 31 * hash + 12;
                        this.putChar('\f');
                        continue block11;
                    }
                    case 'n': {
                        hash = 31 * hash + 10;
                        this.putChar('\n');
                        continue block11;
                    }
                    case 'r': {
                        hash = 31 * hash + 13;
                        this.putChar('\r');
                        continue block11;
                    }
                    case 't': {
                        hash = 31 * hash + 9;
                        this.putChar('\t');
                        continue block11;
                    }
                    case 'u': {
                        char c1 = chLocal = this.charAt(++this.bp);
                        char c2 = chLocal = this.charAt(++this.bp);
                        char c3 = chLocal = this.charAt(++this.bp);
                        char c4 = chLocal = this.charAt(++this.bp);
                        int val = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                        hash = 31 * hash + val;
                        this.putChar((char)val);
                        continue block11;
                    }
                }
                this.ch = chLocal;
                throw new JSONException("unclosed.str.lit");
            }
            hash = 31 * hash + chLocal;
            if (!hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(chLocal);
                continue;
            }
            this.sbuf[this.sp++] = chLocal;
        }
        this.token = 4;
        this.next();
        if (!hasSpecial) {
            return symbolTable.addSymbol(this.buf, this.np + 1, this.sp, hash);
        }
        return symbolTable.addSymbol(this.sbuf, 0, this.sp, hash);
    }

    public void scanIdent() {
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            ++this.sp;
            this.next();
        } while (Character.isLetterOrDigit(this.ch));
        String ident = this.stringVal();
        Integer tok = this.keywods.getKeyword(ident);
        this.token = tok != null ? tok : 18;
    }

    public final String stringVal() {
        if (!this.hasSpecial) {
            return new String(this.buf, this.np + 1, this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    public final String subString(int offset, int count) {
        return new String(this.buf, offset, count);
    }

    public final String symbol(SymbolTable symbolTable) {
        if (symbolTable == null) {
            if (!this.hasSpecial) {
                return new String(this.buf, this.np + 1, this.sp);
            }
            return new String(this.sbuf, 0, this.sp);
        }
        if (!this.hasSpecial) {
            return symbolTable.addSymbol(this.buf, this.np + 1, this.sp);
        }
        return symbolTable.addSymbol(this.sbuf, 0, this.sp);
    }

    public final String numberString() {
        char chLocal = this.charAt(this.np + this.sp - 1);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        return new String(this.buf, this.np, sp);
    }

    public void close() {
        super.close();
        BUF_REF_LOCAL.set(new SoftReference<char[]>(this.buf));
        this.buf = null;
        IOUtils.close(this.reader);
    }

    public boolean isEOF() {
        return this.bufLength == -1 || this.bp == this.buf.length || this.ch == '\u001a' && this.bp + 1 == this.buf.length;
    }

    public final boolean isRef() {
        if (this.hasSpecial) {
            return false;
        }
        if (this.sp != 4) {
            return false;
        }
        return this.charAt(this.np + 1) == '$' && this.charAt(this.np + 2) == 'r' && this.charAt(this.np + 3) == 'e' && this.charAt(this.np + 4) == 'f';
    }
}

