/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final DateCodec instance = new DateCodec();

    private DateCodec() {
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        Date date;
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull();
            return;
        }
        if ((out.features & SerializerFeature.WriteClassName.mask) != 0 && object.getClass() != fieldType) {
            if (object.getClass() == Date.class) {
                out.write("new Date(");
                out.writeLong(((Date)object).getTime());
                out.write(41);
            } else {
                out.write(123);
                out.writeFieldName("@type", false);
                serializer.write(object.getClass().getName());
                out.write(44);
                out.writeFieldName("val", false);
                out.writeLong(((Date)object).getTime());
                out.write(125);
            }
            return;
        }
        if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            date = calendar.getTime();
        } else {
            date = (Date)object;
        }
        if ((out.features & SerializerFeature.WriteDateUseDateFormat.mask) != 0) {
            DateFormat format = serializer.getDateFormat();
            if (format == null) {
                format = new SimpleDateFormat(JSON.DEFFAULT_DATE_FORMAT, serializer.locale);
                format.setTimeZone(serializer.timeZone);
            }
            String text = format.format(date);
            out.writeString(text);
            return;
        }
        long time = date.getTime();
        if ((out.features & SerializerFeature.UseISO8601DateFormat.mask) != 0) {
            char[] buf;
            if ((out.features & SerializerFeature.UseSingleQuotes.mask) != 0) {
                out.write(39);
            } else {
                out.write(34);
            }
            Calendar calendar = Calendar.getInstance(serializer.timeZone, serializer.locale);
            calendar.setTimeInMillis(time);
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            int millis = calendar.get(14);
            if (millis != 0) {
                buf = "0000-00-00T00:00:00.000".toCharArray();
                SerializeWriter.getChars(millis, 23, buf);
                SerializeWriter.getChars(second, 19, buf);
                SerializeWriter.getChars(minute, 16, buf);
                SerializeWriter.getChars(hour, 13, buf);
                SerializeWriter.getChars(day, 10, buf);
                SerializeWriter.getChars(month, 7, buf);
                SerializeWriter.getChars(year, 4, buf);
            } else if (second == 0 && minute == 0 && hour == 0) {
                buf = "0000-00-00".toCharArray();
                SerializeWriter.getChars(day, 10, buf);
                SerializeWriter.getChars(month, 7, buf);
                SerializeWriter.getChars(year, 4, buf);
            } else {
                buf = "0000-00-00T00:00:00".toCharArray();
                SerializeWriter.getChars(second, 19, buf);
                SerializeWriter.getChars(minute, 16, buf);
                SerializeWriter.getChars(hour, 13, buf);
                SerializeWriter.getChars(day, 10, buf);
                SerializeWriter.getChars(month, 7, buf);
                SerializeWriter.getChars(year, 4, buf);
            }
            out.write(buf);
            if ((out.features & SerializerFeature.UseSingleQuotes.mask) != 0) {
                out.write(39);
            } else {
                out.write(34);
            }
        } else {
            out.writeLong(time);
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Calendar calendar;
        Object val;
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token == 2) {
            val = lexer.longValue();
            lexer.nextToken(16);
        } else if (token == 4) {
            String strVal = lexer.stringVal();
            val = strVal;
            lexer.nextToken(16);
            if ((lexer.features & Feature.AllowISO8601DateFormat.mask) != 0) {
                JSONLexer iso8601Lexer = new JSONLexer(strVal);
                if (iso8601Lexer.scanISO8601DateIfMatch(true)) {
                    calendar = iso8601Lexer.getCalendar();
                    if (clazz == Calendar.class) {
                        iso8601Lexer.close();
                        return (T)calendar;
                    }
                    val = calendar.getTime();
                }
                iso8601Lexer.close();
            }
        } else if (token == 8) {
            lexer.nextToken();
            val = null;
        } else if (token == 12) {
            lexer.nextToken();
            if (lexer.token() == 4) {
                String key = lexer.stringVal();
                if ("@type".equals(key)) {
                    lexer.nextToken();
                    parser.accept(17);
                    String typeName = lexer.stringVal();
                    Class<?> type = TypeUtils.loadClass(typeName, parser.config.defaultClassLoader);
                    if (type != null) {
                        clazz = type;
                    }
                    parser.accept(4);
                    parser.accept(16);
                }
            } else {
                throw new JSONException("syntax error");
            }
            lexer.nextTokenWithChar(':');
            if (lexer.token() != 2) {
                throw new JSONException("syntax error : " + lexer.tokenName());
            }
            long timeMillis = lexer.longValue();
            lexer.nextToken();
            val = timeMillis;
            parser.accept(13);
        } else if (parser.resolveStatus == 2) {
            parser.resolveStatus = 0;
            parser.accept(16);
            if (lexer.token() == 4) {
                if (!"val".equals(lexer.stringVal())) {
                    throw new JSONException("syntax error");
                }
            } else {
                throw new JSONException("syntax error");
            }
            lexer.nextToken();
            parser.accept(17);
            val = parser.parse();
            parser.accept(13);
        } else {
            val = parser.parse();
        }
        T obj = this.cast(parser, clazz, fieldName, val);
        if (clazz == Calendar.class) {
            if (obj instanceof Calendar) {
                return obj;
            }
            Date date = (Date)obj;
            if (date == null) {
                return null;
            }
            calendar = Calendar.getInstance(lexer.timeZone, lexer.locale);
            calendar.setTime(date);
            return (T)calendar;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T cast(DefaultJSONParser parser, Type clazz, Object fieldName, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return (T)val;
        }
        if (val instanceof Number) {
            return (T)new Date(((Number)val).longValue());
        }
        if (val instanceof String) {
            String strVal = (String)val;
            if (strVal.length() == 0) {
                return null;
            }
            JSONLexer dateLexer = new JSONLexer(strVal);
            try {
                if (dateLexer.scanISO8601DateIfMatch(false)) {
                    Calendar calendar = dateLexer.getCalendar();
                    if (clazz == Calendar.class) {
                        Calendar calendar2 = calendar;
                        return (T)calendar2;
                    }
                    Date date = calendar.getTime();
                    return (T)date;
                }
            }
            finally {
                dateLexer.close();
            }
            DateFormat dateFormat = parser.getDateFormat();
            try {
                return (T)dateFormat.parse(strVal);
            }
            catch (ParseException e) {
                long longVal = Long.parseLong(strVal);
                return (T)new Date(longVal);
            }
        }
        throw new JSONException("parse error");
    }
}

