/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo;

import com.alibaba.nacos.client.naming.utils.StringUtils;
import java.util.Objects;

public abstract class AbstractHealthChecker
implements Cloneable {
    protected String type = "unknown";

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static class Mysql
    extends AbstractHealthChecker {
        public static final String TYPE = "MYSQL";
        private String user;
        private String pwd;
        private String cmd;

        public Mysql() {
            this.type = TYPE;
        }

        public String getCmd() {
            return this.cmd;
        }

        public String getPwd() {
            return this.pwd;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        public void setPwd(String pwd) {
            this.pwd = pwd;
        }

        public int hashCode() {
            return Objects.hash(this.user, this.pwd, this.cmd);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Mysql)) {
                return false;
            }
            Mysql other = (Mysql)obj;
            if (!StringUtils.equals(this.user, other.getUser())) {
                return false;
            }
            if (!StringUtils.equals(this.pwd, other.getPwd())) {
                return false;
            }
            return StringUtils.equals(this.cmd, other.getCmd());
        }
    }

    public static class Tcp
    extends AbstractHealthChecker {
        public static final String TYPE = "TCP";

        public Tcp() {
            this.type = TYPE;
        }

        public int hashCode() {
            return Objects.hash(TYPE);
        }

        public boolean equals(Object obj) {
            return obj instanceof Tcp;
        }
    }

    public static class Http
    extends AbstractHealthChecker {
        public static final String TYPE = "HTTP";
        private String path = "";
        private String headers = "";
        private int expectedResponseCode = 200;

        public Http() {
            this.type = TYPE;
        }

        public int getExpectedResponseCode() {
            return this.expectedResponseCode;
        }

        public void setExpectedResponseCode(int expectedResponseCode) {
            this.expectedResponseCode = expectedResponseCode;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getHeaders() {
            return this.headers;
        }

        public void setHeaders(String headers) {
            this.headers = headers;
        }

        public int hashCode() {
            return Objects.hash(this.path, this.headers, this.expectedResponseCode);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Http)) {
                return false;
            }
            Http other = (Http)obj;
            if (!StringUtils.equals(this.type, other.getType())) {
                return false;
            }
            if (!StringUtils.equals(this.path, other.getPath())) {
                return false;
            }
            if (!StringUtils.equals(this.headers, other.getHeaders())) {
                return false;
            }
            return this.expectedResponseCode == other.getExpectedResponseCode();
        }
    }
}

