/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.common.Constants;
import com.alibaba.nacos.client.config.common.GroupKey;
import com.alibaba.nacos.client.config.filter.impl.ConfigFilterChainManager;
import com.alibaba.nacos.client.config.impl.CacheData;
import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import com.alibaba.nacos.client.config.impl.LocalConfigInfoProcessor;
import com.alibaba.nacos.client.config.impl.ServerHttpAgent;
import com.alibaba.nacos.client.config.utils.ContentUtils;
import com.alibaba.nacos.client.config.utils.LogUtils;
import com.alibaba.nacos.client.config.utils.MD5;
import com.alibaba.nacos.client.config.utils.TenantUtil;
import com.alibaba.nacos.client.logger.Logger;
import com.alibaba.nacos.client.logger.support.LoggerHelper;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class ClientWorker {
    public static final Logger log = LogUtils.logger(ClientWorker.class);
    final ScheduledExecutorService executor;
    final ExecutorService executorService;
    AtomicReference<Map<String, CacheData>> cacheMap = new AtomicReference(new HashMap());
    ServerHttpAgent agent;
    ConfigFilterChainManager configFilterChainManager;
    private boolean isHealthServer = true;
    private double currentLongingTaskCount = 0.0;

    public void addListeners(String dataId, String group, List<? extends Listener> listeners) {
        group = this.null2defaultGroup(group);
        CacheData cache = this.addCacheDataIfAbsent(dataId, group);
        for (Listener listener : listeners) {
            cache.addListener(listener);
        }
    }

    public void removeListener(String dataId, String group, Listener listener) {
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group));
        if (null != cache) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(dataId, group);
            }
        }
    }

    public void addTenantListeners(String dataId, String group, List<? extends Listener> listeners) {
        group = this.null2defaultGroup(group);
        String tenant = this.agent.getTenant();
        CacheData cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        for (Listener listener : listeners) {
            cache.addListener(listener);
        }
    }

    public void removeTenantListener(String dataId, String group, Listener listener) {
        String tenant;
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group), tenant = this.agent.getTenant());
        if (null != cache) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(dataId, group, tenant);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    void removeCache(String dataId, String group) {
        String groupKey = GroupKey.getKey(dataId, group);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.remove(groupKey);
            this.cacheMap.set(copy);
        }
        log.info(this.agent.getName(), "[unsubscribe] {}", groupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    void removeCache(String dataId, String group, String tenant) {
        String groupKey = GroupKey.getKeyTenant(dataId, group, tenant);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.remove(groupKey);
            this.cacheMap.set(copy);
        }
        log.info(this.agent.getName(), "[unsubscribe] {}", groupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public CacheData addCacheDataIfAbsent(String dataId, String group) {
        CacheData cache = this.getCache(dataId, group);
        if (null != cache) {
            return cache;
        }
        String key = GroupKey.getKey(dataId, group);
        cache = new CacheData(this.configFilterChainManager, this.agent.getName(), dataId, group);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            CacheData cacheFromMap = this.getCache(dataId, group);
            if (null != cacheFromMap) {
                cache = cacheFromMap;
                cache.setInitializing(true);
            } else {
                int taskId = this.cacheMap.get().size() / (int)ParamUtil.getPerTaskConfigSize();
                cache.setTaskId(taskId);
            }
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
        }
        log.info(this.agent.getName(), "[subscribe] {}", key);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public CacheData addCacheDataIfAbsent(String dataId, String group, String tenant) {
        CacheData cache = this.getCache(dataId, group, tenant);
        if (null != cache) {
            return cache;
        }
        String key = GroupKey.getKeyTenant(dataId, group, tenant);
        cache = new CacheData(this.configFilterChainManager, this.agent.getName(), dataId, group, tenant);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            CacheData cacheFromMap = this.getCache(dataId, group, tenant);
            if (null != cacheFromMap) {
                cache = cacheFromMap;
                cache.setInitializing(true);
            }
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
        }
        log.info(this.agent.getName(), "[subscribe] {}", key);
        return cache;
    }

    public CacheData getCache(String dataId, String group) {
        return this.getCache(dataId, group, TenantUtil.getUserTenant());
    }

    public CacheData getCache(String dataId, String group, String tenant) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException();
        }
        return this.cacheMap.get().get(GroupKey.getKeyTenant(dataId, group, tenant));
    }

    public String getServerConfig(String dataId, String group, String tenant, long readTimeout) throws NacosException {
        if (StringUtils.isBlank(group)) {
            group = "DEFAULT_GROUP";
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            List<String> params = null;
            params = StringUtils.isBlank(tenant) ? Arrays.asList("dataId", dataId, "group", group) : Arrays.asList("dataId", dataId, "group", group, "tenant", tenant);
            result = this.agent.httpGet("/v1/cs/configs", null, params, this.agent.getEncode(), readTimeout);
        }
        catch (IOException e) {
            log.error(this.agent.getName(), "NACOS-XXXX", "[sub-server] get server config exception, dataId={}, group={}, tenant={}, msg={}", dataId, group, tenant, e.toString());
            throw new NacosException(500, e.getMessage());
        }
        switch (result.code) {
            case 200: {
                LocalConfigInfoProcessor.saveSnapshot(this.agent.getName(), dataId, group, tenant, result.content);
                return result.content;
            }
            case 404: {
                LocalConfigInfoProcessor.saveSnapshot(this.agent.getName(), dataId, group, tenant, null);
                return null;
            }
            case 409: {
                log.error(this.agent.getName(), "NACOS-XXXX", "[sub-server-error] get server config being modified concurrently, dataId={}, group={}, tenant={}", dataId, group, tenant);
                throw new NacosException(409, "data being modified, dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
            }
            case 403: {
                log.error(this.agent.getName(), "NACOS-XXXX", "[sub-server-error] no right, dataId={}, group={}, tenant={}", dataId, group, tenant);
                throw new NacosException(result.code, result.content);
            }
        }
        log.error(this.agent.getName(), "NACOS-XXXX", "[sub-server-error]  dataId={}, group={}, tenant={}, code={}", dataId, group, tenant, result.code);
        throw new NacosException(result.code, "http error, code=" + result.code + ",dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
    }

    private void checkLocalConfig(CacheData cacheData) {
        String dataId = cacheData.dataId;
        String group = cacheData.group;
        String tenant = cacheData.tenant;
        File path = LocalConfigInfoProcessor.getFailoverFile(this.agent.getName(), dataId, group, tenant);
        if (!cacheData.isUseLocalConfigInfo() && path.exists()) {
            String content = LocalConfigInfoProcessor.getFailover(this.agent.getName(), dataId, group, tenant);
            String md5 = MD5.getInstance().getMD5String(content);
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            log.warn(this.agent.getName(), "[failover-change] failover file created. dataId={}, group={}, tenant={}, md5={}, content={}", dataId, group, tenant, md5, ContentUtils.truncateContent(content));
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && !path.exists()) {
            cacheData.setUseLocalConfigInfo(false);
            log.warn(this.agent.getName(), "[failover-change] failover file deleted. dataId={}, group={}, tenant={}", dataId, group, tenant);
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && path.exists() && cacheData.getLocalConfigInfoVersion() != path.lastModified()) {
            String content = LocalConfigInfoProcessor.getFailover(this.agent.getName(), dataId, group, tenant);
            String md5 = MD5.getInstance().getMD5String(content);
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            log.warn(this.agent.getName(), "[failover-change] failover file changed. dataId={}, group={}, tenant={}, md5={}, content={}", dataId, group, tenant, md5, ContentUtils.truncateContent(content));
            return;
        }
    }

    private String null2defaultGroup(String group) {
        return null == group ? "DEFAULT_GROUP" : group.trim();
    }

    public void checkConfigInfo() {
        int listenerSize = this.cacheMap.get().size();
        int longingTaskCount = (int)Math.ceil((double)listenerSize / ParamUtil.getPerTaskConfigSize());
        if ((double)longingTaskCount > this.currentLongingTaskCount) {
            for (int i = (int)this.currentLongingTaskCount; i < longingTaskCount; ++i) {
                this.executorService.execute(new LongPullingRunnable(i));
            }
            this.currentLongingTaskCount = longingTaskCount;
        }
    }

    List<String> checkUpdateDataIds(List<CacheData> cacheDatas, List<String> inInitializingCacheList) {
        StringBuilder sb = new StringBuilder();
        for (CacheData cacheData : cacheDatas) {
            if (cacheData.isUseLocalConfigInfo()) continue;
            sb.append(cacheData.dataId).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.group).append(Constants.WORD_SEPARATOR);
            if (StringUtils.isBlank(cacheData.tenant)) {
                sb.append(cacheData.getMd5()).append(Constants.LINE_SEPARATOR);
            } else {
                sb.append(cacheData.getMd5()).append(Constants.WORD_SEPARATOR);
                sb.append(cacheData.getTenant()).append(Constants.LINE_SEPARATOR);
            }
            if (!cacheData.isInitializing()) continue;
            inInitializingCacheList.add(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.tenant));
        }
        boolean isInitializingCacheList = !inInitializingCacheList.isEmpty();
        return this.checkUpdateConfigStr(sb.toString(), isInitializingCacheList);
    }

    List<String> checkUpdateConfigStr(String probeUpdateString, boolean isInitializingCacheList) {
        List<String> params = Arrays.asList("Listening-Configs", probeUpdateString);
        long timeout = TimeUnit.SECONDS.toMillis(30L);
        ArrayList<String> headers = new ArrayList<String>(2);
        headers.add("Long-Pulling-Timeout");
        headers.add("" + timeout);
        if (isInitializingCacheList) {
            headers.add("Long-Pulling-Timeout-No-Hangup");
            headers.add("true");
        }
        if (StringUtils.isBlank(probeUpdateString)) {
            return Collections.emptyList();
        }
        try {
            HttpSimpleClient.HttpResult result = this.agent.httpPost("/v1/cs/configs/listener", headers, params, this.agent.getEncode(), timeout);
            if (200 == result.code) {
                this.setHealthServer(true);
                return this.parseUpdateDataIdResponse(result.content);
            }
            this.setHealthServer(false);
            if (result.code == 500) {
                log.error("NACOS-0007", LoggerHelper.getErrorCodeStr("Nacos", "Nacos-0007", "\u73af\u5883\u95ee\u9898", "[check-update] get changed dataId error"));
            }
            log.error(this.agent.getName(), "NACOS-XXXX", "[check-update] get changed dataId error, code={}", result.code);
        }
        catch (IOException e) {
            this.setHealthServer(false);
            log.error(this.agent.getName(), "NACOS-XXXX", "[check-update] get changed dataId exception, msg={}", e.toString());
        }
        return Collections.emptyList();
    }

    private List<String> parseUpdateDataIdResponse(String response) {
        if (StringUtils.isBlank(response)) {
            return Collections.emptyList();
        }
        try {
            response = URLDecoder.decode(response, "UTF-8");
        }
        catch (Exception e) {
            log.error(this.agent.getName(), "NACOS-XXXX", "[polling-resp] decode modifiedDataIdsString error", e);
        }
        LinkedList<String> updateList = new LinkedList<String>();
        for (String dataIdAndGroup : response.split(Constants.LINE_SEPARATOR)) {
            if (StringUtils.isBlank(dataIdAndGroup)) continue;
            String[] keyArr = dataIdAndGroup.split(Constants.WORD_SEPARATOR);
            String dataId = keyArr[0];
            String group = keyArr[1];
            if (keyArr.length == 2) {
                updateList.add(GroupKey.getKey(dataId, group));
                log.info(this.agent.getName(), "[polling-resp] config changed. dataId={}, group={}", dataId, group);
                continue;
            }
            if (keyArr.length == 3) {
                String tenant = keyArr[2];
                updateList.add(GroupKey.getKeyTenant(dataId, group, tenant));
                log.info(this.agent.getName(), "[polling-resp] config changed. dataId={}, group={}, tenant={}", dataId, group, tenant);
                continue;
            }
            log.error(this.agent.getName(), "NACOS-XXXX", "[polling-resp] invalid dataIdAndGroup error", dataIdAndGroup);
        }
        return updateList;
    }

    public ClientWorker(final ServerHttpAgent agent, ConfigFilterChainManager configFilterChainManager) {
        this.agent = agent;
        this.configFilterChainManager = configFilterChainManager;
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.nacos.client.Worker." + agent.getName());
                t.setDaemon(true);
                return t;
            }
        });
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.nacos.client.Worker.longPulling" + agent.getName());
                t.setDaemon(true);
                return t;
            }
        });
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientWorker.this.checkConfigInfo();
                }
                catch (Throwable e) {
                    log.error(agent.getName(), "NACOS-XXXX", "[sub-check] rotate check error", e);
                }
            }
        }, 1L, 10L, TimeUnit.MILLISECONDS);
    }

    public boolean isHealthServer() {
        return this.isHealthServer;
    }

    private void setHealthServer(boolean isHealthServer) {
        this.isHealthServer = isHealthServer;
    }

    class LongPullingRunnable
    implements Runnable {
        private int taskId;

        public LongPullingRunnable(int taskId) {
            this.taskId = taskId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ArrayList<CacheData> cacheDatas = new ArrayList<CacheData>();
                for (CacheData cacheData : ClientWorker.this.cacheMap.get().values()) {
                    if (cacheData.getTaskId() != this.taskId) continue;
                    cacheDatas.add(cacheData);
                    try {
                        ClientWorker.this.checkLocalConfig(cacheData);
                        if (!cacheData.isUseLocalConfigInfo()) continue;
                        cacheData.checkListenerMd5();
                    }
                    catch (Exception e) {
                        log.error("NACOS-CLIENT", "get local config info error", e);
                    }
                }
                ArrayList<String> inInitializingCacheList = new ArrayList<String>();
                List<String> changedGroupKeys = ClientWorker.this.checkUpdateDataIds(cacheDatas, inInitializingCacheList);
                for (String groupKey : changedGroupKeys) {
                    String[] key = GroupKey.parseKey(groupKey);
                    String dataId = key[0];
                    String group = key[1];
                    String tenant = null;
                    if (key.length == 3) {
                        tenant = key[2];
                    }
                    try {
                        String content = ClientWorker.this.getServerConfig(dataId, group, tenant, 3000L);
                        CacheData cache = ClientWorker.this.cacheMap.get().get(GroupKey.getKeyTenant(dataId, group, tenant));
                        cache.setContent(content);
                        log.info(ClientWorker.this.agent.getName(), "[data-received] dataId={}, group={}, tenant={}, md5={}, content={}", dataId, group, tenant, cache.getMd5(), ContentUtils.truncateContent(content));
                    }
                    catch (NacosException ioe) {
                        log.error(ClientWorker.this.agent.getName(), "NACOS-XXXX", "[get-update] get changed config exception. dataId={}, group={}, tenant={}, msg={}", dataId, group, tenant, ioe.toString());
                    }
                }
                for (CacheData cacheData : cacheDatas) {
                    if (cacheData.isInitializing() && !inInitializingCacheList.contains(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.tenant))) continue;
                    cacheData.checkListenerMd5();
                    cacheData.setInitializing(false);
                }
                inInitializingCacheList.clear();
            }
            catch (Throwable e) {
                log.error("500", "longPulling error", e);
            }
            finally {
                ClientWorker.this.executorService.execute(this);
            }
        }
    }
}

