/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.identify;

import com.alibaba.nacos.client.config.utils.LogUtils;
import com.alibaba.nacos.client.identify.CredentialListener;
import com.alibaba.nacos.client.identify.CredentialWatcher;
import com.alibaba.nacos.client.identify.Credentials;
import com.alibaba.nacos.client.identify.SpasCredentialLoader;
import com.alibaba.nacos.client.logger.Logger;
import com.alibaba.nacos.client.utils.StringUtils;
import java.util.concurrent.ConcurrentHashMap;

public final class CredentialService
implements SpasCredentialLoader {
    public static final Logger log = LogUtils.logger(CredentialService.class);
    private static ConcurrentHashMap<String, CredentialService> instances = new ConcurrentHashMap();
    private String appName;
    private Credentials credentials = new Credentials();
    private CredentialWatcher watcher;
    private CredentialListener listener;

    private CredentialService(String appName) {
        String value;
        if (appName == null && StringUtils.isNotEmpty(value = System.getProperty("project.name"))) {
            appName = value;
        }
        this.appName = appName;
        this.watcher = new CredentialWatcher(appName, this);
    }

    public static CredentialService getInstance() {
        return CredentialService.getInstance(null);
    }

    public static CredentialService getInstance(String appName) {
        CredentialService previous;
        String key = appName != null ? appName : "";
        CredentialService instance = instances.get(key);
        if (instance == null && (previous = instances.putIfAbsent(key, instance = new CredentialService(appName))) != null) {
            instance = previous;
        }
        return instance;
    }

    public static CredentialService freeInstance() {
        return CredentialService.freeInstance(null);
    }

    public static CredentialService freeInstance(String appName) {
        String key = appName != null ? appName : "";
        CredentialService instance = instances.remove(key);
        if (instance != null) {
            instance.free();
        }
        return instance;
    }

    public void free() {
        if (this.watcher != null) {
            this.watcher.stop();
        }
        log.info(this.appName, this.getClass().getSimpleName() + " is freed");
    }

    @Override
    public Credentials getCredential() {
        Credentials localCredential = this.credentials;
        if (localCredential.valid()) {
            return localCredential;
        }
        return this.credentials;
    }

    public void setCredential(Credentials credential) {
        boolean changed = this.credentials != credential && (this.credentials == null || !this.credentials.identical(credential));
        this.credentials = credential;
        if (changed && this.listener != null) {
            this.listener.onUpdateCredential();
        }
    }

    public void setStaticCredential(Credentials credential) {
        if (this.watcher != null) {
            this.watcher.stop();
        }
        this.setCredential(credential);
    }

    public void registerCredentialListener(CredentialListener listener) {
        this.listener = listener;
    }

    @Deprecated
    public void setAccessKey(String accessKey) {
        this.credentials.setAccessKey(accessKey);
    }

    @Deprecated
    public void setSecretKey(String secretKey) {
        this.credentials.setSecretKey(secretKey);
    }

    @Deprecated
    public String getAccessKey() {
        return this.credentials.getAccessKey();
    }

    @Deprecated
    public String getSecretKey() {
        return this.credentials.getSecretKey();
    }
}

