/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.Cluster;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.beat.BeatInfo;
import com.alibaba.nacos.client.naming.beat.BeatReactor;
import com.alibaba.nacos.client.naming.core.Balancer;
import com.alibaba.nacos.client.naming.core.Domain;
import com.alibaba.nacos.client.naming.core.EventDispatcher;
import com.alibaba.nacos.client.naming.core.HostReactor;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class NacosNamingService
implements NamingService {
    private String namespace;
    private String endpoint;
    private String serverList;
    private String cacheDir;
    private String logName;
    private HostReactor hostReactor;
    private BeatReactor beatReactor;
    private EventDispatcher eventDispatcher;
    private NamingProxy serverProxy;

    private void init() {
        this.namespace = System.getProperty("namespace");
        if (StringUtils.isEmpty(this.namespace)) {
            this.namespace = "default";
        }
        this.logName = System.getProperty("com.alibaba.nacos.naming.log.filename");
        if (StringUtils.isEmpty(this.logName)) {
            this.logName = "naming.log";
        }
        this.cacheDir = System.getProperty("com.alibaba.nacos.naming.cache.dir");
        if (StringUtils.isEmpty(this.cacheDir)) {
            this.cacheDir = System.getProperty("user.home") + "/nacos/naming/" + this.namespace;
        }
    }

    public NacosNamingService(String serverList) {
        this.serverList = serverList;
        this.init();
        this.eventDispatcher = new EventDispatcher();
        this.serverProxy = new NamingProxy(this.namespace, this.endpoint, serverList);
        this.beatReactor = new BeatReactor(this.serverProxy);
        this.hostReactor = new HostReactor(this.eventDispatcher, this.serverProxy, this.cacheDir);
    }

    public NacosNamingService(Properties properties) {
        this.init();
        this.serverList = properties.getProperty("serverAddr");
        if (StringUtils.isNotEmpty(properties.getProperty("namespace"))) {
            this.namespace = properties.getProperty("namespace");
        }
        if (StringUtils.isNotEmpty(properties.getProperty("com.alibaba.nacos.naming.log.filename"))) {
            this.logName = properties.getProperty("com.alibaba.nacos.naming.log.filename");
        }
        if (StringUtils.isNotEmpty(properties.getProperty("endpoint"))) {
            this.endpoint = properties.getProperty("endpoint") + ":" + properties.getProperty("address.server.port", "8080");
        }
        this.cacheDir = System.getProperty("user.home") + "/nacos/naming/" + this.namespace;
        this.eventDispatcher = new EventDispatcher();
        this.serverProxy = new NamingProxy(this.namespace, this.endpoint, this.serverList);
        this.beatReactor = new BeatReactor(this.serverProxy);
        this.hostReactor = new HostReactor(this.eventDispatcher, this.serverProxy, this.cacheDir);
    }

    @Override
    public void registerInstance(String serviceName, String ip, int port) throws NacosException {
        this.registerInstance(serviceName, ip, port, "");
    }

    @Override
    public void registerInstance(String serviceName, String ip, int port, String clusterName) throws NacosException {
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setWeight(1.0);
        instance.setCluster(new Cluster(clusterName));
        this.registerInstance(serviceName, instance);
    }

    @Override
    public void registerInstance(String serviceName, Instance instance) throws NacosException {
        BeatInfo beatInfo = new BeatInfo();
        beatInfo.setDom(serviceName);
        beatInfo.setIp(instance.getIp());
        beatInfo.setPort(instance.getPort());
        beatInfo.setCluster(instance.getCluster().getName());
        this.beatReactor.addBeatInfo(serviceName, beatInfo);
        this.serverProxy.registerService(serviceName, instance);
    }

    @Override
    public void deregisterInstance(String serviceName, String ip, int port) throws NacosException {
        this.deregisterInstance(serviceName, ip, port, "");
    }

    @Override
    public void deregisterInstance(String serviceName, String ip, int port, String clusterName) throws NacosException {
        this.beatReactor.removeBeatInfo(serviceName);
        this.serverProxy.deregisterService(serviceName, ip, port, clusterName);
    }

    @Override
    public List<Instance> getAllInstances(String serviceName) throws NacosException {
        return this.getAllInstances(serviceName, new ArrayList<String>());
    }

    @Override
    public List<Instance> getAllInstances(String serviceName, List<String> clusters) throws NacosException {
        List<Instance> list;
        Domain domain = this.hostReactor.getDom(serviceName, StringUtils.join(clusters, ","), "", false);
        if (domain == null || CollectionUtils.isEmpty(list = domain.getHosts())) {
            throw new IllegalStateException("no host to srv for dom: " + serviceName);
        }
        return list;
    }

    @Override
    public List<Instance> selectInstances(String serviceName, boolean healthyOnly) throws NacosException {
        return this.selectInstances(serviceName, new ArrayList<String>(), healthyOnly);
    }

    @Override
    public List<Instance> selectInstances(String serviceName, List<String> clusters, boolean healthy) throws NacosException {
        List<Instance> list;
        Domain domain = this.hostReactor.getDom(serviceName, StringUtils.join(clusters, ","), "", false);
        if (domain == null || CollectionUtils.isEmpty(list = domain.getHosts())) {
            throw new IllegalStateException("no host to srv for dom: " + serviceName);
        }
        if (healthy) {
            Iterator<Instance> iterator = list.iterator();
            while (iterator.hasNext()) {
                Instance instance = iterator.next();
                if (instance.isHealthy()) continue;
                iterator.remove();
            }
        } else {
            Iterator<Instance> iterator = list.iterator();
            while (iterator.hasNext()) {
                Instance instance = iterator.next();
                if (!instance.isHealthy()) continue;
                iterator.remove();
            }
        }
        return list;
    }

    @Override
    public Instance selectOneHealthyInstance(String serviceName) {
        return this.selectOneHealthyInstance(serviceName, new ArrayList<String>());
    }

    @Override
    public Instance selectOneHealthyInstance(String serviceName, List<String> clusters) {
        return Balancer.RandomByWeight.selectHost(this.hostReactor.getDom(serviceName, StringUtils.join(clusters, ",")));
    }

    @Override
    public void subscribe(String service, EventListener listener) {
        this.eventDispatcher.addListener(this.hostReactor.getDom(service, ""), "", listener);
    }

    @Override
    public void subscribe(String service, List<String> clusters, EventListener listener) {
        this.eventDispatcher.addListener(this.hostReactor.getDom(service, StringUtils.join(clusters, ",")), StringUtils.join(clusters, ","), listener);
    }

    @Override
    public void unsubscribe(String service, EventListener listener) {
        this.eventDispatcher.removeListener(service, "", listener);
    }

    @Override
    public void unsubscribe(String service, List<String> clusters, EventListener listener) {
        this.eventDispatcher.removeListener(service, StringUtils.join(clusters, ","), listener);
    }
}

