/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.backups;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.client.naming.cache.ConcurrentDiskUtil;
import com.alibaba.nacos.client.naming.cache.DiskCache;
import com.alibaba.nacos.client.naming.core.Domain;
import com.alibaba.nacos.client.naming.core.HostReactor;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.LogUtils;
import com.alibaba.nacos.client.naming.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class FailoverReactor {
    private String failoverDir;
    private HostReactor hostReactor;
    private Map<String, Domain> domainMap = new ConcurrentHashMap<String, Domain>();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("com.alibaba.nacos.naming.failover");
            return thread;
        }
    });
    private Map<String, String> switchParams = new ConcurrentHashMap<String, String>();
    private static final long DAY_PERIOD_MINUTES = 1440L;

    public FailoverReactor(HostReactor hostReactor, String cacheDir) {
        this.hostReactor = hostReactor;
        this.failoverDir = cacheDir + "/failover";
        this.init();
    }

    public void init() {
        this.executorService.scheduleWithFixedDelay(new SwitchRefresher(), 0L, 5000L, TimeUnit.MILLISECONDS);
        this.executorService.scheduleWithFixedDelay(new DiskFileWriter(), 30L, 1440L, TimeUnit.MINUTES);
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    File cacheDir = new File(FailoverReactor.this.failoverDir);
                    if (!cacheDir.exists() && !cacheDir.mkdirs()) {
                        throw new IllegalStateException("failed to create cache dir: " + FailoverReactor.this.failoverDir);
                    }
                    File[] files = cacheDir.listFiles();
                    if (files == null || files.length <= 0) {
                        new DiskFileWriter().run();
                    }
                }
                catch (Throwable e) {
                    LogUtils.LOG.error("NA", "failed to backup file on startup.", e);
                }
            }
        }, 10000L, TimeUnit.MILLISECONDS);
    }

    public Date addDay(Date date, int num) {
        Calendar startDT = Calendar.getInstance();
        startDT.setTime(date);
        startDT.add(5, num);
        return startDT.getTime();
    }

    public boolean isFailoverSwitch() {
        return Boolean.parseBoolean(this.switchParams.get("failover-mode"));
    }

    public Domain getDom(String key) {
        Domain domain = this.domainMap.get(key);
        if (domain == null) {
            domain = new Domain();
            domain.setName(key);
        }
        return domain;
    }

    class DiskFileWriter
    extends TimerTask {
        DiskFileWriter() {
        }

        @Override
        public void run() {
            Map<String, Domain> map = FailoverReactor.this.hostReactor.getDomMap();
            for (Map.Entry<String, Domain> entry : map.entrySet()) {
                Domain domain = entry.getValue();
                if (StringUtils.equals(domain.getKey(), "000--00-ALL_IPS--00--000") || StringUtils.equals(domain.getName(), "envList") || StringUtils.equals(domain.getName(), "00-00---000-ENV_CONFIGS-000---00-00") || StringUtils.equals(domain.getName(), "vipclient.properties") || StringUtils.equals(domain.getName(), "00-00---000-ALL_HOSTS-000---00-00")) continue;
                DiskCache.write(domain, FailoverReactor.this.failoverDir);
            }
        }
    }

    class FailoverFileReader
    implements Runnable {
        FailoverFileReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap<String, Domain> domMap = new HashMap<String, Domain>(16);
            BufferedReader reader = null;
            try {
                File cacheDir = new File(FailoverReactor.this.failoverDir);
                if (!cacheDir.exists() && !cacheDir.mkdirs()) {
                    throw new IllegalStateException("failed to create cache dir: " + FailoverReactor.this.failoverDir);
                }
                File[] files = cacheDir.listFiles();
                if (files == null) {
                    return;
                }
                for (File file : files) {
                    if (!file.isFile() || file.getName().equals("00-00---000-VIPSRV_FAILOVER_SWITCH-000---00-00")) continue;
                    Domain dom = new Domain(file.getName());
                    try {
                        String dataString = ConcurrentDiskUtil.getFileContent(file, Charset.defaultCharset().toString());
                        reader = new BufferedReader(new StringReader(dataString));
                        String json = reader.readLine();
                        if (json != null) {
                            try {
                                dom = (Domain)JSON.parseObject((String)json, Domain.class);
                            }
                            catch (Exception e) {
                                LogUtils.LOG.error("NA", "error while parsing cached dom : " + json, e);
                            }
                        }
                    }
                    catch (Exception e) {
                        LogUtils.LOG.error("NA", "failed to read cache for dom: " + file.getName(), e);
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (CollectionUtils.isEmpty(dom.getHosts())) continue;
                    domMap.put(dom.getKey(), dom);
                }
            }
            catch (Exception e) {
                LogUtils.LOG.error("NA", "failed to read cache file", e);
            }
            if (domMap.size() > 0) {
                FailoverReactor.this.domainMap = domMap;
            }
        }
    }

    class SwitchRefresher
    implements Runnable {
        long lastModifiedMillis = 0L;

        SwitchRefresher() {
        }

        @Override
        public void run() {
            try {
                File switchFile = new File(FailoverReactor.this.failoverDir + "00-00---000-VIPSRV_FAILOVER_SWITCH-000---00-00");
                if (!switchFile.exists()) {
                    FailoverReactor.this.switchParams.put("failover-mode", "false");
                    LogUtils.LOG.debug("failover switch is not found, " + switchFile.getName());
                    return;
                }
                long modified = switchFile.lastModified();
                if (this.lastModifiedMillis < modified) {
                    this.lastModifiedMillis = modified;
                    String failover = ConcurrentDiskUtil.getFileContent(FailoverReactor.this.failoverDir + "00-00---000-VIPSRV_FAILOVER_SWITCH-000---00-00", Charset.defaultCharset().toString());
                    if (!StringUtils.isEmpty(failover)) {
                        List<String> lines = Arrays.asList(failover.split(DiskCache.getLineSeperator()));
                        for (String line : lines) {
                            String line1 = line.trim();
                            if ("1".equals(line1)) {
                                FailoverReactor.this.switchParams.put("failover-mode", "true");
                                LogUtils.LOG.info("failover-mode is on");
                                new FailoverFileReader().run();
                                continue;
                            }
                            if (!"0".equals(line1)) continue;
                            FailoverReactor.this.switchParams.put("failover-mode", "false");
                            LogUtils.LOG.info("failover-mode is off");
                        }
                    } else {
                        FailoverReactor.this.switchParams.put("failover-mode", "false");
                    }
                }
            }
            catch (Throwable e) {
                LogUtils.LOG.error("NA", "failed to read failover switch.", e);
            }
        }
    }
}

