/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.core.Domain;
import com.alibaba.nacos.client.naming.utils.Chooser;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.LogUtils;
import com.alibaba.nacos.client.naming.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Balancer {
    public static final List<String> UNCONSISTENT_DOM_WITH_ADDRESS_SERVER = new CopyOnWriteArrayList<String>();

    protected static Instance getHostByRandomWeight(List<Instance> hosts) {
        LogUtils.LOG.debug("entry randomWithWeight");
        if (hosts == null || hosts.size() == 0) {
            LogUtils.LOG.debug("hosts == null || hosts.size() == 0");
            return null;
        }
        Chooser vipChooser = new Chooser("www.taobao.com");
        LogUtils.LOG.debug("new Chooser");
        ArrayList hostsWithWeight = new ArrayList();
        for (Instance host : hosts) {
            if (!host.isHealthy()) continue;
            hostsWithWeight.add(new Pair<Instance>(host, host.getWeight()));
        }
        LogUtils.LOG.debug("for (Host host : hosts)");
        vipChooser.refresh(hostsWithWeight);
        LogUtils.LOG.debug("vipChooser.refresh");
        Instance host = (Instance)vipChooser.randomWithWeight();
        return host;
    }

    public static class RandomByWeight {
        public static List<Instance> selectAll(Domain dom) {
            List<Instance> hosts = RandomByWeight.nothing(dom);
            if (CollectionUtils.isEmpty(hosts)) {
                throw new IllegalStateException("no host to srv for dom: " + dom.getName());
            }
            return hosts;
        }

        public static Instance selectHost(Domain dom) {
            List<Instance> hosts = RandomByWeight.selectAll(dom);
            if (CollectionUtils.isEmpty(hosts)) {
                throw new IllegalStateException("no host to srv for dom: " + dom.getName());
            }
            return Balancer.getHostByRandomWeight(hosts);
        }

        public static List<Instance> nothing(Domain dom) {
            return dom.getHosts();
        }
    }
}

