/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class Domain {
    @JSONField(serialize=false)
    private String jsonFromServer = "";
    public static final String SPLITER = "@@";
    @JSONField(name="dom")
    private String name;
    private String clusters;
    private long cacheMillis = 1000L;
    @JSONField(name="hosts")
    private List<Instance> hosts = new ArrayList<Instance>();
    private long lastRefTime = 0L;
    private String checksum = "";
    private String env = "";
    private volatile boolean allIPs = false;

    public Domain() {
    }

    public boolean isAllIPs() {
        return this.allIPs;
    }

    public void setAllIPs(boolean allIPs) {
        this.allIPs = allIPs;
    }

    public Domain(String key) {
        int maxKeySectionCount = 4;
        int allIpFlagIndex = 3;
        int envIndex = 2;
        int clusterIndex = 1;
        int domNameIndex = 0;
        String[] keys = key.split(SPLITER);
        if (keys.length >= maxKeySectionCount) {
            this.name = keys[domNameIndex];
            this.clusters = keys[clusterIndex];
            this.env = keys[envIndex];
            if (StringUtils.equals(keys[allIpFlagIndex], "000--00-ALL_IPS--00--000")) {
                this.setAllIPs(true);
            }
        } else if (keys.length >= allIpFlagIndex) {
            this.name = keys[domNameIndex];
            this.clusters = keys[clusterIndex];
            if (StringUtils.equals(keys[envIndex], "000--00-ALL_IPS--00--000")) {
                this.setAllIPs(true);
            } else {
                this.env = keys[envIndex];
            }
        } else if (keys.length >= envIndex) {
            this.name = keys[domNameIndex];
            if (StringUtils.equals(keys[clusterIndex], "000--00-ALL_IPS--00--000")) {
                this.setAllIPs(true);
            } else {
                this.clusters = keys[clusterIndex];
            }
        }
        this.name = keys[0];
    }

    public Domain(String name, String clusters) {
        this(name, clusters, "");
    }

    public Domain(String name, String clusters, String env) {
        this.name = name;
        this.clusters = clusters;
        this.env = env;
    }

    public int ipCount() {
        return this.hosts.size();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.lastRefTime > this.cacheMillis;
    }

    public void setHosts(List<Instance> hosts) {
        this.hosts = hosts;
    }

    public boolean isValid() {
        return this.hosts != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastRefTime(long lastRefTime) {
        this.lastRefTime = lastRefTime;
    }

    public long getLastRefTime() {
        return this.lastRefTime;
    }

    public String getClusters() {
        return this.clusters;
    }

    public void setClusters(String clusters) {
        this.clusters = clusters;
    }

    public long getCacheMillis() {
        return this.cacheMillis;
    }

    public void setCacheMillis(long cacheMillis) {
        this.cacheMillis = cacheMillis;
    }

    public List<Instance> getHosts() {
        return new ArrayList<Instance>(this.hosts);
    }

    public boolean validate() {
        if (this.isAllIPs()) {
            return true;
        }
        if (CollectionUtils.isEmpty(this.hosts)) {
            return false;
        }
        ArrayList<Instance> validHosts = new ArrayList<Instance>();
        for (Instance host : this.hosts) {
            if (!host.isHealthy()) continue;
            int i = 0;
            while ((double)i < host.getWeight()) {
                validHosts.add(host);
                ++i;
            }
        }
        return !CollectionUtils.isEmpty(validHosts);
    }

    @JSONField(serialize=false)
    public String getJsonFromServer() {
        return this.jsonFromServer;
    }

    public void setJsonFromServer(String jsonFromServer) {
        this.jsonFromServer = jsonFromServer;
    }

    @JSONField(serialize=false)
    public String getKey() {
        return Domain.getKey(this.name, this.clusters, this.env, this.isAllIPs());
    }

    @JSONField(serialize=false)
    public static String getKey(String name, String clusters, String unit) {
        return Domain.getKey(name, clusters, unit, false);
    }

    @JSONField(serialize=false)
    public static String getKey(String name, String clusters, String unit, boolean isAllIPs) {
        if (StringUtils.isEmpty(unit)) {
            unit = "";
        }
        if (!StringUtils.isEmpty(clusters) && !StringUtils.isEmpty(unit)) {
            return isAllIPs ? name + SPLITER + clusters + SPLITER + unit + SPLITER + "000--00-ALL_IPS--00--000" : name + SPLITER + clusters + SPLITER + unit;
        }
        if (!StringUtils.isEmpty(clusters)) {
            return isAllIPs ? name + SPLITER + clusters + SPLITER + "000--00-ALL_IPS--00--000" : name + SPLITER + clusters;
        }
        if (!StringUtils.isEmpty(unit)) {
            return isAllIPs ? name + SPLITER + "" + SPLITER + unit + SPLITER + "000--00-ALL_IPS--00--000" : name + SPLITER + "" + SPLITER + unit;
        }
        return isAllIPs ? name + SPLITER + "000--00-ALL_IPS--00--000" : name;
    }

    public String toString() {
        return this.getKey();
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }
}

