/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.core.Domain;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class EventDispatcher {
    private ExecutorService executor = null;
    private BlockingQueue<Domain> changedDoms = new LinkedBlockingQueue<Domain>();
    private ConcurrentMap<String, List<EventListener>> observerMap = new ConcurrentHashMap<String, List<EventListener>>();

    public EventDispatcher() {
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "com.alibaba.nacos.naming.client.listener");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.executor.execute(new Notifier());
    }

    public void addListener(Domain dom, String clusters, EventListener listener) {
        this.addListener(dom, clusters, "", listener);
    }

    public void addListener(Domain dom, String clusters, String env, EventListener listener) {
        List<EventListener> observers = Collections.synchronizedList(new ArrayList());
        observers.add(listener);
        observers = this.observerMap.putIfAbsent(Domain.getKey(dom.getName(), clusters, env), observers);
        if (observers != null) {
            observers.add(listener);
        }
        this.domChanged(dom);
    }

    public void removeListener(String dom, String clusters, EventListener listener) {
        String unit = "";
        List observers = (List)this.observerMap.get(Domain.getKey(dom, clusters, unit));
        if (observers != null) {
            Iterator iter = observers.iterator();
            while (iter.hasNext()) {
                EventListener oldListener = (EventListener)iter.next();
                if (!oldListener.equals(listener)) continue;
                iter.remove();
            }
        }
    }

    public void domChanged(Domain dom) {
        if (dom == null) {
            return;
        }
        this.changedDoms.add(dom);
    }

    public void setExecutor(ExecutorService executor) {
        ExecutorService oldExecutor = this.executor;
        this.executor = executor;
        oldExecutor.shutdown();
    }

    private class Notifier
    implements Runnable {
        private Notifier() {
        }

        @Override
        public void run() {
            block4: while (true) {
                Domain dom = null;
                try {
                    dom = (Domain)EventDispatcher.this.changedDoms.poll(5L, TimeUnit.MINUTES);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dom == null) continue;
                try {
                    List listeners = (List)EventDispatcher.this.observerMap.get(dom.getKey());
                    if (CollectionUtils.isEmpty(listeners)) continue;
                    Iterator iterator = listeners.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block4;
                        EventListener listener = (EventListener)iterator.next();
                        List<Instance> hosts = Collections.unmodifiableList(dom.getHosts());
                        if (CollectionUtils.isEmpty(hosts)) continue;
                        listener.onEvent(new NamingEvent(dom.getName(), hosts));
                    }
                }
                catch (Exception e) {
                    LogUtils.LOG.error("NA", "notify error for dom: " + dom.getName() + ", clusters: " + dom.getClusters(), e);
                    continue;
                }
                break;
            }
        }
    }
}

