/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.backups.FailoverReactor;
import com.alibaba.nacos.client.naming.cache.DiskCache;
import com.alibaba.nacos.client.naming.core.Balancer;
import com.alibaba.nacos.client.naming.core.Domain;
import com.alibaba.nacos.client.naming.core.EventDispatcher;
import com.alibaba.nacos.client.naming.core.PushRecver;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.LogUtils;
import com.alibaba.nacos.client.naming.utils.NetUtils;
import com.alibaba.nacos.client.naming.utils.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class HostReactor {
    public static final long DEFAULT_DELAY = 1000L;
    public long updateHoldInterval = 5000L;
    private final Map<String, ScheduledFuture<?>> futureMap = new HashMap();
    private Map<String, Domain> domMap;
    private PushRecver pushRecver;
    private EventDispatcher eventDispatcher;
    private NamingProxy serverProxy;
    private FailoverReactor failoverReactor;
    private String cacheDir;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "com.vipserver.client.updater");
            thread.setDaemon(true);
            return thread;
        }
    });

    public HostReactor(EventDispatcher eventDispatcher, NamingProxy serverProxy, String cacheDir) {
        this.eventDispatcher = eventDispatcher;
        this.serverProxy = serverProxy;
        this.cacheDir = cacheDir;
        this.domMap = new ConcurrentHashMap<String, Domain>(DiskCache.read(this.cacheDir));
        this.failoverReactor = new FailoverReactor(this, cacheDir);
        this.pushRecver = new PushRecver(this);
    }

    public Map<String, Domain> getDomMap() {
        return this.domMap;
    }

    public synchronized ScheduledFuture<?> addTask(UpdateTask task) {
        return this.executor.schedule(task, 1000L, TimeUnit.MILLISECONDS);
    }

    public Domain processDomJSON(String json) {
        Domain domObj = (Domain)JSON.parseObject((String)json, Domain.class);
        Domain oldDom = this.domMap.get(domObj.getKey());
        if (domObj.getHosts() == null || !domObj.validate()) {
            return oldDom;
        }
        if (oldDom != null) {
            String key;
            Instance host;
            if (oldDom.getLastRefTime() > domObj.getLastRefTime()) {
                LogUtils.LOG.warn("out of date data received, old-t: " + oldDom.getLastRefTime() + ", new-t: " + domObj.getLastRefTime());
            }
            this.domMap.put(domObj.getKey(), domObj);
            HashMap<String, Instance> oldHostMap = new HashMap<String, Instance>(oldDom.getHosts().size());
            for (Instance instance : oldDom.getHosts()) {
                oldHostMap.put(instance.toInetAddr(), instance);
            }
            HashMap<String, Instance> newHostMap = new HashMap<String, Instance>(domObj.getHosts().size());
            for (Instance host3 : domObj.getHosts()) {
                newHostMap.put(host3.toInetAddr(), host3);
            }
            HashSet<Instance> hashSet = new HashSet<Instance>();
            HashSet<Instance> newHosts = new HashSet<Instance>();
            HashSet<Instance> remvHosts = new HashSet<Instance>();
            ArrayList newDomHosts = new ArrayList(newHostMap.entrySet());
            for (Map.Entry entry : newDomHosts) {
                host = (Instance)entry.getValue();
                key = (String)entry.getKey();
                if (oldHostMap.containsKey(key) && !StringUtils.equals(host.toString(), ((Instance)oldHostMap.get(key)).toString())) {
                    hashSet.add(host);
                    continue;
                }
                if (oldHostMap.containsKey(key)) continue;
                newHosts.add(host);
            }
            for (Map.Entry entry : oldHostMap.entrySet()) {
                host = (Instance)entry.getValue();
                key = (String)entry.getKey();
                if (newHostMap.containsKey(key) || newHostMap.containsKey(key)) continue;
                remvHosts.add(host);
            }
            if (newHosts.size() > 0) {
                LogUtils.LOG.info("new ips(" + newHosts.size() + ") dom: " + domObj.getName() + " -> " + JSON.toJSONString(newHosts));
            }
            if (remvHosts.size() > 0) {
                LogUtils.LOG.info("removed ips(" + remvHosts.size() + ") dom: " + domObj.getName() + " -> " + JSON.toJSONString(remvHosts));
            }
            if (hashSet.size() > 0) {
                LogUtils.LOG.info("modified ips(" + hashSet.size() + ") dom: " + domObj.getName() + " -> " + JSON.toJSONString(hashSet));
            }
            domObj.setJsonFromServer(json);
            if (newHosts.size() > 0 || remvHosts.size() > 0 || hashSet.size() > 0) {
                this.eventDispatcher.domChanged(domObj);
                DiskCache.write(domObj, this.cacheDir);
            }
        } else {
            LogUtils.LOG.info("new ips(" + domObj.ipCount() + ") dom: " + domObj.getName() + " -> " + JSON.toJSONString(domObj.getHosts()));
            this.domMap.put(domObj.getKey(), domObj);
            this.eventDispatcher.domChanged(domObj);
            domObj.setJsonFromServer(json);
            DiskCache.write(domObj, this.cacheDir);
        }
        LogUtils.LOG.info("current ips:(" + domObj.ipCount() + ") dom: " + domObj.getName() + " -> " + JSON.toJSONString(domObj.getHosts()));
        return domObj;
    }

    private Domain getDom0(String dom, String clusters, String env) {
        String key = Domain.getKey(dom, clusters, env, false);
        return this.domMap.get(key);
    }

    private Domain getDom0(String dom, String clusters, String env, boolean allIPs) {
        String key = Domain.getKey(dom, clusters, env, allIPs);
        return this.domMap.get(key);
    }

    public Domain getDom(String dom, String clusters, String env) {
        return this.getDom(dom, clusters, env, false);
    }

    public Domain getDom(String dom, String clusters) {
        String env = "";
        return this.getDom(dom, clusters, env, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain getDom(String dom, String clusters, String env, boolean allIPs) {
        LogUtils.LOG.debug("failover-mode: " + this.failoverReactor.isFailoverSwitch());
        String key = Domain.getKey(dom, clusters, env, allIPs);
        if (this.failoverReactor.isFailoverSwitch()) {
            return this.failoverReactor.getDom(key);
        }
        Domain domObj = this.getDom0(dom, clusters, env, allIPs);
        if (null == domObj) {
            domObj = new Domain(dom, clusters, env);
            if (allIPs) {
                domObj.setAllIPs(allIPs);
            }
            this.domMap.put(domObj.getKey(), domObj);
            if (allIPs) {
                this.updateDom4AllIPNow(dom, clusters, env);
            } else {
                this.updateDomNow(dom, clusters, env);
            }
        } else if (domObj.getHosts().isEmpty() && this.updateHoldInterval > 0L) {
            Domain domain = domObj;
            synchronized (domain) {
                try {
                    domObj.wait(this.updateHoldInterval);
                }
                catch (InterruptedException e) {
                    LogUtils.LOG.error("[getDom]", "dom:" + dom + ", clusters:" + clusters + ", allIPs:" + allIPs, e);
                }
            }
        }
        this.scheduleUpdateIfAbsent(dom, clusters, env, allIPs);
        return this.domMap.get(domObj.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleUpdateIfAbsent(String dom, String clusters, String env, boolean allIPs) {
        if (this.futureMap.get(Domain.getKey(dom, clusters, env, allIPs)) != null) {
            return;
        }
        Map<String, ScheduledFuture<?>> map = this.futureMap;
        synchronized (map) {
            if (this.futureMap.get(Domain.getKey(dom, clusters, env, allIPs)) != null) {
                return;
            }
            ScheduledFuture<?> future = this.addTask(new UpdateTask(dom, clusters, env, allIPs));
            this.futureMap.put(Domain.getKey(dom, clusters, env, allIPs), future);
        }
    }

    public void updateDom4AllIPNow(String dom, String clusters, String env) {
        this.updateDom4AllIPNow(dom, clusters, env, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void updateDom4AllIPNow(String dom, String clusters, String env, long timeout) {
        block7: {
            try {
                String result;
                HashMap<String, String> params = new HashMap<String, String>(8);
                params.put("dom", dom);
                params.put("clusters", clusters);
                params.put("udpPort", String.valueOf(this.pushRecver.getUDPPort()));
                Domain oldDom = this.getDom0(dom, clusters, env, true);
                if (oldDom != null) {
                    params.put("checksum", oldDom.getChecksum());
                }
                if (StringUtils.isNotEmpty(result = this.serverProxy.reqAPI("/nacos/v1/ns/api/srvAllIP", params))) {
                    Domain domain = this.processDomJSON(result);
                    domain.setAllIPs(true);
                }
                if (oldDom == null) break block7;
                Domain domain = oldDom;
                synchronized (domain) {
                    oldDom.notifyAll();
                }
            }
            catch (Exception e) {
                LogUtils.LOG.error("NA", "failed to update dom: " + dom, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void updateDomNow(String dom, String clusters, String env) {
        Domain oldDom = this.getDom0(dom, clusters, env);
        try {
            String result;
            HashMap<String, String> params = new HashMap<String, String>(8);
            params.put("dom", dom);
            params.put("clusters", clusters);
            params.put("udpPort", String.valueOf(this.pushRecver.getUDPPort()));
            params.put("env", env);
            params.put("clientIP", NetUtils.localIP());
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : Balancer.UNCONSISTENT_DOM_WITH_ADDRESS_SERVER) {
                stringBuilder.append(string).append(",");
            }
            Balancer.UNCONSISTENT_DOM_WITH_ADDRESS_SERVER.clear();
            params.put("unconsistentDom", stringBuilder.toString());
            String envSpliter = ",";
            if (!StringUtils.isEmpty(env) && !env.contains(envSpliter)) {
                params.put("useEnvId", "true");
            }
            if (oldDom != null) {
                params.put("checksum", oldDom.getChecksum());
            }
            if (StringUtils.isNotEmpty(result = this.serverProxy.reqAPI("/nacos/v1/ns/api/srvIPXT", params))) {
                this.processDomJSON(result);
            }
        }
        catch (Exception e) {
            LogUtils.LOG.error("NA", "failed to update dom: " + dom, e);
        }
        finally {
            if (oldDom != null) {
                Domain domain = oldDom;
                synchronized (domain) {
                    oldDom.notifyAll();
                }
            }
        }
    }

    public void refreshOnly(String dom, String clusters, String env, boolean allIPs) {
        try {
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("dom", dom);
            params.put("clusters", clusters);
            params.put("udpPort", String.valueOf(this.pushRecver.getUDPPort()));
            params.put("unit", env);
            params.put("clientIP", NetUtils.localIP());
            String domSpliter = ",";
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : Balancer.UNCONSISTENT_DOM_WITH_ADDRESS_SERVER) {
                stringBuilder.append(string).append(domSpliter);
            }
            Balancer.UNCONSISTENT_DOM_WITH_ADDRESS_SERVER.clear();
            params.put("unconsistentDom", stringBuilder.toString());
            String envSpliter = ",";
            if (!env.contains(envSpliter)) {
                params.put("useEnvId", "true");
            }
            if (allIPs) {
                this.serverProxy.reqAPI("/nacos/v1/ns/api/srvAllIP", params);
            } else {
                this.serverProxy.reqAPI("/nacos/v1/ns/api/srvIPXT", params);
            }
        }
        catch (Exception e) {
            LogUtils.LOG.error("NA", "failed to update dom: " + dom, e);
        }
    }

    public class UpdateTask
    implements Runnable {
        long lastRefTime = Long.MAX_VALUE;
        private String clusters;
        private String dom;
        private String env;
        private boolean allIPs = false;

        public UpdateTask(String dom, String clusters, String env) {
            this.dom = dom;
            this.clusters = clusters;
            this.env = env;
        }

        public UpdateTask(String dom, String clusters, String env, boolean allIPs) {
            this.dom = dom;
            this.clusters = clusters;
            this.env = env;
            this.allIPs = allIPs;
        }

        @Override
        public void run() {
            try {
                Domain domObj = (Domain)HostReactor.this.domMap.get(Domain.getKey(this.dom, this.clusters, this.env, this.allIPs));
                if (domObj == null) {
                    if (this.allIPs) {
                        HostReactor.this.updateDom4AllIPNow(this.dom, this.clusters, this.env);
                    } else {
                        HostReactor.this.updateDomNow(this.dom, this.clusters, this.env);
                        HostReactor.this.executor.schedule(this, 1000L, TimeUnit.MILLISECONDS);
                    }
                    return;
                }
                if (domObj.getLastRefTime() <= this.lastRefTime) {
                    if (this.allIPs) {
                        HostReactor.this.updateDom4AllIPNow(this.dom, this.clusters, this.env);
                        domObj = (Domain)HostReactor.this.domMap.get(Domain.getKey(this.dom, this.clusters, this.env, true));
                    } else {
                        HostReactor.this.updateDomNow(this.dom, this.clusters, this.env);
                        domObj = (Domain)HostReactor.this.domMap.get(Domain.getKey(this.dom, this.clusters, this.env));
                    }
                } else {
                    HostReactor.this.refreshOnly(this.dom, this.clusters, this.env, this.allIPs);
                }
                HostReactor.this.executor.schedule(this, domObj.getCacheMillis(), TimeUnit.MILLISECONDS);
                this.lastRefTime = domObj.getLastRefTime();
            }
            catch (Throwable e) {
                LogUtils.LOG.warn("NA", "failed to update dom: " + this.dom, e);
            }
        }
    }
}

