/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.net;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.net.HttpClient;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.IoUtils;
import com.alibaba.nacos.client.naming.utils.LogUtils;
import com.alibaba.nacos.client.naming.utils.StringUtils;
import com.alibaba.nacos.common.util.UuidUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NamingProxy {
    private String namespace;
    private String endpoint;
    private String nacosDomain;
    private List<String> serverList;
    private List<String> serversFromEndpoint = new ArrayList<String>();
    private long lastSrvRefTime = 0L;
    private long vipSrvRefInterMillis = TimeUnit.SECONDS.toMillis(30L);
    private ScheduledExecutorService executorService;

    public NamingProxy(String namespace, String endpoint, String serverList) {
        this.namespace = namespace;
        this.endpoint = endpoint;
        if (StringUtils.isNotEmpty(serverList)) {
            this.serverList = Arrays.asList(serverList.split(","));
            if (this.serverList.size() == 1) {
                this.nacosDomain = serverList;
            }
        }
        this.executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.taobao.vipserver.serverlist.updater");
                t.setDaemon(true);
                return t;
            }
        });
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                NamingProxy.this.refreshSrvIfNeed();
            }
        }, 0L, this.vipSrvRefInterMillis, TimeUnit.MILLISECONDS);
        this.refreshSrvIfNeed();
    }

    public List<String> getServerListFromEndpoint() {
        try {
            String urlString = "http://" + this.endpoint + "/vipserver/serverlist";
            List<String> headers = Arrays.asList("Client-Version", "Nacos-Client-0.1", "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive", "RequestId", UuidUtil.generateUuid());
            HttpClient.HttpResult result = HttpClient.httpGet(urlString, headers, null, "UTF-8");
            if (200 != result.code) {
                throw new IOException("Error while requesting: " + urlString + "'. Server returned: " + result.code);
            }
            String content = result.content;
            ArrayList<String> list = new ArrayList<String>();
            for (String line : IoUtils.readLines(new StringReader(content))) {
                if (line.trim().isEmpty()) continue;
                list.add(line.trim());
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void refreshSrvIfNeed() {
        try {
            if (!CollectionUtils.isEmpty(this.serverList)) {
                LogUtils.LOG.info("server list provided by user: " + this.serverList);
                return;
            }
            if (System.currentTimeMillis() - this.lastSrvRefTime < this.vipSrvRefInterMillis) {
                return;
            }
            List<String> list = this.getServerListFromEndpoint();
            if (list.isEmpty()) {
                throw new Exception("Can not acquire vipserver list");
            }
            if (!CollectionUtils.isEqualCollection(list, this.serversFromEndpoint)) {
                LogUtils.LOG.info("SERVER-LIST", "server list is updated: " + list);
            }
            this.serversFromEndpoint = list;
            this.lastSrvRefTime = System.currentTimeMillis();
        }
        catch (Throwable e) {
            LogUtils.LOG.warn("failed to update server list", e);
        }
    }

    public void regDom(String dom, String ip, int port, double weight, String cluster) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("dom", dom);
        params.put("ip", ip);
        params.put("port", String.valueOf(port));
        params.put("weight", String.valueOf(weight));
        params.put("cluster", cluster);
        try {
            this.doRegDom(params);
        }
        catch (Exception e) {
            try {
                Thread.sleep(1000L);
                this.doRegDom(params);
            }
            catch (Exception e1) {
                throw new NacosException(500, e.getMessage());
            }
        }
    }

    public void registerService(String serviceName, Instance instance) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("tenant", this.namespace);
        params.put("ip", instance.getIp());
        params.put("port", String.valueOf(instance.getPort()));
        params.put("weight", String.valueOf(instance.getWeight()));
        params.put("healthy", String.valueOf(instance.isHealthy()));
        params.put("metadata", JSON.toJSONString(instance.getMetadata()));
        if (instance.getService() == null) {
            params.put("serviceName", serviceName);
        } else {
            params.put("service", JSON.toJSONString((Object)instance.getService()));
        }
        params.put("cluster", JSON.toJSONString((Object)instance.getCluster()));
        this.reqAPI("/nacos/v1/ns/instance", params, "PUT");
    }

    public void deregisterService(String serviceName, String ip, int port, String cluster) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("tenant", this.namespace);
        params.put("ip", ip);
        params.put("port", String.valueOf(port));
        params.put("serviceName", serviceName);
        params.put("cluster", cluster);
        this.reqAPI("/nacos/v1/ns/instance", params, "DELETE");
    }

    public String queryList(String serviceName, String clusters, boolean healthyOnly) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("tenant", this.namespace);
        params.put("serviceName", serviceName);
        params.put("clusters", clusters);
        params.put("healthyOnly", String.valueOf(healthyOnly));
        return this.reqAPI("/nacos/v1/ns/instances", params, "GET");
    }

    private String doRegDom(Map<String, String> params) throws Exception {
        String api = "/nacos/v1/ns/api/regService";
        return this.reqAPI(api, params);
    }

    public void deRegDom(String dom, String ip, int port, String cluster) throws NacosException {
        String api = "/nacos/v1/ns/api/deRegService";
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("ip", ip);
        params.put("port", String.valueOf(port));
        params.put("cluster", cluster);
        params.put("dom", dom);
        params.put("tenant", this.namespace);
        try {
            this.reqAPI(api, params);
        }
        catch (Exception e) {
            LogUtils.LOG.error("NA", "faild to deRegDom: " + JSON.toJSONString(params), e);
        }
    }

    public String callAllServers(String api, Map<String, String> params) throws NacosException {
        String result = "";
        List<String> snapshot = this.serversFromEndpoint;
        if (!CollectionUtils.isEmpty(this.serverList)) {
            snapshot = this.serverList;
        }
        try {
            result = this.reqAPI(api, params, snapshot);
        }
        catch (Exception e) {
            LogUtils.LOG.error("NA", "req api:" + api + " failed, servers: " + snapshot, e);
        }
        if (StringUtils.isNotEmpty(result)) {
            return result;
        }
        throw new IllegalStateException("failed to req API:/api/" + api + " after all sites(" + snapshot + ") tried");
    }

    public String reqAPI(String api, Map<String, String> params) throws NacosException {
        List<String> snapshot = this.serversFromEndpoint;
        if (!CollectionUtils.isEmpty(this.serverList)) {
            snapshot = this.serverList;
        }
        return this.reqAPI(api, params, snapshot);
    }

    public String reqAPI(String api, Map<String, String> params, String method) throws NacosException {
        List<String> snapshot = this.serversFromEndpoint;
        if (!CollectionUtils.isEmpty(this.serverList)) {
            snapshot = this.serverList;
        }
        return this.reqAPI(api, params, snapshot, method);
    }

    public String callServer(String api, Map<String, String> params, String curServer) throws NacosException {
        return this.callServer(api, params, curServer, "GET");
    }

    public String callServer(String api, Map<String, String> params, String curServer, String method) throws NacosException {
        List<String> headers = Arrays.asList("Client-Version", "Nacos-Client-0.1", "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive", "RequestId", UuidUtil.generateUuid());
        String url = HttpClient.getPrefix() + curServer + api;
        HttpClient.HttpResult result = HttpClient.request(url, headers, params, "UTF-8", method);
        if (200 == result.code) {
            return result.content;
        }
        if (304 == result.code) {
            return "";
        }
        LogUtils.LOG.error("CALL-SERVER", "failed to req API:" + HttpClient.getPrefix() + curServer + api + ". code:" + result.code + " msg: " + result.content);
        throw new NacosException(500, "failed to req API:" + HttpClient.getPrefix() + curServer + api + ". code:" + result.code + " msg: " + result.content);
    }

    public String reqAPI(String api, Map<String, String> params, List<String> servers) {
        return this.reqAPI(api, params, servers, "GET");
    }

    public String reqAPI(String api, Map<String, String> params, List<String> servers, String method) {
        if (CollectionUtils.isEmpty(servers) && StringUtils.isEmpty(this.nacosDomain)) {
            throw new IllegalArgumentException("no server available");
        }
        if (servers != null && !servers.isEmpty()) {
            Random random = new Random(System.currentTimeMillis());
            int index = random.nextInt(servers.size());
            for (int i = 0; i < servers.size(); ++i) {
                String server = servers.get(index);
                try {
                    return this.callServer(api, params, server, method);
                }
                catch (Exception e) {
                    LogUtils.LOG.error("NA", "req api:" + api + " failed, server(" + server, e);
                    index = (index + 1) % servers.size();
                    continue;
                }
            }
            throw new IllegalStateException("failed to req API:" + api + " after all servers(" + servers + ") tried");
        }
        for (int i = 0; i < 3; ++i) {
            try {
                return this.callServer(api, params, this.nacosDomain);
            }
            catch (Exception e) {
                LogUtils.LOG.error("NA", "req api:" + api + " failed, server(" + this.nacosDomain, e);
                continue;
            }
        }
        throw new IllegalStateException("failed to req API:/api/" + api + " after all servers(" + servers + ") tried");
    }
}

