/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.method;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheInvokeException;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.RefreshCache;
import com.alicp.jetcache.anno.method.CacheInvokeConfig;
import com.alicp.jetcache.anno.method.CacheInvokeContext;
import com.alicp.jetcache.anno.method.ClassUtil;
import com.alicp.jetcache.anno.method.ExpressionUtil;
import com.alicp.jetcache.anno.support.CacheContext;
import com.alicp.jetcache.anno.support.CacheInvalidateAnnoConfig;
import com.alicp.jetcache.anno.support.CacheUpdateAnnoConfig;
import com.alicp.jetcache.anno.support.CachedAnnoConfig;
import com.alicp.jetcache.anno.support.ConfigMap;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.event.CacheLoadEvent;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHandler
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(CacheHandler.class);
    private Object src;
    private Supplier<CacheInvokeContext> contextSupplier;
    private String[] hiddenPackages;
    private ConfigMap configMap;

    public CacheHandler(Object src, ConfigMap configMap, Supplier<CacheInvokeContext> contextSupplier, String[] hiddenPackages) {
        this.src = src;
        this.configMap = configMap;
        this.contextSupplier = contextSupplier;
        this.hiddenPackages = hiddenPackages;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        CacheInvokeContext context = null;
        String sig = ClassUtil.getMethodSig(method);
        CacheInvokeConfig cac = this.configMap.getByMethodInfo(sig);
        if (cac != null) {
            context = this.contextSupplier.get();
            context.setCacheInvokeConfig(cac);
        }
        if (context == null) {
            return method.invoke(this.src, args);
        }
        context.setInvoker(() -> method.invoke(this.src, args));
        context.setHiddenPackages(this.hiddenPackages);
        context.setArgs(args);
        context.setMethod(method);
        return CacheHandler.invoke(context);
    }

    public static Object invoke(CacheInvokeContext context) throws Throwable {
        if (context.getCacheInvokeConfig().isEnableCacheContext()) {
            try {
                CacheContextSupport._enable();
                Object object = CacheHandler.doInvoke(context);
                return object;
            }
            finally {
                CacheContextSupport._disable();
            }
        }
        return CacheHandler.doInvoke(context);
    }

    private static Object doInvoke(CacheInvokeContext context) throws Throwable {
        CacheInvokeConfig cic = context.getCacheInvokeConfig();
        CachedAnnoConfig cachedConfig = cic.getCachedAnnoConfig();
        if (cachedConfig != null && (cachedConfig.isEnabled() || CacheContextSupport._isEnabled())) {
            return CacheHandler.invokeWithCached(context);
        }
        if (cic.getInvalidateAnnoConfig() != null || cic.getUpdateAnnoConfig() != null) {
            return CacheHandler.invokeWithInvalidateOrUpdate(context);
        }
        return CacheHandler.invokeOrigin(context);
    }

    private static Object invokeWithInvalidateOrUpdate(CacheInvokeContext context) throws Throwable {
        CacheUpdateAnnoConfig updateAnnoConfig;
        Object originResult = CacheHandler.invokeOrigin(context);
        context.setResult(originResult);
        CacheInvokeConfig cic = context.getCacheInvokeConfig();
        if (cic.getInvalidateAnnoConfig() != null) {
            CacheHandler.doInvalidate(context, cic);
        }
        if ((updateAnnoConfig = cic.getUpdateAnnoConfig()) != null) {
            CacheHandler.doUpdate(context, updateAnnoConfig);
        }
        return originResult;
    }

    private static Iterable toIterable(Object obj) {
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return Arrays.asList((Object[])obj);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                list.add(Array.get(obj, i));
            }
            return list;
        }
        if (obj instanceof Iterable) {
            return (Iterable)obj;
        }
        return null;
    }

    private static void doInvalidate(CacheInvokeContext context, CacheInvokeConfig cic) {
        CacheInvalidateAnnoConfig annoConfig = cic.getInvalidateAnnoConfig();
        Cache cache = context.getCacheFunction().apply(context, annoConfig);
        if (cache == null) {
            return;
        }
        boolean condition = ExpressionUtil.evalCondition(context, annoConfig);
        if (!condition) {
            return;
        }
        Object key = ExpressionUtil.evalKey(context, annoConfig);
        if (key == null) {
            return;
        }
        if (annoConfig.isMulti()) {
            Iterable it = CacheHandler.toIterable(key);
            if (it == null) {
                logger.error("jetcache @CacheInvalidate key is not instance of Iterable or array: " + annoConfig.getDefineMethod());
                return;
            }
            HashSet keys = new HashSet();
            it.forEach(k -> keys.add(k));
            cache.removeAll(keys);
        } else {
            cache.remove(key);
        }
    }

    private static void doUpdate(CacheInvokeContext context, CacheUpdateAnnoConfig updateAnnoConfig) {
        Cache cache = context.getCacheFunction().apply(context, updateAnnoConfig);
        if (cache == null) {
            return;
        }
        boolean condition = ExpressionUtil.evalCondition(context, updateAnnoConfig);
        if (!condition) {
            return;
        }
        Object key = ExpressionUtil.evalKey(context, updateAnnoConfig);
        Object value = ExpressionUtil.evalValue(context, updateAnnoConfig);
        if (key == null || value == ExpressionUtil.EVAL_FAILED) {
            return;
        }
        if (updateAnnoConfig.isMulti()) {
            if (value == null) {
                return;
            }
            Iterable keyIt = CacheHandler.toIterable(key);
            Iterable valueIt = CacheHandler.toIterable(value);
            if (keyIt == null) {
                logger.error("jetcache @CacheUpdate key is not instance of Iterable or array: " + updateAnnoConfig.getDefineMethod());
                return;
            }
            if (valueIt == null) {
                logger.error("jetcache @CacheUpdate value is not instance of Iterable or array: " + updateAnnoConfig.getDefineMethod());
                return;
            }
            ArrayList keyList = new ArrayList();
            ArrayList valueList = new ArrayList();
            keyIt.forEach(o -> keyList.add(o));
            valueIt.forEach(o -> valueList.add(o));
            if (keyList.size() != valueList.size()) {
                logger.error("jetcache @CacheUpdate key size not equals with value size: " + updateAnnoConfig.getDefineMethod());
                return;
            }
            HashMap m = new HashMap();
            for (int i = 0; i < valueList.size(); ++i) {
                m.put(keyList.get(i), valueList.get(i));
            }
            cache.putAll(m);
        } else {
            cache.put(key, value);
        }
    }

    private static Object invokeWithCached(final CacheInvokeContext context) throws Throwable {
        final CacheInvokeConfig cic = context.getCacheInvokeConfig();
        CachedAnnoConfig cac = cic.getCachedAnnoConfig();
        Cache cache = context.getCacheFunction().apply(context, cac);
        if (cache == null) {
            logger.error("no cache with name: " + context.getMethod());
            return CacheHandler.invokeOrigin(context);
        }
        Object key = ExpressionUtil.evalKey(context, cic.getCachedAnnoConfig());
        if (key == null) {
            return CacheHandler.loadAndCount(context, cache, key);
        }
        if (!ExpressionUtil.evalCondition(context, cic.getCachedAnnoConfig())) {
            return CacheHandler.loadAndCount(context, cache, key);
        }
        try {
            CacheLoader loader = new CacheLoader(){

                public Object load(Object k) throws Throwable {
                    Object result = CacheHandler.invokeOrigin(context);
                    context.setResult(result);
                    return result;
                }

                public boolean vetoCacheUpdate() {
                    return !ExpressionUtil.evalPostCondition(context, cic.getCachedAnnoConfig());
                }
            };
            Object result = cache.computeIfAbsent(key, (Function)loader);
            return result;
        }
        catch (CacheInvokeException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadAndCount(CacheInvokeContext context, Cache cache, Object key) throws Throwable {
        long t = System.currentTimeMillis();
        Object v = null;
        boolean success = false;
        try {
            v = CacheHandler.invokeOrigin(context);
            success = true;
        }
        finally {
            t = System.currentTimeMillis() - t;
            CacheLoadEvent event = new CacheLoadEvent(cache, t, key, v, success);
            while (cache instanceof ProxyCache) {
                cache = ((ProxyCache)cache).getTargetCache();
            }
            if (cache instanceof AbstractCache) {
                ((AbstractCache)cache).notify((CacheEvent)event);
            }
        }
        return v;
    }

    private static Object invokeOrigin(CacheInvokeContext context) throws Throwable {
        return context.getInvoker().invoke();
    }

    public static class CacheHandlerRefreshCache<K, V>
    extends RefreshCache<K, V> {
        public CacheHandlerRefreshCache(Cache cache) {
            super(cache);
        }

        public void addOrUpdateRefreshTask(K key, CacheLoader<K, V> loader) {
            super.addOrUpdateRefreshTask(key, loader);
        }
    }

    private static class CacheContextSupport
    extends CacheContext {
        public CacheContextSupport() {
            super(null);
        }

        static void _enable() {
            CacheContextSupport.enable();
        }

        static void _disable() {
            CacheContextSupport.disable();
        }

        static boolean _isEnabled() {
            return CacheContextSupport.isEnabled();
        }
    }
}

