/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayEbppBillAddDefaultResponse;
import com.alipay.v3.model.AlipayEbppBillAddModel;
import com.alipay.v3.model.AlipayEbppBillAddResponseModel;
import com.alipay.v3.model.AlipayEbppBillGetDefaultResponse;
import com.alipay.v3.model.AlipayEbppBillGetResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayEbppBillApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayEbppBillApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayEbppBillApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addCall(String authToken, AlipayEbppBillAddModel alipayEbppBillAddModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayEbppBillAddModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayEbppBillAddModel;
        String localVarPath = "/v3/alipay/ebpp/bill/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("auth_token", authToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addValidateBeforeCall(String authToken, AlipayEbppBillAddModel alipayEbppBillAddModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.addCall(authToken, alipayEbppBillAddModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayEbppBillAddResponseModel add(String authToken, AlipayEbppBillAddModel alipayEbppBillAddModel) throws ApiException {
        ApiResponse<AlipayEbppBillAddResponseModel> localVarResp = this.addWithHttpInfo(authToken, alipayEbppBillAddModel, null);
        return localVarResp.getData();
    }

    public AlipayEbppBillAddResponseModel add(String authToken, AlipayEbppBillAddModel alipayEbppBillAddModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayEbppBillAddResponseModel> localVarResp = this.addWithHttpInfo(authToken, alipayEbppBillAddModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayEbppBillAddResponseModel> addWithHttpInfo(String authToken, AlipayEbppBillAddModel alipayEbppBillAddModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.addValidateBeforeCall(authToken, alipayEbppBillAddModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayEbppBillAddResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayEbppBillAddDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call addAsync(String authToken, AlipayEbppBillAddModel alipayEbppBillAddModel, ApiCallback<AlipayEbppBillAddResponseModel> _callback) throws ApiException {
        Call localVarCall = this.addValidateBeforeCall(authToken, alipayEbppBillAddModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayEbppBillAddResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call addAsync(String authToken, AlipayEbppBillAddModel alipayEbppBillAddModel, ApiCallback<AlipayEbppBillAddResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.addValidateBeforeCall(authToken, alipayEbppBillAddModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayEbppBillAddResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCall(String authToken, String orderType, String merchantOrderNo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/ebpp/bill/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("auth_token", authToken));
        }
        if (orderType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order_type", orderType));
        }
        if (merchantOrderNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("merchant_order_no", merchantOrderNo));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getValidateBeforeCall(String authToken, String orderType, String merchantOrderNo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.getCall(authToken, orderType, merchantOrderNo, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayEbppBillGetResponseModel get(String authToken, String orderType, String merchantOrderNo) throws ApiException {
        ApiResponse<AlipayEbppBillGetResponseModel> localVarResp = this.getWithHttpInfo(authToken, orderType, merchantOrderNo, null);
        return localVarResp.getData();
    }

    public AlipayEbppBillGetResponseModel get(String authToken, String orderType, String merchantOrderNo, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayEbppBillGetResponseModel> localVarResp = this.getWithHttpInfo(authToken, orderType, merchantOrderNo, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayEbppBillGetResponseModel> getWithHttpInfo(String authToken, String orderType, String merchantOrderNo, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(authToken, orderType, merchantOrderNo, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayEbppBillGetResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayEbppBillGetDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call getAsync(String authToken, String orderType, String merchantOrderNo, ApiCallback<AlipayEbppBillGetResponseModel> _callback) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(authToken, orderType, merchantOrderNo, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayEbppBillGetResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAsync(String authToken, String orderType, String merchantOrderNo, ApiCallback<AlipayEbppBillGetResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(authToken, orderType, merchantOrderNo, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayEbppBillGetResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

