/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayFundTransPayDefaultResponse;
import com.alipay.v3.model.AlipayFundTransPayModel;
import com.alipay.v3.model.AlipayFundTransPayResponseModel;
import com.alipay.v3.model.AlipayFundTransRefundDefaultResponse;
import com.alipay.v3.model.AlipayFundTransRefundModel;
import com.alipay.v3.model.AlipayFundTransRefundResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayFundTransApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayFundTransApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayFundTransApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call payCall(AlipayFundTransPayModel alipayFundTransPayModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayFundTransPayModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayFundTransPayModel;
        String localVarPath = "/v3/alipay/fund/trans/pay";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call payValidateBeforeCall(AlipayFundTransPayModel alipayFundTransPayModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.payCall(alipayFundTransPayModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayFundTransPayResponseModel pay(AlipayFundTransPayModel alipayFundTransPayModel) throws ApiException {
        ApiResponse<AlipayFundTransPayResponseModel> localVarResp = this.payWithHttpInfo(alipayFundTransPayModel, null);
        return localVarResp.getData();
    }

    public AlipayFundTransPayResponseModel pay(AlipayFundTransPayModel alipayFundTransPayModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayFundTransPayResponseModel> localVarResp = this.payWithHttpInfo(alipayFundTransPayModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayFundTransPayResponseModel> payWithHttpInfo(AlipayFundTransPayModel alipayFundTransPayModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.payValidateBeforeCall(alipayFundTransPayModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayFundTransPayResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayFundTransPayDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call payAsync(AlipayFundTransPayModel alipayFundTransPayModel, ApiCallback<AlipayFundTransPayResponseModel> _callback) throws ApiException {
        Call localVarCall = this.payValidateBeforeCall(alipayFundTransPayModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayFundTransPayResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call payAsync(AlipayFundTransPayModel alipayFundTransPayModel, ApiCallback<AlipayFundTransPayResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.payValidateBeforeCall(alipayFundTransPayModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayFundTransPayResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call refundCall(AlipayFundTransRefundModel alipayFundTransRefundModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayFundTransRefundModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayFundTransRefundModel;
        String localVarPath = "/v3/alipay/fund/trans/refund";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call refundValidateBeforeCall(AlipayFundTransRefundModel alipayFundTransRefundModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.refundCall(alipayFundTransRefundModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayFundTransRefundResponseModel refund(AlipayFundTransRefundModel alipayFundTransRefundModel) throws ApiException {
        ApiResponse<AlipayFundTransRefundResponseModel> localVarResp = this.refundWithHttpInfo(alipayFundTransRefundModel, null);
        return localVarResp.getData();
    }

    public AlipayFundTransRefundResponseModel refund(AlipayFundTransRefundModel alipayFundTransRefundModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayFundTransRefundResponseModel> localVarResp = this.refundWithHttpInfo(alipayFundTransRefundModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayFundTransRefundResponseModel> refundWithHttpInfo(AlipayFundTransRefundModel alipayFundTransRefundModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.refundValidateBeforeCall(alipayFundTransRefundModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayFundTransRefundResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayFundTransRefundDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call refundAsync(AlipayFundTransRefundModel alipayFundTransRefundModel, ApiCallback<AlipayFundTransRefundResponseModel> _callback) throws ApiException {
        Call localVarCall = this.refundValidateBeforeCall(alipayFundTransRefundModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayFundTransRefundResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call refundAsync(AlipayFundTransRefundModel alipayFundTransRefundModel, ApiCallback<AlipayFundTransRefundResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.refundValidateBeforeCall(alipayFundTransRefundModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayFundTransRefundResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

