/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayMarketingCardBenefitCreateDefaultResponse;
import com.alipay.v3.model.AlipayMarketingCardBenefitCreateModel;
import com.alipay.v3.model.AlipayMarketingCardBenefitCreateResponseModel;
import com.alipay.v3.model.AlipayMarketingCardBenefitDeleteDefaultResponse;
import com.alipay.v3.model.AlipayMarketingCardBenefitDeleteResponseModel;
import com.alipay.v3.model.AlipayMarketingCardBenefitModifyDefaultResponse;
import com.alipay.v3.model.AlipayMarketingCardBenefitModifyModel;
import com.alipay.v3.model.AlipayMarketingCardBenefitModifyResponseModel;
import com.alipay.v3.model.AlipayMarketingCardBenefitQueryDefaultResponse;
import com.alipay.v3.model.AlipayMarketingCardBenefitQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayMarketingCardBenefitApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayMarketingCardBenefitApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayMarketingCardBenefitApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCall(AlipayMarketingCardBenefitCreateModel alipayMarketingCardBenefitCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayMarketingCardBenefitCreateModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayMarketingCardBenefitCreateModel;
        String localVarPath = "/v3/alipay/marketing/card/benefit/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(AlipayMarketingCardBenefitCreateModel alipayMarketingCardBenefitCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createCall(alipayMarketingCardBenefitCreateModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayMarketingCardBenefitCreateResponseModel create(AlipayMarketingCardBenefitCreateModel alipayMarketingCardBenefitCreateModel) throws ApiException {
        ApiResponse<AlipayMarketingCardBenefitCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayMarketingCardBenefitCreateModel, null);
        return localVarResp.getData();
    }

    public AlipayMarketingCardBenefitCreateResponseModel create(AlipayMarketingCardBenefitCreateModel alipayMarketingCardBenefitCreateModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayMarketingCardBenefitCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayMarketingCardBenefitCreateModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayMarketingCardBenefitCreateResponseModel> createWithHttpInfo(AlipayMarketingCardBenefitCreateModel alipayMarketingCardBenefitCreateModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayMarketingCardBenefitCreateModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitCreateResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayMarketingCardBenefitCreateDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call createAsync(AlipayMarketingCardBenefitCreateModel alipayMarketingCardBenefitCreateModel, ApiCallback<AlipayMarketingCardBenefitCreateResponseModel> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayMarketingCardBenefitCreateModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createAsync(AlipayMarketingCardBenefitCreateModel alipayMarketingCardBenefitCreateModel, ApiCallback<AlipayMarketingCardBenefitCreateResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayMarketingCardBenefitCreateModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCall(String templateId, String benefitId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/marketing/card/benefit/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (templateId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("template_id", templateId));
        }
        if (benefitId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("benefit_id", benefitId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(String templateId, String benefitId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteCall(templateId, benefitId, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayMarketingCardBenefitDeleteResponseModel delete(String templateId, String benefitId) throws ApiException {
        ApiResponse<AlipayMarketingCardBenefitDeleteResponseModel> localVarResp = this.deleteWithHttpInfo(templateId, benefitId, null);
        return localVarResp.getData();
    }

    public AlipayMarketingCardBenefitDeleteResponseModel delete(String templateId, String benefitId, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayMarketingCardBenefitDeleteResponseModel> localVarResp = this.deleteWithHttpInfo(templateId, benefitId, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayMarketingCardBenefitDeleteResponseModel> deleteWithHttpInfo(String templateId, String benefitId, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(templateId, benefitId, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitDeleteResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayMarketingCardBenefitDeleteDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call deleteAsync(String templateId, String benefitId, ApiCallback<AlipayMarketingCardBenefitDeleteResponseModel> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(templateId, benefitId, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitDeleteResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAsync(String templateId, String benefitId, ApiCallback<AlipayMarketingCardBenefitDeleteResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(templateId, benefitId, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitDeleteResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyCall(AlipayMarketingCardBenefitModifyModel alipayMarketingCardBenefitModifyModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayMarketingCardBenefitModifyModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayMarketingCardBenefitModifyModel;
        String localVarPath = "/v3/alipay/marketing/card/benefit/modify";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyValidateBeforeCall(AlipayMarketingCardBenefitModifyModel alipayMarketingCardBenefitModifyModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.modifyCall(alipayMarketingCardBenefitModifyModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayMarketingCardBenefitModifyResponseModel modify(AlipayMarketingCardBenefitModifyModel alipayMarketingCardBenefitModifyModel) throws ApiException {
        ApiResponse<AlipayMarketingCardBenefitModifyResponseModel> localVarResp = this.modifyWithHttpInfo(alipayMarketingCardBenefitModifyModel, null);
        return localVarResp.getData();
    }

    public AlipayMarketingCardBenefitModifyResponseModel modify(AlipayMarketingCardBenefitModifyModel alipayMarketingCardBenefitModifyModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayMarketingCardBenefitModifyResponseModel> localVarResp = this.modifyWithHttpInfo(alipayMarketingCardBenefitModifyModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayMarketingCardBenefitModifyResponseModel> modifyWithHttpInfo(AlipayMarketingCardBenefitModifyModel alipayMarketingCardBenefitModifyModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.modifyValidateBeforeCall(alipayMarketingCardBenefitModifyModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitModifyResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayMarketingCardBenefitModifyDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call modifyAsync(AlipayMarketingCardBenefitModifyModel alipayMarketingCardBenefitModifyModel, ApiCallback<AlipayMarketingCardBenefitModifyResponseModel> _callback) throws ApiException {
        Call localVarCall = this.modifyValidateBeforeCall(alipayMarketingCardBenefitModifyModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitModifyResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyAsync(AlipayMarketingCardBenefitModifyModel alipayMarketingCardBenefitModifyModel, ApiCallback<AlipayMarketingCardBenefitModifyResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.modifyValidateBeforeCall(alipayMarketingCardBenefitModifyModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitModifyResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(String templateId, String benefitId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/marketing/card/benefit/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (templateId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("template_id", templateId));
        }
        if (benefitId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("benefit_id", benefitId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String templateId, String benefitId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(templateId, benefitId, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayMarketingCardBenefitQueryResponseModel query(String templateId, String benefitId) throws ApiException {
        ApiResponse<AlipayMarketingCardBenefitQueryResponseModel> localVarResp = this.queryWithHttpInfo(templateId, benefitId, null);
        return localVarResp.getData();
    }

    public AlipayMarketingCardBenefitQueryResponseModel query(String templateId, String benefitId, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayMarketingCardBenefitQueryResponseModel> localVarResp = this.queryWithHttpInfo(templateId, benefitId, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayMarketingCardBenefitQueryResponseModel> queryWithHttpInfo(String templateId, String benefitId, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(templateId, benefitId, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayMarketingCardBenefitQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(String templateId, String benefitId, ApiCallback<AlipayMarketingCardBenefitQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(templateId, benefitId, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(String templateId, String benefitId, ApiCallback<AlipayMarketingCardBenefitQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(templateId, benefitId, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardBenefitQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

