/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenSpIsvSignauthCreateDefaultResponse;
import com.alipay.v3.model.AlipayOpenSpIsvSignauthCreateModel;
import com.alipay.v3.model.AlipayOpenSpIsvSignauthCreateResponseModel;
import com.alipay.v3.model.AlipayOpenSpIsvSignauthQueryDefaultResponse;
import com.alipay.v3.model.AlipayOpenSpIsvSignauthQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenSpIsvSignauthApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenSpIsvSignauthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenSpIsvSignauthApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCall(AlipayOpenSpIsvSignauthCreateModel alipayOpenSpIsvSignauthCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenSpIsvSignauthCreateModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenSpIsvSignauthCreateModel;
        String localVarPath = "/v3/alipay/open/sp/isv/signauth/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(AlipayOpenSpIsvSignauthCreateModel alipayOpenSpIsvSignauthCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createCall(alipayOpenSpIsvSignauthCreateModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenSpIsvSignauthCreateResponseModel create(AlipayOpenSpIsvSignauthCreateModel alipayOpenSpIsvSignauthCreateModel) throws ApiException {
        ApiResponse<AlipayOpenSpIsvSignauthCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayOpenSpIsvSignauthCreateModel, null);
        return localVarResp.getData();
    }

    public AlipayOpenSpIsvSignauthCreateResponseModel create(AlipayOpenSpIsvSignauthCreateModel alipayOpenSpIsvSignauthCreateModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenSpIsvSignauthCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayOpenSpIsvSignauthCreateModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenSpIsvSignauthCreateResponseModel> createWithHttpInfo(AlipayOpenSpIsvSignauthCreateModel alipayOpenSpIsvSignauthCreateModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayOpenSpIsvSignauthCreateModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenSpIsvSignauthCreateResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenSpIsvSignauthCreateDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call createAsync(AlipayOpenSpIsvSignauthCreateModel alipayOpenSpIsvSignauthCreateModel, ApiCallback<AlipayOpenSpIsvSignauthCreateResponseModel> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayOpenSpIsvSignauthCreateModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenSpIsvSignauthCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createAsync(AlipayOpenSpIsvSignauthCreateModel alipayOpenSpIsvSignauthCreateModel, ApiCallback<AlipayOpenSpIsvSignauthCreateResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayOpenSpIsvSignauthCreateModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenSpIsvSignauthCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(String orderId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/sp/isv/signauth/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (orderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order_id", orderId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String orderId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(orderId, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenSpIsvSignauthQueryResponseModel query(String orderId) throws ApiException {
        ApiResponse<AlipayOpenSpIsvSignauthQueryResponseModel> localVarResp = this.queryWithHttpInfo(orderId, null);
        return localVarResp.getData();
    }

    public AlipayOpenSpIsvSignauthQueryResponseModel query(String orderId, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenSpIsvSignauthQueryResponseModel> localVarResp = this.queryWithHttpInfo(orderId, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenSpIsvSignauthQueryResponseModel> queryWithHttpInfo(String orderId, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(orderId, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenSpIsvSignauthQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenSpIsvSignauthQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(String orderId, ApiCallback<AlipayOpenSpIsvSignauthQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(orderId, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenSpIsvSignauthQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(String orderId, ApiCallback<AlipayOpenSpIsvSignauthQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(orderId, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenSpIsvSignauthQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

