/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenSpOperationResultQueryDefaultResponse;
import com.alipay.v3.model.AlipayOpenSpOperationResultQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenSpOperationResultApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenSpOperationResultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenSpOperationResultApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call queryCall(String operateType, String batchNo, String accessProductCode, String merchantNo, String alipayAccount, String isvScenePermissions, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/sp/operation/result/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (operateType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("operate_type", operateType));
        }
        if (batchNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("batch_no", batchNo));
        }
        if (accessProductCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("access_product_code", accessProductCode));
        }
        if (merchantNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("merchant_no", merchantNo));
        }
        if (alipayAccount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("alipay_account", alipayAccount));
        }
        if (isvScenePermissions != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("isv_scene_permissions", isvScenePermissions));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String operateType, String batchNo, String accessProductCode, String merchantNo, String alipayAccount, String isvScenePermissions, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(operateType, batchNo, accessProductCode, merchantNo, alipayAccount, isvScenePermissions, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenSpOperationResultQueryResponseModel query(String operateType, String batchNo, String accessProductCode, String merchantNo, String alipayAccount, String isvScenePermissions) throws ApiException {
        ApiResponse<AlipayOpenSpOperationResultQueryResponseModel> localVarResp = this.queryWithHttpInfo(operateType, batchNo, accessProductCode, merchantNo, alipayAccount, isvScenePermissions, null);
        return localVarResp.getData();
    }

    public AlipayOpenSpOperationResultQueryResponseModel query(String operateType, String batchNo, String accessProductCode, String merchantNo, String alipayAccount, String isvScenePermissions, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenSpOperationResultQueryResponseModel> localVarResp = this.queryWithHttpInfo(operateType, batchNo, accessProductCode, merchantNo, alipayAccount, isvScenePermissions, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenSpOperationResultQueryResponseModel> queryWithHttpInfo(String operateType, String batchNo, String accessProductCode, String merchantNo, String alipayAccount, String isvScenePermissions, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(operateType, batchNo, accessProductCode, merchantNo, alipayAccount, isvScenePermissions, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenSpOperationResultQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenSpOperationResultQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(String operateType, String batchNo, String accessProductCode, String merchantNo, String alipayAccount, String isvScenePermissions, ApiCallback<AlipayOpenSpOperationResultQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(operateType, batchNo, accessProductCode, merchantNo, alipayAccount, isvScenePermissions, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenSpOperationResultQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(String operateType, String batchNo, String accessProductCode, String merchantNo, String alipayAccount, String isvScenePermissions, ApiCallback<AlipayOpenSpOperationResultQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(operateType, batchNo, accessProductCode, merchantNo, alipayAccount, isvScenePermissions, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenSpOperationResultQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

