/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayTradeOrderPayDefaultResponse;
import com.alipay.v3.model.AlipayTradeOrderPayModel;
import com.alipay.v3.model.AlipayTradeOrderPayResponseModel;
import com.alipay.v3.model.AlipayTradeOrderSettleDefaultResponse;
import com.alipay.v3.model.AlipayTradeOrderSettleModel;
import com.alipay.v3.model.AlipayTradeOrderSettleResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayTradeOrderApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayTradeOrderApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayTradeOrderApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call payCall(AlipayTradeOrderPayModel alipayTradeOrderPayModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayTradeOrderPayModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayTradeOrderPayModel;
        String localVarPath = "/v3/alipay/trade/order/pay";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call payValidateBeforeCall(AlipayTradeOrderPayModel alipayTradeOrderPayModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.payCall(alipayTradeOrderPayModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayTradeOrderPayResponseModel pay(AlipayTradeOrderPayModel alipayTradeOrderPayModel) throws ApiException {
        ApiResponse<AlipayTradeOrderPayResponseModel> localVarResp = this.payWithHttpInfo(alipayTradeOrderPayModel, null);
        return localVarResp.getData();
    }

    public AlipayTradeOrderPayResponseModel pay(AlipayTradeOrderPayModel alipayTradeOrderPayModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayTradeOrderPayResponseModel> localVarResp = this.payWithHttpInfo(alipayTradeOrderPayModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayTradeOrderPayResponseModel> payWithHttpInfo(AlipayTradeOrderPayModel alipayTradeOrderPayModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.payValidateBeforeCall(alipayTradeOrderPayModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayTradeOrderPayResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayTradeOrderPayDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call payAsync(AlipayTradeOrderPayModel alipayTradeOrderPayModel, ApiCallback<AlipayTradeOrderPayResponseModel> _callback) throws ApiException {
        Call localVarCall = this.payValidateBeforeCall(alipayTradeOrderPayModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayTradeOrderPayResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call payAsync(AlipayTradeOrderPayModel alipayTradeOrderPayModel, ApiCallback<AlipayTradeOrderPayResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.payValidateBeforeCall(alipayTradeOrderPayModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayTradeOrderPayResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call settleCall(AlipayTradeOrderSettleModel alipayTradeOrderSettleModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayTradeOrderSettleModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayTradeOrderSettleModel;
        String localVarPath = "/v3/alipay/trade/order/settle";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call settleValidateBeforeCall(AlipayTradeOrderSettleModel alipayTradeOrderSettleModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.settleCall(alipayTradeOrderSettleModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayTradeOrderSettleResponseModel settle(AlipayTradeOrderSettleModel alipayTradeOrderSettleModel) throws ApiException {
        ApiResponse<AlipayTradeOrderSettleResponseModel> localVarResp = this.settleWithHttpInfo(alipayTradeOrderSettleModel, null);
        return localVarResp.getData();
    }

    public AlipayTradeOrderSettleResponseModel settle(AlipayTradeOrderSettleModel alipayTradeOrderSettleModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayTradeOrderSettleResponseModel> localVarResp = this.settleWithHttpInfo(alipayTradeOrderSettleModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayTradeOrderSettleResponseModel> settleWithHttpInfo(AlipayTradeOrderSettleModel alipayTradeOrderSettleModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.settleValidateBeforeCall(alipayTradeOrderSettleModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayTradeOrderSettleResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayTradeOrderSettleDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call settleAsync(AlipayTradeOrderSettleModel alipayTradeOrderSettleModel, ApiCallback<AlipayTradeOrderSettleResponseModel> _callback) throws ApiException {
        Call localVarCall = this.settleValidateBeforeCall(alipayTradeOrderSettleModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayTradeOrderSettleResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call settleAsync(AlipayTradeOrderSettleModel alipayTradeOrderSettleModel, ApiCallback<AlipayTradeOrderSettleResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.settleValidateBeforeCall(alipayTradeOrderSettleModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayTradeOrderSettleResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

