/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayUserAgreementMigrateDefaultResponse;
import com.alipay.v3.model.AlipayUserAgreementMigrateModel;
import com.alipay.v3.model.AlipayUserAgreementQueryDefaultResponse;
import com.alipay.v3.model.AlipayUserAgreementQueryResponseModel;
import com.alipay.v3.model.AlipayUserAgreementTransferDefaultResponse;
import com.alipay.v3.model.AlipayUserAgreementTransferModel;
import com.alipay.v3.model.AlipayUserAgreementTransferResponseModel;
import com.alipay.v3.model.AlipayUserAgreementUnsignDefaultResponse;
import com.alipay.v3.model.AlipayUserAgreementUnsignModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayUserAgreementApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayUserAgreementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayUserAgreementApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call migrateCall(AlipayUserAgreementMigrateModel alipayUserAgreementMigrateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayUserAgreementMigrateModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayUserAgreementMigrateModel;
        String localVarPath = "/v3/alipay/user/agreement/migrate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call migrateValidateBeforeCall(AlipayUserAgreementMigrateModel alipayUserAgreementMigrateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.migrateCall(alipayUserAgreementMigrateModel, _callback, customizedParams);
        return localVarCall;
    }

    public Object migrate(AlipayUserAgreementMigrateModel alipayUserAgreementMigrateModel) throws ApiException {
        ApiResponse<Object> localVarResp = this.migrateWithHttpInfo(alipayUserAgreementMigrateModel, null);
        return localVarResp.getData();
    }

    public Object migrate(AlipayUserAgreementMigrateModel alipayUserAgreementMigrateModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.migrateWithHttpInfo(alipayUserAgreementMigrateModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> migrateWithHttpInfo(AlipayUserAgreementMigrateModel alipayUserAgreementMigrateModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.migrateValidateBeforeCall(alipayUserAgreementMigrateModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayUserAgreementMigrateDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call migrateAsync(AlipayUserAgreementMigrateModel alipayUserAgreementMigrateModel, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.migrateValidateBeforeCall(alipayUserAgreementMigrateModel, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call migrateAsync(AlipayUserAgreementMigrateModel alipayUserAgreementMigrateModel, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.migrateValidateBeforeCall(alipayUserAgreementMigrateModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(String personalProductCode, String alipayUserId, String alipayOpenId, String alipayLogonId, String signScene, String externalAgreementNo, String thirdPartyType, String agreementNo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/user/agreement/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (personalProductCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("personal_product_code", personalProductCode));
        }
        if (alipayUserId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("alipay_user_id", alipayUserId));
        }
        if (alipayOpenId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("alipay_open_id", alipayOpenId));
        }
        if (alipayLogonId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("alipay_logon_id", alipayLogonId));
        }
        if (signScene != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sign_scene", signScene));
        }
        if (externalAgreementNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("external_agreement_no", externalAgreementNo));
        }
        if (thirdPartyType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("third_party_type", thirdPartyType));
        }
        if (agreementNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("agreement_no", agreementNo));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String personalProductCode, String alipayUserId, String alipayOpenId, String alipayLogonId, String signScene, String externalAgreementNo, String thirdPartyType, String agreementNo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(personalProductCode, alipayUserId, alipayOpenId, alipayLogonId, signScene, externalAgreementNo, thirdPartyType, agreementNo, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayUserAgreementQueryResponseModel query(String personalProductCode, String alipayUserId, String alipayOpenId, String alipayLogonId, String signScene, String externalAgreementNo, String thirdPartyType, String agreementNo) throws ApiException {
        ApiResponse<AlipayUserAgreementQueryResponseModel> localVarResp = this.queryWithHttpInfo(personalProductCode, alipayUserId, alipayOpenId, alipayLogonId, signScene, externalAgreementNo, thirdPartyType, agreementNo, null);
        return localVarResp.getData();
    }

    public AlipayUserAgreementQueryResponseModel query(String personalProductCode, String alipayUserId, String alipayOpenId, String alipayLogonId, String signScene, String externalAgreementNo, String thirdPartyType, String agreementNo, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayUserAgreementQueryResponseModel> localVarResp = this.queryWithHttpInfo(personalProductCode, alipayUserId, alipayOpenId, alipayLogonId, signScene, externalAgreementNo, thirdPartyType, agreementNo, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayUserAgreementQueryResponseModel> queryWithHttpInfo(String personalProductCode, String alipayUserId, String alipayOpenId, String alipayLogonId, String signScene, String externalAgreementNo, String thirdPartyType, String agreementNo, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(personalProductCode, alipayUserId, alipayOpenId, alipayLogonId, signScene, externalAgreementNo, thirdPartyType, agreementNo, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayUserAgreementQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayUserAgreementQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(String personalProductCode, String alipayUserId, String alipayOpenId, String alipayLogonId, String signScene, String externalAgreementNo, String thirdPartyType, String agreementNo, ApiCallback<AlipayUserAgreementQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(personalProductCode, alipayUserId, alipayOpenId, alipayLogonId, signScene, externalAgreementNo, thirdPartyType, agreementNo, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayUserAgreementQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(String personalProductCode, String alipayUserId, String alipayOpenId, String alipayLogonId, String signScene, String externalAgreementNo, String thirdPartyType, String agreementNo, ApiCallback<AlipayUserAgreementQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(personalProductCode, alipayUserId, alipayOpenId, alipayLogonId, signScene, externalAgreementNo, thirdPartyType, agreementNo, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayUserAgreementQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call transferCall(AlipayUserAgreementTransferModel alipayUserAgreementTransferModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayUserAgreementTransferModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayUserAgreementTransferModel;
        String localVarPath = "/v3/alipay/user/agreement/transfer";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call transferValidateBeforeCall(AlipayUserAgreementTransferModel alipayUserAgreementTransferModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.transferCall(alipayUserAgreementTransferModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayUserAgreementTransferResponseModel transfer(AlipayUserAgreementTransferModel alipayUserAgreementTransferModel) throws ApiException {
        ApiResponse<AlipayUserAgreementTransferResponseModel> localVarResp = this.transferWithHttpInfo(alipayUserAgreementTransferModel, null);
        return localVarResp.getData();
    }

    public AlipayUserAgreementTransferResponseModel transfer(AlipayUserAgreementTransferModel alipayUserAgreementTransferModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayUserAgreementTransferResponseModel> localVarResp = this.transferWithHttpInfo(alipayUserAgreementTransferModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayUserAgreementTransferResponseModel> transferWithHttpInfo(AlipayUserAgreementTransferModel alipayUserAgreementTransferModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.transferValidateBeforeCall(alipayUserAgreementTransferModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayUserAgreementTransferResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayUserAgreementTransferDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call transferAsync(AlipayUserAgreementTransferModel alipayUserAgreementTransferModel, ApiCallback<AlipayUserAgreementTransferResponseModel> _callback) throws ApiException {
        Call localVarCall = this.transferValidateBeforeCall(alipayUserAgreementTransferModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayUserAgreementTransferResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call transferAsync(AlipayUserAgreementTransferModel alipayUserAgreementTransferModel, ApiCallback<AlipayUserAgreementTransferResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.transferValidateBeforeCall(alipayUserAgreementTransferModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayUserAgreementTransferResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unsignCall(AlipayUserAgreementUnsignModel alipayUserAgreementUnsignModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayUserAgreementUnsignModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayUserAgreementUnsignModel;
        String localVarPath = "/v3/alipay/user/agreement/unsign";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unsignValidateBeforeCall(AlipayUserAgreementUnsignModel alipayUserAgreementUnsignModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unsignCall(alipayUserAgreementUnsignModel, _callback, customizedParams);
        return localVarCall;
    }

    public Object unsign(AlipayUserAgreementUnsignModel alipayUserAgreementUnsignModel) throws ApiException {
        ApiResponse<Object> localVarResp = this.unsignWithHttpInfo(alipayUserAgreementUnsignModel, null);
        return localVarResp.getData();
    }

    public Object unsign(AlipayUserAgreementUnsignModel alipayUserAgreementUnsignModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.unsignWithHttpInfo(alipayUserAgreementUnsignModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> unsignWithHttpInfo(AlipayUserAgreementUnsignModel alipayUserAgreementUnsignModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unsignValidateBeforeCall(alipayUserAgreementUnsignModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayUserAgreementUnsignDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call unsignAsync(AlipayUserAgreementUnsignModel alipayUserAgreementUnsignModel, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.unsignValidateBeforeCall(alipayUserAgreementUnsignModel, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unsignAsync(AlipayUserAgreementUnsignModel alipayUserAgreementUnsignModel, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unsignValidateBeforeCall(alipayUserAgreementUnsignModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

