/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.util.schema.model.attribute;

import com.alipay.v3.util.schema.exception.SchemaException;
import com.alipay.v3.util.schema.model.attribute.Attribute;
import com.alipay.v3.util.schema.model.attribute.ComplexAttribute;
import com.alipay.v3.util.schema.model.enums.AttrTypeEnum;
import com.alipay.v3.util.schema.model.enums.SchemaErrorEnum;
import com.alipay.v3.util.schema.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class MultiComplexAttribute
extends Attribute {
    private List<ComplexAttribute> attributes = new ArrayList<ComplexAttribute>();

    public void addAttributes(ComplexAttribute complexAttribute) {
        this.attributes.add(complexAttribute);
    }

    @Override
    public Element toElement() throws SchemaException {
        this.checkAttribute();
        Element attrNode = XmlUtils.createRootElement("attribute");
        attrNode.addAttribute("id", this.getId());
        attrNode.addAttribute("name", this.getName());
        attrNode.addAttribute("type", this.getType().getType());
        attrNode.addAttribute("valueType", "object");
        for (ComplexAttribute complexAttribute : this.attributes) {
            Element attributesNode = XmlUtils.appendElement(attrNode, "attributes");
            for (Attribute attribute : complexAttribute.getAttributes()) {
                Element attributeElm = XmlUtils.appendElement(attributesNode, "attribute");
                attributeElm.addAttribute("id", attribute.getId());
                attributeElm.addAttribute("name", attribute.getName());
                if (attribute.getType() == null) {
                    throw new SchemaException(SchemaErrorEnum.ATTR_MISS_TYPE, this.getId());
                }
                attributeElm.addAttribute("type", attribute.getType().getType());
                if (attribute.getValueType() == null) {
                    throw new SchemaException(SchemaErrorEnum.ATTR_VALUETYPE_ERROR, this.getId());
                }
                attributeElm.addAttribute("valueType", attribute.getValueType().getCode());
                this.appendRulesElement(attributeElm, attribute.getRules(), attribute.getId());
                this.appendOptionsElement(attributeElm, attribute.getOptions(), attribute.getId());
                this.appendAttributeValues(attribute, attributeElm);
            }
        }
        return attrNode;
    }

    @Override
    public Element toValueElement() throws SchemaException {
        this.checkAttribute();
        Element attrNode = XmlUtils.createRootElement("attribute");
        attrNode.addAttribute("id", this.getId());
        attrNode.addAttribute("name", this.getName());
        attrNode.addAttribute("type", this.getType().getType());
        attrNode.addAttribute("valueType", "object");
        for (ComplexAttribute complexAttribute : this.attributes) {
            Element attributesNode = XmlUtils.appendElement(attrNode, "attributes");
            for (Attribute attribute : complexAttribute.getAttributes()) {
                Element attributeElm = XmlUtils.appendElement(attributesNode, "attribute");
                attributeElm.addAttribute("id", attribute.getId());
                attributeElm.addAttribute("name", attribute.getName());
                if (attribute.getType() == null) {
                    throw new SchemaException(SchemaErrorEnum.ATTR_MISS_TYPE, this.getId());
                }
                attributeElm.addAttribute("type", attribute.getType().getType());
                if (attribute.getValueType() == null) {
                    throw new SchemaException(SchemaErrorEnum.ATTR_VALUETYPE_ERROR, this.getId());
                }
                attributeElm.addAttribute("valueType", attribute.getValueType().getCode());
                this.appendAttributeValues(attribute, attributeElm);
            }
        }
        return attrNode;
    }

    public ComplexAttribute cloneAttribute() throws SchemaException {
        if (this.getAttributes() == null || this.getAttributes().size() <= 0) {
            throw new SchemaException(SchemaErrorEnum.SYSTEM_ERROR, this.getId());
        }
        ComplexAttribute complexAttribute = this.getAttributes().get(0);
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
        for (Attribute attribute : complexAttribute.getAttributes()) {
            Attribute newAttribute = AttrTypeEnum.createAttribute(attribute.getType());
            newAttribute.setId(attribute.getId());
            newAttribute.setName(attribute.getName());
            newAttribute.setValueType(attribute.getValueType());
            newAttribute.setOptions(attribute.getOptions());
            newAttribute.setRules(attribute.getRules());
            newAttributes.add(newAttribute);
        }
        ComplexAttribute newComplexAttribute = new ComplexAttribute();
        newComplexAttribute.setId(complexAttribute.getId());
        newComplexAttribute.setName(complexAttribute.getName());
        newComplexAttribute.setType(complexAttribute.getType());
        newComplexAttribute.setValueType(complexAttribute.getValueType());
        newComplexAttribute.setRules(complexAttribute.getRules());
        newComplexAttribute.setOptions(complexAttribute.getOptions());
        newComplexAttribute.setAttributes(newAttributes);
        return newComplexAttribute;
    }

    public List<ComplexAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<ComplexAttribute> attributes) {
        this.attributes = attributes;
    }
}

