/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.service.schema.api;

import com.alipay.service.schema.api.ServiceSchemaFactory;
import com.alipay.service.schema.exception.ServiceSchemaException;
import com.alipay.service.schema.model.attribute.Attribute;
import com.alipay.service.schema.model.attribute.ComplexAttribute;
import com.alipay.service.schema.model.attribute.MultiAttribute;
import com.alipay.service.schema.model.attribute.MultiComplexAttribute;
import com.alipay.service.schema.model.attribute.SingleAttribute;
import com.alipay.service.schema.model.enums.AttrRuleTypeEnum;
import com.alipay.service.schema.model.enums.AttrTypeEnum;
import com.alipay.service.schema.model.enums.AttrValueTypeEnum;
import com.alipay.service.schema.model.enums.SchemaErrorEnum;
import com.alipay.service.schema.model.option.Option;
import com.alipay.service.schema.model.rule.AttributeRule;
import com.alipay.service.schema.util.StringUtil;
import com.alipay.service.schema.util.XmlUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class ServiceSchemaReader {
    public static Map<String, Attribute> readXmlForMap(File file) throws ServiceSchemaException {
        Element rootEle = XmlUtils.getRootElementFromFile(file);
        return ServiceSchemaReader.readXmlForMap(rootEle);
    }

    public static Map<String, Attribute> readXmlForMap(String xmlStirng) throws ServiceSchemaException {
        Element rootEle = XmlUtils.getRootElementFromString(xmlStirng);
        return ServiceSchemaReader.readXmlForMap(rootEle);
    }

    public static List<Attribute> readXmlForList(File file) throws ServiceSchemaException {
        Element rootEle = XmlUtils.getRootElementFromFile(file);
        return ServiceSchemaReader.readXmlForList(rootEle);
    }

    public static List<Attribute> readXmlForList(String xmlStirng) throws ServiceSchemaException {
        Element rootEle = XmlUtils.getRootElementFromString(xmlStirng);
        return ServiceSchemaReader.readXmlForList(rootEle);
    }

    public static List<Attribute> readXmlForList(Element rootEle) throws ServiceSchemaException {
        List<Attribute> attributeList = ServiceSchemaFactory.createEmptyAttributeList();
        List<Element> attributeElmList = XmlUtils.getChildElements(rootEle, "attribute");
        for (Element attrElm : attributeElmList) {
            Attribute attribute = ServiceSchemaReader.elementToAttribute(attrElm);
            attributeList.add(attribute);
        }
        return attributeList;
    }

    public static Map<String, Attribute> readXmlForMap(Element rootEle) throws ServiceSchemaException {
        HashMap<String, Attribute> attributeMap = new HashMap<String, Attribute>();
        List<Element> attributeElmList = XmlUtils.getChildElements(rootEle, "attribute");
        for (Element attributeElm : attributeElmList) {
            Attribute attribute = ServiceSchemaReader.elementToAttribute(attributeElm);
            attributeMap.put(attribute.getId(), attribute);
        }
        return attributeMap;
    }

    public static Attribute elementToAttribute(Element attributeElm) throws ServiceSchemaException {
        if (attributeElm == null) {
            return null;
        }
        String attributeId = XmlUtils.getAttributeValue(attributeElm, "id");
        if (StringUtil.isEmpty(attributeId)) {
            String msg = SchemaErrorEnum.ATTR_MISS_ID.getErrorMessage() + "\u76f8\u5173xml\u7247\u6bb5 [" + attributeElm.asXML() + "]";
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_MISS_ID.getErrorCode(), msg);
        }
        String attributeType = XmlUtils.getAttributeValue(attributeElm, "type");
        if (StringUtil.isEmpty(attributeType)) {
            String msg = SchemaErrorEnum.ATTR_MISS_TYPE.getErrorMessage() + "\u76f8\u5173xml\u7247\u6bb5 [" + attributeElm.asXML() + "].attributeId=" + attributeId;
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_MISS_TYPE.getErrorCode(), msg, attributeId);
        }
        String attributeName = XmlUtils.getAttributeValue(attributeElm, "name");
        String valueType = XmlUtils.getAttributeValue(attributeElm, "valueType");
        AttrValueTypeEnum valueTypeEnum = AttrValueTypeEnum.getByCode(valueType);
        if (valueTypeEnum == null) {
            String msg = SchemaErrorEnum.ATTR_VALUETYPE_ERROR.getErrorMessage() + "\u76f8\u5173xml\u7247\u6bb5 [" + attributeElm.asXML() + "].attributeId=" + attributeId;
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_VALUETYPE_ERROR.getErrorCode(), msg, attributeId);
        }
        AttrTypeEnum attributeTypeEnum = AttrTypeEnum.getType(attributeType);
        if (attributeTypeEnum == null) {
            String msg = SchemaErrorEnum.ATTR_TYPE_ERROR.getErrorMessage() + "\u76f8\u5173xml\u7247\u6bb5[" + attributeElm.asXML() + "].attributeId=" + attributeId;
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_TYPE_ERROR.getErrorCode(), msg, attributeId);
        }
        Attribute attribute_result = null;
        switch (attributeTypeEnum) {
            case SINGLE: {
                attribute_result = ServiceSchemaReader.elementToSingleAttribute(attributeElm, attributeId, attributeName, valueTypeEnum);
                break;
            }
            case MULTI: {
                attribute_result = ServiceSchemaReader.elementToMultiAttribute(attributeElm, attributeId, attributeName, valueTypeEnum);
                break;
            }
            case COMPLEX: {
                attribute_result = ServiceSchemaReader.elementToComplexAttribute(attributeElm, attributeId, attributeName, valueTypeEnum);
                break;
            }
            case MULTICOMPLEX: {
                attribute_result = ServiceSchemaReader.elementToMultiComplexAttribute(attributeElm, attributeId, attributeName, valueTypeEnum);
            }
        }
        return attribute_result;
    }

    private static AttributeRule elementToRule(Element ruleEle, String attributeId) throws ServiceSchemaException {
        if (ruleEle == null) {
            return null;
        }
        String ruleType = XmlUtils.getAttributeValue(ruleEle, "type");
        if (StringUtil.isEmpty(ruleType)) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_RULE_TYPE_ERROR, attributeId);
        }
        String ruleValue = XmlUtils.getAttributeValue(ruleEle, "value");
        if (StringUtil.isEmpty(ruleValue)) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_RULE_VALUE_ERROR, attributeId);
        }
        AttributeRule rule = null;
        AttrRuleTypeEnum ruleTypeEnum = AttrRuleTypeEnum.getType(ruleType);
        if (ruleTypeEnum == null) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_RULE_TYPE_ERROR, attributeId);
        }
        rule = ServiceSchemaFactory.createRule(ruleTypeEnum);
        rule.setType(ruleTypeEnum);
        rule.setName(XmlUtils.getAttributeValue(ruleEle, "name"));
        rule.setValue(ruleValue);
        return rule;
    }

    private static Option elementToOption(Element optionEle, String attributeId) throws ServiceSchemaException {
        Option opResult = new Option();
        String displayName = XmlUtils.getAttributeValue(optionEle, "displayName");
        if (StringUtil.isEmpty(displayName)) {
            throw new ServiceSchemaException(SchemaErrorEnum.OPTION_NAME_ERROR, attributeId);
        }
        String value = XmlUtils.getAttributeValue(optionEle, "value");
        if (StringUtil.isEmpty(value)) {
            throw new ServiceSchemaException(SchemaErrorEnum.OPTION_VALUE_ERROR, attributeId);
        }
        opResult.setDisplayName(displayName);
        opResult.setValue(value);
        return opResult;
    }

    private static SingleAttribute elementToSingleAttribute(Element attributeElm, String attributeId, String attributeName, AttrValueTypeEnum valueType) throws ServiceSchemaException {
        Element value;
        Element optionsEle;
        if (attributeElm == null) {
            return null;
        }
        SingleAttribute singleAttribute = (SingleAttribute)ServiceSchemaFactory.createAttribute(AttrTypeEnum.SINGLE);
        singleAttribute.setId(attributeId);
        singleAttribute.setName(attributeName);
        singleAttribute.setValueType(valueType);
        Element rulesEle = XmlUtils.getChildElement(attributeElm, "rules");
        if (rulesEle != null) {
            List<Element> ruleEleList = XmlUtils.getChildElements(rulesEle, "rule");
            for (Element ruleEle : ruleEleList) {
                AttributeRule rule = ServiceSchemaReader.elementToRule(ruleEle, singleAttribute.getId());
                singleAttribute.addRule(rule);
            }
        }
        if ((optionsEle = XmlUtils.getChildElement(attributeElm, "options")) != null) {
            List<Element> optionEleList = XmlUtils.getChildElements(optionsEle, "option");
            for (Element optionEleEle : optionEleList) {
                Option op = ServiceSchemaReader.elementToOption(optionEleEle, singleAttribute.getId());
                singleAttribute.addOption(op);
            }
        }
        if ((value = XmlUtils.getChildElement(attributeElm, "value")) != null) {
            singleAttribute.setValue(XmlUtils.getElementValue(value));
        }
        return singleAttribute;
    }

    private static MultiAttribute elementToMultiAttribute(Element attrElm, String attrId, String attrName, AttrValueTypeEnum valueType) throws ServiceSchemaException {
        Element valuesEle;
        if (attrElm == null) {
            return null;
        }
        MultiAttribute multiAttr = (MultiAttribute)ServiceSchemaFactory.createAttribute(AttrTypeEnum.MULTI);
        multiAttr.setId(attrId);
        multiAttr.setName(attrName);
        multiAttr.setValueType(valueType);
        Element rulesEle = XmlUtils.getChildElement(attrElm, "rules");
        if (rulesEle != null) {
            List<Element> ruleEleList = XmlUtils.getChildElements(rulesEle, "rule");
            for (Element ruleEle : ruleEleList) {
                AttributeRule rule = ServiceSchemaReader.elementToRule(ruleEle, multiAttr.getId());
                multiAttr.addRule(rule);
            }
        }
        if ((valuesEle = XmlUtils.getChildElement(attrElm, "values")) != null) {
            List<Element> valueEleList = XmlUtils.getChildElements(valuesEle, "value");
            for (Element valueEle : valueEleList) {
                String value = XmlUtils.getElementValue(valueEle);
                multiAttr.addValue(value);
            }
        }
        return multiAttr;
    }

    private static MultiComplexAttribute elementToMultiComplexAttribute(Element attributeElm, String attributeId, String attributeName, AttrValueTypeEnum valueType) throws ServiceSchemaException {
        Element rulesEle;
        if (attributeElm == null) {
            return null;
        }
        MultiComplexAttribute multiComplexAttribute = (MultiComplexAttribute)ServiceSchemaFactory.createAttribute(AttrTypeEnum.MULTICOMPLEX);
        multiComplexAttribute.setId(attributeId);
        multiComplexAttribute.setName(attributeName);
        multiComplexAttribute.setValueType(valueType);
        List<Element> attributesList = XmlUtils.getChildElements(attributeElm, "attributes");
        if (attributesList != null) {
            for (Element attributes : attributesList) {
                ComplexAttribute complexAttribute = new ComplexAttribute();
                List<Element> attributeEleList = XmlUtils.getChildElements(attributes, "attribute");
                for (Element subAttributeEle : attributeEleList) {
                    Attribute attrFromEle = ServiceSchemaReader.elementToAttribute(subAttributeEle);
                    complexAttribute.addAttribute(attrFromEle);
                }
                multiComplexAttribute.addAttributes(complexAttribute);
            }
        }
        if ((rulesEle = XmlUtils.getChildElement(attributeElm, "rules")) != null) {
            List<Element> ruleEleList = XmlUtils.getChildElements(rulesEle, "rule");
            for (Element ruleEle : ruleEleList) {
                AttributeRule rule = ServiceSchemaReader.elementToRule(ruleEle, multiComplexAttribute.getId());
                multiComplexAttribute.addRule(rule);
            }
        }
        return multiComplexAttribute;
    }

    private static ComplexAttribute elementToComplexAttribute(Element attrElm, String attrId, String attrName, AttrValueTypeEnum valueType) throws ServiceSchemaException {
        Element rulesEle;
        if (attrElm == null) {
            return null;
        }
        ComplexAttribute complexAttr = (ComplexAttribute)ServiceSchemaFactory.createAttribute(AttrTypeEnum.COMPLEX);
        complexAttr.setId(attrId);
        complexAttr.setName(attrName);
        complexAttr.setValueType(valueType);
        Element attributesEle = XmlUtils.getChildElement(attrElm, "attributes");
        if (attributesEle != null) {
            List<Element> attributeEleList = XmlUtils.getChildElements(attributesEle, "attribute");
            for (Element subAttributeEle : attributeEleList) {
                Attribute attributeFromEle = ServiceSchemaReader.elementToAttribute(subAttributeEle);
                complexAttr.addAttribute(attributeFromEle);
            }
        }
        if ((rulesEle = XmlUtils.getChildElement(attrElm, "rules")) != null) {
            List<Element> ruleEleList = XmlUtils.getChildElements(rulesEle, "rule");
            for (Element ruleEle : ruleEleList) {
                AttributeRule rule = ServiceSchemaReader.elementToRule(ruleEle, complexAttr.getId());
                complexAttr.addRule(rule);
            }
        }
        return complexAttr;
    }
}

