/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api.composite;

import com.alipay.lookout.api.DistributionSummary;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.api.composite.CompositeMetric;
import java.util.Collection;
import java.util.Iterator;

class CompositeDistributionSummary
extends CompositeMetric
implements DistributionSummary {
    public CompositeDistributionSummary(Id id, Collection<Registry> registries) {
        super(id, registries);
    }

    @Override
    public void record(long amount) {
        for (Registry r : this.registries) {
            this.getMetric(r).record(amount);
        }
    }

    @Override
    public long count() {
        Iterator it = this.registries.iterator();
        return it.hasNext() ? this.getMetric((Registry)it.next()).count() : 0L;
    }

    @Override
    public long totalAmount() {
        Iterator it = this.registries.iterator();
        return it.hasNext() ? this.getMetric((Registry)it.next()).totalAmount() : 0L;
    }

    @Override
    public void buckets(long[] buckets) {
        for (Registry r : this.registries) {
            this.getMetric(r).buckets(buckets);
        }
    }

    protected DistributionSummary getMetric(Registry registry) {
        return registry.distributionSummary(this.id);
    }
}

