/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.net;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;

public class NetUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtil.class);
    public static final String LOCALHOST = "127.0.0.1";
    public static final String ANYHOST = "0.0.0.0";
    public static final char COLON = ':';
    private static volatile InetAddress LOCAL_ADDRESS = null;
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    public static final String NETWORK_INTERFACE_BINDING = "network_interface_binding";
    public static final String NETWORK_INTERFACE_BINDING_VALUE = System.getProperty("network_interface_binding");
    public static final String NETWORK_INTERFACE_DENYLIST = "network_interface_denylist";
    public static final List<String> NETWORK_INTERFACE_DENYLIST_VALUE = System.getProperty("network_interface_denylist") == null ? Collections.emptyList() : Arrays.asList(System.getProperty("network_interface_denylist").split(","));

    public static String genHost(String ip, int port) {
        return ip + ':' + port;
    }

    public static InetSocketAddress getLocalSocketAddress() {
        InetAddress address = NetUtil.getLocalAddress();
        String addressStr = address == null ? LOCALHOST : address.getHostAddress();
        return new InetSocketAddress(addressStr, 0);
    }

    public static String getIPAddressFromDomain(String domain) {
        try {
            InetAddress a = InetAddress.getByName(domain);
            if (LOCALHOST.equalsIgnoreCase(a.getHostAddress())) {
                a = NetUtil.getLocalAddress();
            }
            return a.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unknown host {" + domain + "}");
        }
    }

    public static String getDomainFromIP(String ip) {
        try {
            InetAddress a = InetAddress.getByName(ip);
            return a.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.error("[NetWorkUtils] Can not resolve ip " + ip + ". error is .", e);
            return null;
        }
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetUtil.getLocalAddress0();
        return localAddress;
    }

    public static String toAddressString(InetSocketAddress address) {
        if (address == null || address.getAddress() == null) {
            LOGGER.error("InetSocketAddress to Address String error!In put inetSocketAddress or InetSocketAddress.getAddress is null");
            throw new RuntimeException("InetSocketAddress to Address String error!In put inetSocketAddress or InetSocketAddress.getAddress is null!");
        }
        return address.getAddress().getHostAddress() + ':' + address.getPort();
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && !LOCALHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    private static InetAddress getLocalAddress0() {
        InetAddress localAddress = null;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    try {
                        Enumeration<InetAddress> addresses;
                        boolean useNi;
                        NetworkInterface network = interfaces.nextElement();
                        if (NETWORK_INTERFACE_BINDING_VALUE != null && !NETWORK_INTERFACE_BINDING_VALUE.isEmpty()) {
                            if (!NETWORK_INTERFACE_BINDING_VALUE.equals(network.getDisplayName()) && !NETWORK_INTERFACE_BINDING_VALUE.equals(network.getName())) continue;
                            useNi = true;
                        } else {
                            if (NETWORK_INTERFACE_DENYLIST_VALUE.contains(network.getDisplayName()) || NETWORK_INTERFACE_DENYLIST_VALUE.contains(network.getName())) continue;
                            useNi = true;
                        }
                        if ((addresses = network.getInetAddresses()) == null) continue;
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress address = addresses.nextElement();
                                if (!useNi || !NetUtil.isValidAddress(address)) continue;
                                return address;
                            }
                            catch (Throwable e) {
                                LOGGER.warn("Failed to retriving ip address, " + e.getMessage(), e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Failed to retriving ip address, " + e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to retriving ip address, " + e.getMessage(), e);
        }
        LOGGER.error("Could not get local host ip address, will use 127.0.0.1 instead.");
        return localAddress;
    }
}

