/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.timer;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncHashedWheelTimer
extends HashedWheelTimer {
    private final Executor executor;
    private final TaskFailedCallback taskFailedCallback;

    public AsyncHashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, ThreadFactory asyncThreadFactory, TaskFailedCallback taskFailedCallback) {
        super(threadFactory, tickDuration, unit, ticksPerWheel);
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), asyncThreadFactory);
        this.taskFailedCallback = taskFailedCallback;
    }

    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        return super.newTimeout((TimerTask)new AsyncTimerTask(task), delay, unit);
    }

    public static interface TaskFailedCallback {
        public void executionRejected(Throwable var1);

        public void executionFailed(Throwable var1);
    }

    class AsyncTimerTask
    implements TimerTask,
    Runnable {
        TimerTask timerTask;
        Timeout timeout;

        public AsyncTimerTask(TimerTask timerTask) {
            this.timerTask = timerTask;
        }

        public void run(Timeout timeout) throws Exception {
            this.timeout = timeout;
            try {
                AsyncHashedWheelTimer.this.executor.execute(this);
            }
            catch (RejectedExecutionException e) {
                AsyncHashedWheelTimer.this.taskFailedCallback.executionRejected(e);
            }
            catch (Throwable e) {
                AsyncHashedWheelTimer.this.taskFailedCallback.executionRejected(e);
            }
        }

        @Override
        public void run() {
            try {
                this.timerTask.run(this.timeout);
            }
            catch (Throwable e) {
                AsyncHashedWheelTimer.this.taskFailedCallback.executionFailed(e);
            }
        }
    }
}

