/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.common;

import com.alipay.sofa.rpc.boot.log.SofaBootRpcLoggerFactory;
import com.alipay.sofa.rpc.log.LogCodes;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class SofaBootRpcSpringUtil {
    private static final Logger LOGGER = SofaBootRpcLoggerFactory.getLogger(SofaBootRpcSpringUtil.class);

    public static Object getSpringBean(String beanRef, String beanClass, ApplicationContext applicationContext, ClassLoader appClassLoader, String appName) {
        Object callbackHandler = null;
        callbackHandler = SofaBootRpcSpringUtil.getSpringBean(beanRef, applicationContext, appClassLoader, appName);
        if (callbackHandler == null && StringUtils.hasText((String)beanClass)) {
            callbackHandler = SofaBootRpcSpringUtil.newInstance(beanClass, appClassLoader, appName);
        }
        return callbackHandler;
    }

    public static Object getSpringBean(String beanRef, ApplicationContext applicationContext, ClassLoader appClassLoader, String appName) {
        Object object = null;
        if (StringUtils.hasText((String)beanRef)) {
            if (applicationContext == null) {
                LOGGER.error("get bean from spring failed. beanRef[" + beanRef + "];classLoader[" + appClassLoader + "];appName[" + appName + "]");
            } else {
                object = applicationContext.getBean(beanRef);
            }
        }
        return object;
    }

    public static Object newInstance(String clazz, ClassLoader loader, String appName) {
        if (!StringUtils.hasText((String)clazz)) {
            return null;
        }
        try {
            return Class.forName(clazz, true, loader).newInstance();
        }
        catch (Exception e) {
            LOGGER.error("new instance failed. clazz[" + clazz + "];classLoader[" + loader + "];appName[" + appName + "]", (Throwable)e);
            throw new RuntimeException(LogCodes.getLog((String)"019990005", (Object[])new Object[]{clazz}), e);
        }
    }
}

