/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.config;

import com.alipay.sofa.rpc.boot.common.RegistryParseUtil;
import com.alipay.sofa.rpc.boot.config.RegistryConfigureProcessor;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfigConstants;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.RegistryConfig;
import java.util.Map;

public class ZookeeperConfigurator
implements RegistryConfigureProcessor {
    @Override
    public RegistryConfig buildFromAddress(String address) {
        String zkAddress = RegistryParseUtil.parseAddress(address, "zookeeper");
        Map<String, String> map = RegistryParseUtil.parseParam(address, "zookeeper");
        String file = map.get("file");
        if (StringUtils.isEmpty((CharSequence)file)) {
            file = SofaBootRpcConfigConstants.REGISTRY_FILE_PATH_DEFAULT;
        }
        return new RegistryConfig().setAddress(zkAddress).setFile(file).setProtocol("zookeeper").setParameters(map);
    }

    @Override
    public String registryType() {
        return "zookeeper";
    }
}

