/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.rpc.boot.common.NetworkAddressUtil;
import com.alipay.sofa.rpc.boot.common.RpcThreadPoolMonitor;
import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfigConstants;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcProperties;
import com.alipay.sofa.rpc.boot.log.SofaBootRpcLoggerFactory;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.server.Server;
import com.alipay.sofa.rpc.server.bolt.BoltServer;
import com.alipay.sofa.rpc.server.triple.TripleServer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class ServerConfigContainer {
    private static final Logger LOGGER = SofaBootRpcLoggerFactory.getLogger(ServerConfigContainer.class);
    private SofaBootRpcProperties sofaBootRpcProperties;
    private volatile ServerConfig boltServerConfig;
    private final Object BOLT_LOCK = new Object();
    private volatile ServerConfig restServerConfig;
    private final Object REST_LOCK = new Object();
    private volatile ServerConfig dubboServerConfig;
    private final Object DUBBO_LOCK = new Object();
    private volatile ServerConfig h2cServerConfig;
    private final Object H2C_LOCK = new Object();
    private volatile ServerConfig httpServerConfig;
    private final Object HTTP_LOCK = new Object();
    private volatile ServerConfig tripleServerConfig;
    private final Object TRIPLE_LOCK = new Object();
    private Map<String, ServerConfig> customServerConfigs = new ConcurrentHashMap<String, ServerConfig>();
    private RpcThreadPoolMonitor boltThreadPoolMonitor = new RpcThreadPoolMonitor("RPC-BOLT-THREADPOOL");
    private RpcThreadPoolMonitor tripleThreadPoolMonitor = new RpcThreadPoolMonitor("RPC-TRIPLE-THREADPOOL");

    public ServerConfigContainer(SofaBootRpcProperties sofaBootRpcProperties) {
        this.sofaBootRpcProperties = sofaBootRpcProperties;
        NetworkAddressUtil.caculate(sofaBootRpcProperties.getEnabledIpRange(), sofaBootRpcProperties.getBindNetworkInterface());
    }

    public void startServers() {
        ThreadPoolExecutor threadPoolExecutor;
        if (this.boltServerConfig != null) {
            this.boltServerConfig.buildIfAbsent().start();
            BoltServer server = (BoltServer)this.boltServerConfig.getServer();
            threadPoolExecutor = server.getBizThreadPool();
            if (threadPoolExecutor != null) {
                this.boltThreadPoolMonitor.setThreadPoolExecutor(threadPoolExecutor);
                this.boltThreadPoolMonitor.start();
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("the business threadpool can not be get");
            }
        }
        if (this.restServerConfig != null) {
            this.restServerConfig.buildIfAbsent().start();
        }
        if (this.h2cServerConfig != null) {
            this.h2cServerConfig.buildIfAbsent().start();
        }
        if (this.httpServerConfig != null) {
            this.httpServerConfig.buildIfAbsent().start();
        }
        if (this.tripleServerConfig != null) {
            this.tripleServerConfig.buildIfAbsent().start();
            TripleServer tripleServer = (TripleServer)this.tripleServerConfig.getServer();
            threadPoolExecutor = tripleServer.getBizThreadPool();
            if (threadPoolExecutor != null) {
                this.tripleThreadPoolMonitor.setThreadPoolExecutor(threadPoolExecutor);
                this.tripleThreadPoolMonitor.start();
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("the business threadpool can not be get");
            }
        }
        for (Map.Entry<String, ServerConfig> entry : this.customServerConfigs.entrySet()) {
            ServerConfig serverConfig = entry.getValue();
            if (serverConfig == null) continue;
            serverConfig.buildIfAbsent().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConfig getServerConfig(String protocol) {
        if (protocol.equalsIgnoreCase("bolt")) {
            if (this.boltServerConfig == null) {
                Object object = this.BOLT_LOCK;
                synchronized (object) {
                    if (this.boltServerConfig == null) {
                        this.boltServerConfig = this.createBoltServerConfig();
                    }
                }
            }
            return this.boltServerConfig;
        }
        if (protocol.equalsIgnoreCase("rest")) {
            if (this.restServerConfig == null) {
                Object object = this.REST_LOCK;
                synchronized (object) {
                    if (this.restServerConfig == null) {
                        this.restServerConfig = this.createRestServerConfig();
                    }
                }
            }
            return this.restServerConfig;
        }
        if (protocol.equalsIgnoreCase("dubbo")) {
            if (this.dubboServerConfig == null) {
                Object object = this.DUBBO_LOCK;
                synchronized (object) {
                    if (this.dubboServerConfig == null) {
                        this.dubboServerConfig = this.createDubboServerConfig();
                    }
                }
            }
            return this.dubboServerConfig;
        }
        if (protocol.equalsIgnoreCase("h2c")) {
            if (this.h2cServerConfig == null) {
                Object object = this.H2C_LOCK;
                synchronized (object) {
                    if (this.h2cServerConfig == null) {
                        this.h2cServerConfig = this.createH2cServerConfig();
                    }
                }
            }
            return this.h2cServerConfig;
        }
        if (protocol.equalsIgnoreCase("http")) {
            if (this.httpServerConfig == null) {
                Object object = this.HTTP_LOCK;
                synchronized (object) {
                    if (this.httpServerConfig == null) {
                        this.httpServerConfig = this.createHttpServerConfig();
                    }
                }
            }
            return this.httpServerConfig;
        }
        if (protocol.equalsIgnoreCase("tri")) {
            if (this.tripleServerConfig == null) {
                Object object = this.TRIPLE_LOCK;
                synchronized (object) {
                    if (this.tripleServerConfig == null) {
                        this.tripleServerConfig = this.createTripleServerConfig();
                    }
                }
            }
            return this.tripleServerConfig;
        }
        if (this.customServerConfigs.get(protocol) != null) {
            return this.customServerConfigs.get(protocol);
        }
        throw new SofaBootRpcRuntimeException(LogCodes.getLog((String)"019990027", (Object[])new Object[]{protocol}));
    }

    private void addCommonServerConfig(ServerConfig serverConfig) {
        String boundHostStr = this.sofaBootRpcProperties.getBoundHost();
        String virtualHostStr = this.sofaBootRpcProperties.getVirtualHost();
        String virtualPortStr = this.sofaBootRpcProperties.getVirtualPort();
        serverConfig.setVirtualHost(NetworkAddressUtil.getLocalIP());
        serverConfig.setBoundHost(NetworkAddressUtil.getLocalBindIP());
        if (StringUtils.hasText((String)boundHostStr)) {
            serverConfig.setBoundHost(boundHostStr);
        }
        if (StringUtils.hasText((String)virtualHostStr)) {
            serverConfig.setVirtualHost(virtualHostStr);
        }
        if (StringUtils.hasText((String)virtualPortStr)) {
            serverConfig.setVirtualPort(Integer.valueOf(Integer.parseInt(virtualPortStr)));
        }
    }

    ServerConfig createH2cServerConfig() {
        String portStr = this.sofaBootRpcProperties.getH2cPort();
        String h2cThreadPoolCoreSizeStr = this.sofaBootRpcProperties.getH2cThreadPoolCoreSize();
        String h2cThreadPoolMaxSizeStr = this.sofaBootRpcProperties.getH2cThreadPoolMaxSize();
        String acceptsSizeStr = this.sofaBootRpcProperties.getH2cAcceptsSize();
        String h2cThreadPoolQueueSizeStr = this.sofaBootRpcProperties.getH2cThreadPoolQueueSize();
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)portStr)) {
            serverConfig.setPort(Integer.parseInt(portStr));
        } else {
            serverConfig.setPort(12300);
        }
        if (StringUtils.hasText((String)h2cThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(h2cThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)h2cThreadPoolCoreSizeStr)) {
            serverConfig.setCoreThreads(Integer.parseInt(h2cThreadPoolCoreSizeStr));
        }
        if (StringUtils.hasText((String)acceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(acceptsSizeStr));
        }
        if (StringUtils.hasText((String)h2cThreadPoolQueueSizeStr)) {
            serverConfig.setQueues(Integer.parseInt(h2cThreadPoolQueueSizeStr));
        }
        serverConfig.setAutoStart(false);
        this.addCommonServerConfig(serverConfig);
        serverConfig.setProtocol("h2c");
        return serverConfig;
    }

    public ServerConfig createBoltServerConfig() {
        String portStr = this.sofaBootRpcProperties.getBoltPort();
        String boltThreadPoolCoreSizeStr = this.sofaBootRpcProperties.getBoltThreadPoolCoreSize();
        String boltThreadPoolMaxSizeStr = this.sofaBootRpcProperties.getBoltThreadPoolMaxSize();
        String acceptsSizeStr = this.sofaBootRpcProperties.getBoltAcceptsSize();
        String boltThreadPoolQueueSizeStr = this.sofaBootRpcProperties.getBoltThreadPoolQueueSize();
        Boolean boltProcessInIoThread = this.sofaBootRpcProperties.getBoltProcessInIoThread();
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)portStr)) {
            serverConfig.setPort(Integer.parseInt(portStr));
        } else {
            serverConfig.setPort(12200);
        }
        if (StringUtils.hasText((String)boltThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(boltThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)boltThreadPoolCoreSizeStr)) {
            serverConfig.setCoreThreads(Integer.parseInt(boltThreadPoolCoreSizeStr));
        }
        if (StringUtils.hasText((String)acceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(acceptsSizeStr));
        }
        if (StringUtils.hasText((String)boltThreadPoolQueueSizeStr)) {
            serverConfig.setQueues(Integer.parseInt(boltThreadPoolQueueSizeStr));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (boltProcessInIoThread != null) {
            parameters.put("processInIOThread", boltProcessInIoThread.toString());
        }
        serverConfig.setParameters(parameters);
        serverConfig.setAutoStart(false);
        serverConfig.setProtocol("bolt");
        this.addCommonServerConfig(serverConfig);
        return serverConfig;
    }

    public ServerConfig createRestServerConfig() {
        String hostName = this.sofaBootRpcProperties.getRestHostname();
        String portStr = this.sofaBootRpcProperties.getRestPort();
        String ioThreadSizeStr = this.sofaBootRpcProperties.getRestIoThreadSize();
        String contextPath = this.sofaBootRpcProperties.getRestContextPath();
        String restThreadPoolMaxSizeStr = this.sofaBootRpcProperties.getRestThreadPoolMaxSize();
        String maxRequestSizeStr = this.sofaBootRpcProperties.getRestMaxRequestSize();
        String telnetStr = this.sofaBootRpcProperties.getRestTelnet();
        String daemonStr = this.sofaBootRpcProperties.getRestDaemon();
        String allowedOrigins = this.sofaBootRpcProperties.getRestAllowedOrigins();
        if (!StringUtils.hasText((String)hostName)) {
            hostName = null;
        }
        int port = !StringUtils.hasText((String)portStr) ? 8341 : Integer.parseInt(portStr);
        int ioThreadCount = !StringUtils.hasText((String)ioThreadSizeStr) ? SofaBootRpcConfigConstants.REST_IO_THREAD_COUNT_DEFAULT : Integer.parseInt(ioThreadSizeStr);
        int restThreadPoolMaxSize = !StringUtils.hasText((String)restThreadPoolMaxSizeStr) ? 200 : Integer.parseInt(restThreadPoolMaxSizeStr);
        int maxRequestSize = !StringUtils.hasText((String)maxRequestSizeStr) ? 0xA00000 : Integer.parseInt(maxRequestSizeStr);
        boolean telnet = !StringUtils.hasText((String)telnetStr) ? true : Boolean.parseBoolean(telnetStr);
        boolean daemon = !StringUtils.hasText((String)daemonStr) ? true : Boolean.parseBoolean(daemonStr);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringUtils.hasText((String)allowedOrigins)) {
            parameters.put("allowedOrigins", allowedOrigins);
        }
        ServerConfig serverConfig = new ServerConfig().setPort(port).setIoThreads(ioThreadCount).setMaxThreads(restThreadPoolMaxSize).setPayload(maxRequestSize).setTelnet(telnet).setDaemon(daemon).setParameters(parameters);
        if (!StringUtils.isEmpty((Object)contextPath)) {
            serverConfig.setContextPath(contextPath);
        }
        serverConfig.setAutoStart(false);
        serverConfig.setProtocol("rest");
        this.addCommonServerConfig(serverConfig);
        serverConfig.setBoundHost(hostName);
        return serverConfig;
    }

    public ServerConfig createDubboServerConfig() {
        String portStr = this.sofaBootRpcProperties.getDubboPort();
        String ioThreadSizeStr = this.sofaBootRpcProperties.getDubboIoThreadSize();
        String dubboThreadPoolMaxSizeStr = this.sofaBootRpcProperties.getDubboThreadPoolMaxSize();
        String dubboAcceptsSizeStr = this.sofaBootRpcProperties.getDubboAcceptsSize();
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)portStr)) {
            serverConfig.setPort(Integer.parseInt(portStr));
        } else {
            serverConfig.setPort(20880);
        }
        if (StringUtils.hasText((String)ioThreadSizeStr)) {
            serverConfig.setIoThreads(Integer.parseInt(ioThreadSizeStr));
        }
        if (StringUtils.hasText((String)dubboThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(dubboThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)dubboAcceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(dubboAcceptsSizeStr));
        }
        serverConfig.setAutoStart(false);
        serverConfig.setProtocol("dubbo");
        this.addCommonServerConfig(serverConfig);
        return serverConfig;
    }

    ServerConfig createHttpServerConfig() {
        String portStr = this.sofaBootRpcProperties.getHttpPort();
        String httpThreadPoolCoreSizeStr = this.sofaBootRpcProperties.getHttpThreadPoolCoreSize();
        String httpThreadPoolMaxSizeStr = this.sofaBootRpcProperties.getHttpThreadPoolMaxSize();
        String acceptsSizeStr = this.sofaBootRpcProperties.getHttpAcceptsSize();
        String httpThreadPoolQueueSizeStr = this.sofaBootRpcProperties.getHttpThreadPoolQueueSize();
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)portStr)) {
            serverConfig.setPort(Integer.parseInt(portStr));
        } else {
            serverConfig.setPort(12400);
        }
        if (StringUtils.hasText((String)httpThreadPoolCoreSizeStr)) {
            serverConfig.setCoreThreads(Integer.parseInt(httpThreadPoolCoreSizeStr));
        }
        if (StringUtils.hasText((String)httpThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(httpThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)acceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(acceptsSizeStr));
        }
        if (StringUtils.hasText((String)httpThreadPoolQueueSizeStr)) {
            serverConfig.setQueues(Integer.parseInt(httpThreadPoolQueueSizeStr));
        }
        serverConfig.setAutoStart(false);
        this.addCommonServerConfig(serverConfig);
        serverConfig.setProtocol("http");
        return serverConfig;
    }

    private ServerConfig createTripleServerConfig() {
        String portStr = this.sofaBootRpcProperties.getTriplePort();
        String threadPoolCoreSizeStr = this.sofaBootRpcProperties.getTripleThreadPoolCoreSize();
        String threadPoolMaxSizeStr = this.sofaBootRpcProperties.getTripleThreadPoolMaxSize();
        String acceptsSizeStr = this.sofaBootRpcProperties.getTripleAcceptsSize();
        String threadPoolQueueSizeStr = this.sofaBootRpcProperties.getTripleThreadPoolQueueSize();
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)portStr)) {
            serverConfig.setPort(Integer.parseInt(portStr));
        } else {
            serverConfig.setPort(50051);
        }
        if (StringUtils.hasText((String)threadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(threadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)threadPoolCoreSizeStr)) {
            serverConfig.setCoreThreads(Integer.parseInt(threadPoolCoreSizeStr));
        }
        if (StringUtils.hasText((String)acceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(acceptsSizeStr));
        }
        if (StringUtils.hasText((String)threadPoolQueueSizeStr)) {
            serverConfig.setQueues(Integer.parseInt(threadPoolQueueSizeStr));
        }
        serverConfig.setAutoStart(false);
        serverConfig.setProtocol("tri");
        this.addCommonServerConfig(serverConfig);
        return serverConfig;
    }

    public void closeAllServer() {
        if (this.boltThreadPoolMonitor != null) {
            this.boltThreadPoolMonitor.stop();
        }
        if (this.tripleThreadPoolMonitor != null) {
            this.tripleThreadPoolMonitor.stop();
        }
        this.destroyServerConfig(this.boltServerConfig);
        this.destroyServerConfig(this.restServerConfig);
        this.destroyServerConfig(this.dubboServerConfig);
        this.destroyServerConfig(this.h2cServerConfig);
        this.destroyServerConfig(this.tripleServerConfig);
        for (Map.Entry<String, ServerConfig> entry : this.customServerConfigs.entrySet()) {
            ServerConfig serverConfig = entry.getValue();
            this.destroyServerConfig(serverConfig);
        }
        this.boltServerConfig = null;
        this.restServerConfig = null;
        this.dubboServerConfig = null;
        this.h2cServerConfig = null;
        this.tripleServerConfig = null;
        this.customServerConfigs.clear();
    }

    private void destroyServerConfig(ServerConfig serverConfig) {
        Server server;
        if (serverConfig != null && (server = serverConfig.getServer()) != null && server.hasNoEntry()) {
            serverConfig.destroy();
        }
    }

    public boolean registerCustomServerConfig(String protocol, ServerConfig serverConfig) {
        if (this.customServerConfigs.containsKey(protocol)) {
            return false;
        }
        this.customServerConfigs.put(protocol, serverConfig);
        return true;
    }

    public boolean unRegisterCustomServerConfig(String protocol) {
        this.customServerConfigs.remove(protocol);
        return true;
    }
}

