/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.adapter;

import com.alipay.sofa.rpc.boot.container.ProviderConfigContainer;
import com.alipay.sofa.rpc.boot.runtime.adapter.RpcBindingAdapter;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBinding;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBindingType;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.spi.binding.Contract;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import org.springframework.context.ApplicationContext;

public class DubboBindingAdapter
extends RpcBindingAdapter {
    public BindingType getBindingType() {
        return RpcBindingType.DUBBO_BINDING_TYPE;
    }

    @Override
    public Object outBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        return Boolean.TRUE;
    }

    @Override
    public void postUnoutBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        try {
            ApplicationContext applicationContext = sofaRuntimeContext.getSofaRuntimeManager().getRootApplicationContext();
            ProviderConfigContainer providerConfigContainer = (ProviderConfigContainer)applicationContext.getBean(ProviderConfigContainer.class);
            String key = providerConfigContainer.createUniqueName((Contract)contract, binding);
            providerConfigContainer.removeProviderConfig(key);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"010000009"), (Throwable)e);
        }
    }
}

