/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.annotation;

import com.alipay.sofa.runtime.annotation.PlaceHolderBinder;
import com.alipay.sofa.runtime.annotation.WrapperAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class PlaceHolderAnnotationInvocationHandler
implements InvocationHandler {
    private final Annotation delegate;
    private final PlaceHolderBinder binder;

    private PlaceHolderAnnotationInvocationHandler(Annotation delegate, PlaceHolderBinder binder) {
        this.delegate = delegate;
        this.binder = binder;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = method.invoke((Object)this.delegate, args);
        if (!ReflectionUtils.isEqualsMethod((Method)method) && !ReflectionUtils.isHashCodeMethod((Method)method) && !ReflectionUtils.isToStringMethod((Method)method) && this.isAttributeMethod(method)) {
            return this.resolvePlaceHolder(ret);
        }
        return ret;
    }

    private boolean isAttributeMethod(Method method) {
        return method != null && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    public Object resolvePlaceHolder(Object origin) {
        if (origin.getClass().isArray()) {
            int length = Array.getLength(origin);
            Object ret = Array.newInstance(origin.getClass().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(ret, i, this.resolvePlaceHolder(Array.get(origin, i)));
            }
            return ret;
        }
        return this.doResolvePlaceHolder(origin);
    }

    private Object doResolvePlaceHolder(Object origin) {
        if (origin instanceof String) {
            return this.binder.bind((String)origin);
        }
        if (origin instanceof Annotation && !(origin instanceof WrapperAnnotation)) {
            return AnnotationWrapperBuilder.wrap(origin).withBinder(this.binder).build();
        }
        return origin;
    }

    public static class AnnotationWrapperBuilder<A> {
        private Annotation delegate;
        private PlaceHolderBinder binder;

        private AnnotationWrapperBuilder() {
        }

        public static <A> AnnotationWrapperBuilder wrap(A annotation) {
            Assert.isTrue((annotation == null || annotation instanceof Annotation ? 1 : 0) != 0, (String)"Parameter must be annotation type.");
            AnnotationWrapperBuilder<A> builder = new AnnotationWrapperBuilder<A>();
            builder.delegate = (Annotation)annotation;
            return builder;
        }

        public AnnotationWrapperBuilder withBinder(PlaceHolderBinder binder) {
            this.binder = binder;
            return this;
        }

        public A build() {
            if (this.delegate != null) {
                ClassLoader cl = this.delegate.getClass().getClassLoader();
                Class[] exposedInterface = new Class[]{this.delegate.annotationType(), WrapperAnnotation.class};
                return (A)Proxy.newProxyInstance(cl, exposedInterface, (InvocationHandler)new PlaceHolderAnnotationInvocationHandler(this.delegate, this.binder));
            }
            return null;
        }
    }
}

